/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.tables;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.swing.ImageIcon;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.Sequenced;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryGroupTriggerLink;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.queries.tables.TableGroupQueries;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroupHelper;
import ordermate.database.tables.TableGroupTriggerLink;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;

@Entity
@Table(name="config_table_group")
@AccessType(value="property")
public class TableGroup
extends PersistentDisplayableObject
implements Saveable,
Lockable,
TriggerActivated {
    private static final long serialVersionUID = 1L;
    public static final Props Properties = new Props();
    public static final String DEFAULT_BG_IMAGE = "/ordermate/images/greyBreadLarge.png";
    public static final String DEFAULT_TABLE_IMAGE = "/ordermate/images/tableMedium.png";
    private PersistentWriteableList<LogicalTable> logicalTables;
    private String systemState;
    private String name;
    private int sequence;
    private String backgroundImage;
    private String tableImage;
    private long reloadNum;
    private String extId;
    private Reference<User> user;
    private boolean online = false;
    private long currentReloadNumber;
    private transient TableGroupHelper helper;
    private TriggerActivationStrategy triggerActivationStrategy;
    private PersistentWriteableList<TableGroupTriggerLink> triggerLinks;

    @Deprecated
    public TableGroup() {
        this.triggerLinks = this.createWriteableList(TableGroup.Properties.TRIGGER_LINKS);
    }

    public TableGroup(String groupName) {
        this.triggerLinks = this.createWriteableList(TableGroup.Properties.TRIGGER_LINKS);
        this.systemState = "ACTIVE";
        this.backgroundImage = DEFAULT_BG_IMAGE;
        this.tableImage = DEFAULT_TABLE_IMAGE;
        this.user = this.createReference(TableGroup.Properties.USER);
        this.logicalTables = this.createWriteableList(TableGroup.Properties.LOGICAL_TABLES);
        this.name = groupName;
        this.triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
        this.addTrigger(AbstractTrigger.getDefaultTriggerIfExists());
    }

    @Override
    public void init() {
        super.init();
        this.currentReloadNumber = this.reloadNum;
    }

    @Override
    public void delete() {
        TableGroupQueries.clearCache();
        SystemCurrentInfo.setTablesUpdate("Table group deleted");
        this.systemState = "DELETED";
        this.logicalTables.deleteChild();
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        TableGroupQueries.clearCache();
        SystemCurrentInfo.setTablesUpdate("Table group created");
        PersistenceManager.save(this);
        ++this.reloadNum;
        PersistenceManager.getPersistenceDelegate().executeUpdate("UPDATE config_table_group SET reload_num = reload_num + 1 WHERE ID = ? ", new Object[]{this.getID()});
        this.logicalTables.saveChild();
        this.triggerLinks.saveChild();
    }

    @Override
    @Transient
    public User getUser() {
        return this.user.get();
    }

    @Override
    @Transient
    public boolean isLocked() {
        return !this.user.isNull();
    }

    @Override
    public boolean isLocked(User byUser) {
        return !this.user.isNull() && this.user.getObjectID().equals(PersistenceManager.getID(byUser));
    }

    @Transient
    public boolean isReloadRequired() {
        this.reloadSyncState();
        return this.currentReloadNumber != this.reloadNum;
    }

    public static void incrementAllReloadNum() {
        PersistenceManager.getPersistenceDelegate().executeUpdate("UPDATE config_table_group SET reload_num = reload_num + 1 ", null);
    }

    public void incrementReloadNum() {
        ++this.reloadNum;
        PersistenceManager.getPersistenceDelegate().executeUpdate("UPDATE config_table_group SET reload_num = reload_num + 1 WHERE ID = ? ", new Object[]{this.getID()});
    }

    public void reloadSyncState() {
        if (this.isPersistent()) {
            String query = Query.select(TableGroup.Properties.USER).select(TableGroup.Properties.RELOAD_NUM).equals(TableGroup.Properties.ID, this.getID()).toString();
            Object[][] syncData = PersistenceManager.getPersistenceDelegate().executeQuery(query, null);
            Object userIDObj = syncData[0][0];
            Long userID = userIDObj != null ? Long.valueOf(userIDObj.toString()) : null;
            this.currentReloadNumber = (Long)syncData[0][1];
            this.user.set(null);
            this.user.setObjectID(userID);
        }
    }

    @Override
    public synchronized boolean lock(User lockUser) {
        boolean lockSucceeded;
        User resultingUser;
        if (this.isPersistent()) {
            resultingUser = PersistenceManager.getServerConnection().runSync(new TableGroupLocker(this, lockUser));
            lockSucceeded = resultingUser != null && resultingUser.equals(lockUser);
        } else {
            resultingUser = lockUser;
            lockSucceeded = true;
        }
        this.user.set(resultingUser);
        return lockSucceeded;
    }

    public LogicalTable reacquireTable(LogicalTable lt) {
        LogicalTable table = (LogicalTable)PersistenceManager.reacquire(lt);
        if (!this.replaceTableInstance(table)) {
            throw new IllegalArgumentException("LogicalTable \"" + lt + "\" does not belong in TableGroup \"" + this.getName() + "\"");
        }
        return table;
    }

    public LogicalTable getTableInstance(LogicalTable table) {
        int index = this.logicalTables.indexOf(table);
        if (index != -1) {
            return (LogicalTable)this.logicalTables.get(index);
        }
        return null;
    }

    public PhysicalTable getTableInstance(PhysicalTable physTable) {
        for (LogicalTable table : this.logicalTables) {
            for (PhysicalTable pt : table.getPhysicalTables()) {
                if (!pt.equals(physTable)) continue;
                return physTable;
            }
        }
        return null;
    }

    private boolean replaceTableInstance(LogicalTable table) {
        int index = this.logicalTables.indexOf(table);
        if (index != -1) {
            this.logicalTables.set(index, table);
            table.setTableGroup(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean relock(User lockUser) {
        this.unlock();
        return this.lock(lockUser);
    }

    @Override
    public synchronized void unlock() {
        TerminalEventLog.logUnlockTableGroup(this, new EventContext(Terminal.getLocalHost(), this.getUser()));
        this.user.set(null);
        if (this.isPersistent()) {
            PersistenceManager.update(this, new PropertiedObject.Property[]{TableGroup.Properties.USER});
        }
    }

    @Transient
    public List<LogicalTable> getTables() {
        return this.logicalTables.getUnmodifiable();
    }

    @Transient
    public List<LogicalTable> getOrderableTables() {
        ArrayList<LogicalTable> orderableTables = new ArrayList<LogicalTable>();
        for (LogicalTable logTable : this.logicalTables) {
            if (!logTable.canOrderTo()) continue;
            orderableTables.add(logTable);
        }
        return Collections.unmodifiableList(orderableTables);
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Transient
    public String getName() {
        return this.name;
    }

    public void setName(String groupName) {
        this.name = groupName;
    }

    @Override
    public void setLabel(String label) {
        this.name = label;
    }

    @Override
    @Column(name="Sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    @Transient
    public ImageIcon getBackgroundImageIcon() {
        return IconLoader.get(this.backgroundImage);
    }

    @Column(name="BGImage")
    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(String imName) {
        this.backgroundImage = imName;
    }

    @Transient
    public String getTableImageName() {
        return this.tableImage;
    }

    public void setTableImageName(String imName) {
        this.tableImage = imName;
    }

    @Column(name="reload_num")
    public long getReloadNum() {
        return this.reloadNum;
    }

    public boolean hasPhysicalTable(String tableName) {
        List<String> physTables = this.getPhysicalTableNames();
        return physTables.contains(tableName);
    }

    @Transient
    public Dimension getSizeOnScreen() {
        Dimension retval = new Dimension(0, 0);
        String bgImName = this.getBackgroundImage();
        try {
            ImageIcon imageIcon = IconLoader.get(bgImName);
            retval.width = imageIcon.getIconWidth();
            retval.height = imageIcon.getIconHeight();
        }
        catch (NullPointerException e) {
            OrderMate.LOG.warn("Couldn't obtain size of section background image \"" + bgImName + "\"", (Throwable)e);
        }
        return retval;
    }

    @Override
    @Transient
    public String getLabel() {
        return this.getName() != null ? this.getName() : "No Table Group Name, ID:" + this.getID();
    }

    public static boolean isValidNewSectionName(String name, TableGroup forTableGroup) {
        List<TableGroup> sections = TableGroup.getTableGroups();
        for (TableGroup tg : sections) {
            if (tg.equals(forTableGroup) || !tg.getLabel().equals(name)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidNewTableName(String tableName) {
        for (PhysicalTable pt : this.getPhysicalTables()) {
            if (!pt.isCanOrderTo() || !pt.getName().equals(tableName)) continue;
            return false;
        }
        return true;
    }

    public PhysicalTable createTable(PhysicalTable protoType) {
        String tableName = protoType.getName();
        if (!this.isValidNewTableName(tableName)) {
            return null;
        }
        PhysicalTable physicalTable = protoType.copy();
        physicalTable.setName(tableName);
        physicalTable.setPosition(protoType.getX(), protoType.getY());
        LogicalTable logicalTable = new LogicalTable();
        logicalTable.setTableGroup(this);
        logicalTable.setPrimaryPhysicalTable(physicalTable);
        this.logicalTables.add(logicalTable);
        return physicalTable;
    }

    public void removeTable(LogicalTable table) {
        if (!this.logicalTables.contains(table)) {
            throw new IllegalArgumentException("Cannot remove table, table group \"" + this.getName() + "\" does not contain table \"" + table + "\"");
        }
        if (table.isLocked()) {
            throw new IllegalArgumentException("Table \"" + table + "\" is locked, cannot remove.");
        }
        if (table.hasAccount()) {
            throw new IllegalArgumentException("Table \"" + table + "\" currently has an account, cannot remove.");
        }
        this.logicalTables.remove(table);
    }

    @Transient
    public TableGroupHelper getHelper() {
        if (this.helper == null) {
            this.helper = new TableGroupHelper(this);
        }
        return this.helper;
    }

    public void savePermanentPositions() {
        for (PhysicalTable pt : this.getPhysicalTables()) {
            pt.savePermanentPositions();
        }
        OrderMate.LOG.info("Saving permanent positions in section \"" + this.getName() + "\"");
    }

    @Transient
    List<PhysicalTable> getPhysicalTables() {
        ArrayList<PhysicalTable> retval = new ArrayList<PhysicalTable>();
        for (LogicalTable logicalTable : this.logicalTables) {
            for (PhysicalTable physicalTable : logicalTable.getPhysicalTables()) {
                retval.add(physicalTable);
            }
        }
        return retval;
    }

    public String generateTableName() {
        List<String> tableNames = this.getPhysicalTableNames();
        int number = 1;
        boolean foundName = false;
        String suggestedName = "";
        while (!foundName) {
            suggestedName = String.valueOf(number);
            if (!tableNames.contains(suggestedName)) {
                foundName = true;
                continue;
            }
            ++number;
        }
        return suggestedName;
    }

    public static String generateTableGroupName() {
        List sectionNames = TableGroup.getTableGroupNames();
        int letter = 65;
        boolean foundName = false;
        String suggestedName = "";
        int number = 0;
        while (!foundName) {
            suggestedName = String.valueOf((char)letter);
            if (number > 0) {
                suggestedName = suggestedName + number;
            }
            if (!sectionNames.contains(suggestedName)) {
                foundName = true;
                continue;
            }
            if ((letter = (char)(letter + '\u0001')) <= 90) continue;
            letter = 65;
            ++number;
        }
        return suggestedName;
    }

    @Transient
    private List<String> getPhysicalTableNames() {
        List<PhysicalTable> physicalTables = this.getPhysicalTables();
        ArrayList<String> tableNames = new ArrayList<String>(physicalTables.size());
        for (PhysicalTable table : physicalTables) {
            if (!table.isCanOrderTo()) continue;
            tableNames.add(table.getName());
        }
        return tableNames;
    }

    private static List getTableGroupNames() {
        List<TableGroup> tableGroups = TableGroup.getTableGroups();
        ArrayList<String> groupNames = new ArrayList<String>(tableGroups.size());
        for (TableGroup tableGroup : tableGroups) {
            groupNames.add(tableGroup.getName());
        }
        return groupNames;
    }

    public static void resetReloadNums() {
        PersistenceManager.getPersistenceDelegate().executeUpdate("UPDATE config_table_group SET reload_num = 0", null);
    }

    public static int getNumTableGroups() {
        return TableGroup.getTableGroups().size();
    }

    @Transient
    public ImageIcon getDefaultTableImage() {
        return IconLoader.get(this.tableImage);
    }

    @Transient
    public int getBackgroundImageWidth() {
        return this.getBackgroundImageIcon().getIconWidth();
    }

    @Transient
    public int getBackgroundImageHeight() {
        return this.getBackgroundImageIcon().getIconHeight();
    }

    protected static List<TableGroup> getTableGroups() {
        return TableGroupQueries.getTableGroups();
    }

    public static List<TableGroup> getActiveTableGroups(EventContext eventContext) {
        List<TableGroup> allSections = TableGroupQueries.getTableGroups();
        ArrayList<TableGroup> activeSections = new ArrayList<TableGroup>();
        boolean showOnline = eventContext.getTerminal().isShowOnline();
        TriggerActivationContext triggerContext = new TriggerActivationContext(eventContext);
        for (TableGroup group : allSections) {
            if (!group.isActive(triggerContext) || group.isOnline() && !showOnline) continue;
            activeSections.add(group);
        }
        return activeSections;
    }

    public static List<TableGroup> getTableGroupsPreload() {
        List<TableGroup> groups = TableGroup.getTableGroups();
        ArrayList<TableGroup> preloaded = new ArrayList<TableGroup>(groups.size());
        for (TableGroup group : groups) {
            preloaded.add(PersistenceManager.preload(group));
        }
        return preloaded;
    }

    public int compareTo(Object arg0) {
        return Sequenced.SequenceComparator.getInst().compare(this, arg0);
    }

    public static int getMaxSequence() {
        int max = 0;
        for (TableGroup group : TableGroup.getTableGroups()) {
            if (group.getSequence() <= max) continue;
            max = group.getSequence();
        }
        return max;
    }

    @OneToMany(mappedBy="tableGroup", targetEntity=LogicalTable.class, fetch=FetchType.LAZY)
    @Where(clause="system_state = 'ACTIVE'")
    protected List<LogicalTable> getLogicalTables() {
        return this.logicalTables;
    }

    protected void setLogicalTables(List<LogicalTable> tables) {
        this.logicalTables = this.logicalTables == null ? this.createWriteableList(TableGroup.Properties.LOGICAL_TABLES) : this.logicalTables.clone();
        this.logicalTables.set(tables);
    }

    protected void setReloadNum(long reloadNumber) {
        this.reloadNum = reloadNumber;
    }

    @Column(name="default_table_image")
    protected String getTableImage() {
        return this.tableImage;
    }

    protected void setTableImage(String image) {
        this.tableImage = image;
    }

    protected void setUser(User usr) {
        if (this.user == null) {
            this.user = this.createReference(TableGroup.Properties.USER);
        }
        this.user.set(usr);
    }

    protected void setSystemState(String state) {
        this.systemState = state;
    }

    @Column(name="ext_id")
    public String getExtId() {
        return this.extId;
    }

    public void setExtId(String value) {
        this.extId = value;
    }

    @Override
    @Column(name="trigger_activation_strategy")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy")})
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy value) {
        this.triggerActivationStrategy = value;
    }

    @Override
    public boolean isActive(TriggerActivationContext context) {
        return this.triggerActivationStrategy.isActive(this, context);
    }

    @OneToMany(mappedBy="tableGroup", targetEntity=TableGroupTriggerLink.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public List<TableGroupTriggerLink> getTriggerLinks() {
        return this.triggerLinks.getUnmodifiable();
    }

    public void setTriggerLinks(List<InventoryGroupTriggerLink> linksList) {
        this.triggerLinks = this.triggerLinks.clone();
        this.triggerLinks.set(linksList);
    }

    @Override
    @Transient
    public List<AbstractTrigger> getTriggers() {
        ArrayList<AbstractTrigger> triggers = new ArrayList<AbstractTrigger>();
        for (TableGroupTriggerLink triggerLink : this.triggerLinks) {
            triggers.add(triggerLink.getTrigger());
        }
        return triggers;
    }

    public void setTriggers(List<AbstractTrigger> triggers) {
        for (AbstractTrigger trigger : this.getTriggers()) {
            this.removeTrigger(trigger);
        }
        for (AbstractTrigger trigger : triggers) {
            this.addTrigger(trigger);
        }
    }

    @Override
    public boolean removeTrigger(AbstractTrigger trigger) {
        TableGroupTriggerLink toRemove = null;
        for (TableGroupTriggerLink link : this.triggerLinks) {
            if (!link.getTrigger().equals(trigger)) continue;
            toRemove = link;
        }
        if (toRemove != null) {
            this.triggerLinks.remove(toRemove);
            return true;
        }
        return false;
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger trigger) {
        TableGroupTriggerLink newLink = new TableGroupTriggerLink(trigger, this);
        this.triggerLinks.add(newLink);
        return newLink;
    }

    @Column(name="online")
    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean value) {
        this.online = value;
    }

    private static class TableGroupLocker
    extends Executable<User> {
        private PersistentObjDescriptor<User> lockingUserRef;
        private PersistentObjDescriptor<TableGroup> tableGroupRef;

        private TableGroupLocker(TableGroup group, User lockingUser) {
            this.lockingUserRef = new PersistentObjDescriptor(lockingUser);
            this.tableGroupRef = new PersistentObjDescriptor(group);
        }

        @Override
        public User execute() {
            TableGroup fresh = this.tableGroupRef.resolveObject();
            User lockUser = this.lockingUserRef.resolveObject();
            return this.attemptLock(fresh, lockUser);
        }

        private User attemptLock(TableGroup group, User lockUser) {
            if (!group.isLocked()) {
                group.user.set(lockUser);
                PersistenceManager.update(group, new PropertiedObject.Property[]{TableGroup.Properties.USER});
                return lockUser;
            }
            return group.getUser();
        }
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property NAME;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property BACKGROUND_IMAGE;
        public PropertiedObject.Property TABLE_IMAGE;
        public PropertiedObject.Property RELOAD_NUM;
        public PropertiedObject.Property<LogicalTable> LOGICAL_TABLES;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<String> EXT_ID;
        public PropertiedObject.Property<Boolean> ONLINE;
        public PropertiedObject.Property<TriggerActivationStrategy> TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property<TableGroupTriggerLink> TRIGGER_LINKS;
        public PersistentObject.DerivedProperty<AbstractTrigger> TRIGGERS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TableGroup.class), "triggers");
    }
}

