/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.tables;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.ShuffleTableArranger;
import ordermate.database.tables.TableGroup;

public class TableGroupHelper {
    private TableGroup group;

    TableGroupHelper(TableGroup yourGroup) {
        this.group = yourGroup;
    }

    public LogicalTable joinTables(LogicalTable mainLogicalTable, LogicalTable extraLogicalTable, boolean rearrange) {
        LogicalTable mainTable = mainLogicalTable;
        LogicalTable extraTable = extraLogicalTable;
        if (extraLogicalTable == null) {
            OrderMate.LOG.warn("Cannot add table ,it might have been joined in the Waitmate before Reservation from other Platform!");
            return mainLogicalTable;
        }
        if (mainTable.equals(extraTable)) {
            OrderMate.LOG.warn("Cannot add table '" + mainTable.getLabel() + "' to itself!");
            return null;
        }
        if (mainTable.isLocked()) {
            OrderMate.LOG.warn("Cannot add to locked table '" + mainTable.getLabel() + "'");
            return null;
        }
        if (extraTable.hasAccount()) {
            if (mainTable.hasAccount()) {
                OrderMate.LOG.warn("Cannot join two tables that already contain separate accounts. '" + mainTable.getLabel() + "'");
                return null;
            }
            LogicalTable temp = mainTable;
            mainTable = extraTable;
            extraTable = temp;
        }
        if (extraTable.isLocked()) {
            OrderMate.LOG.warn("Cannot add locked table '" + extraTable.getLabel() + "'.");
            return null;
        }
        if (mainTable.addLogicalTable(extraTable, rearrange)) {
            this.group.getLogicalTables().remove(extraTable);
            this.group.save();
        }
        return mainTable;
    }

    public LogicalTable splitTable(LogicalTable theLogicalTable, PhysicalTable thePhysicalTable, boolean unlinkDisconnected) {
        LogicalTable logicalTable = theLogicalTable;
        PhysicalTable physicalTable = thePhysicalTable;
        if (physicalTable == null) {
            throw new IllegalArgumentException("Table '" + logicalTable.getLabel() + "' cannot remove a null PhysicalTable ");
        }
        List<PhysicalTable> physTables = logicalTable.getPhysicalTables();
        if (!physTables.contains(physicalTable)) {
            throw new IllegalArgumentException("Table '" + logicalTable.getLabel() + "' cannot remove physical table, does not contain  '" + physicalTable.getName() + "' ");
        }
        if (physTables.size() <= 1) {
            throw new IllegalArgumentException("Cannot remove the last physical table");
        }
        if (logicalTable.getPrimaryPhysicalTable().equals(physicalTable)) {
            throw new IllegalArgumentException("Cannot remove primary physical table");
        }
        logicalTable.removeTable(physicalTable);
        LogicalTable newLogTable = this.resurrectLogicalTable(physicalTable);
        if (unlinkDisconnected) {
            List<PhysicalTable> lonelyTables = logicalTable.getLonelyPhysicalTables();
            logicalTable.removeTables(lonelyTables);
            for (PhysicalTable toRemove : lonelyTables) {
                this.resurrectLogicalTable(toRemove);
            }
        }
        newLogTable.getTableGroup().save();
        return newLogTable;
    }

    public void breakUpTable(LogicalTable logicalTable) {
        ArrayList<PhysicalTable> physicalTables = new ArrayList<PhysicalTable>(logicalTable.getPhysicalTables());
        if (physicalTables.size() > 1) {
            PhysicalTable primaryPhysicalTable = logicalTable.getPrimaryPhysicalTable();
            for (PhysicalTable pt : physicalTables) {
                if (!logicalTable.getPhysicalTables().contains(pt) || pt.equals(primaryPhysicalTable)) continue;
                this.splitTable(logicalTable, pt, true);
            }
        }
    }

    LogicalTable resurrectLogicalTable(PhysicalTable physicalTable) {
        LogicalTable toReturn = null;
        if (physicalTable.isPersistent()) {
            toReturn = PersistenceManager.getObject(LogicalTable.class, Query.select(LogicalTable.class).equals(LogicalTable.Properties.PRIMARY_PHYSICAL_TABLE, physicalTable.getID()).orderBy(LogicalTable.Properties.SYSTEM_STATE).toString());
        }
        if (toReturn == null) {
            toReturn = new LogicalTable();
        }
        toReturn.setTableGroup(this.group);
        toReturn.setSystemState("ACTIVE");
        toReturn.setPosition(physicalTable.getX(), physicalTable.getY());
        toReturn.setPrimaryPhysicalTable(physicalTable);
        physicalTable.setLogicalTable(toReturn);
        toReturn.addPhysicalTable(physicalTable);
        toReturn.saveChild();
        this.group.getLogicalTables().add(toReturn);
        return toReturn;
    }

    public void restorePermanentPositions() {
        ArrayList<LogicalTable> tables = new ArrayList<LogicalTable>(this.group.getTables());
        for (LogicalTable logicalTable : tables) {
            this.breakUpTable(logicalTable);
        }
        for (PhysicalTable physicalTable : this.group.getPhysicalTables()) {
            physicalTable.restorePermanentPositions();
        }
        for (PhysicalTable table : this.group.getPhysicalTables()) {
            PhysicalTable permanentTable = table.getPermanentPrimaryPhysicalTable();
            if (permanentTable == null || permanentTable.equals(table) || permanentTable.getLogicalTable() == null || permanentTable.getLogicalTable().getAccount() != null || !permanentTable.getLogicalTable().getBarTabs().isEmpty() || permanentTable.getLogicalTable().equals(table.getLogicalTable())) continue;
            this.joinTables(permanentTable.getLogicalTable(), table.getLogicalTable(), true);
        }
        this.group.save();
        OrderMate.LOG.info("Restoring permanent positions in section \"" + this.group.getName() + "\"");
    }

    public void returnToPermanentPosition(PhysicalTable physicalTable) {
        if (physicalTable.getLogicalTable() != null && physicalTable.getLogicalTable().getPhysicalTables().size() > 1) {
            throw new IllegalStateException("returning a Physical Table can only be done with single tables - " + physicalTable);
        }
        physicalTable.restorePermanentPositions();
        ShuffleTableArranger arranger = new ShuffleTableArranger();
        arranger.arrangeTable(physicalTable);
    }

    public LogicalTable getOccludingTable(LogicalTable tableToTest) {
        Rectangle testRectangle = tableToTest.getBoundingRect();
        for (LogicalTable nextTable : this.group.getTables()) {
            if (tableToTest.equals(nextTable) || !testRectangle.intersects(nextTable.getBoundingRect())) continue;
            return nextTable;
        }
        return null;
    }

    class RandomShuffleTableArranger {
        RandomShuffleTableArranger() {
        }
    }
}

