/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.upsell;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.Sequenced;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.misc.resource.ConfigResourceSet;
import ordermate.database.upsell.UpsellItem;
import ordermate.database.upsell.UpsellTriggerLink;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="upsell_suggestion")
public class UpsellSuggestion
extends PersistentObject
implements Saveable,
Sequenced,
TriggerActivated {
    public static final Props Properties = new Props();
    private String label = "New Upsell";
    private String description = "";
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private Reference<ConfigResourceSet> resourceSet;
    private Reference<InventoryItem> suggestedItem;
    private Reference<InventoryGroup> suggestedGroup;
    private boolean upgrade;
    private TriggerActivationStrategy triggerActivationStrategy;
    private int sequence;
    private boolean repeated;
    private PersistentWriteableList<UpsellItem> upsellItems;
    private PersistentWriteableList<UpsellTriggerLink> triggerLinks;
    private transient List<AbstractTrigger> cachedTriggers;
    private transient List<InventoryItem> cachedUpsells;

    @Deprecated
    public UpsellSuggestion() {
        this.resourceSet = this.createReference(UpsellSuggestion.Properties.RESOURCE_SET);
        this.suggestedItem = this.createReference(UpsellSuggestion.Properties.SUGGESTED_ITEM);
        this.suggestedGroup = this.createReference(UpsellSuggestion.Properties.SUGGESTED_GROUP);
        this.upgrade = false;
        this.triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
        this.sequence = 0;
        this.repeated = false;
        this.upsellItems = this.createWriteableList(UpsellSuggestion.Properties.UPSELL_ITEMS);
        this.triggerLinks = this.createWriteableList(UpsellSuggestion.Properties.TRIGGER_LINKS);
    }

    public static UpsellSuggestion createNew() {
        UpsellSuggestion suggestion = new UpsellSuggestion();
        suggestion.setResourceSet(new ConfigResourceSet("Upsell Resource:" + suggestion.getLabel(), null));
        return suggestion;
    }

    public void setSystemState(SystemState value) {
        this.systemState = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    @Column(name="label")
    @Basic(optional=false)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        if (this.getResourceSet() != null) {
            this.getResourceSet().setLabel("UpsellSuggestion:" + label);
        }
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    @Transient
    public ConfigResourceSet getResourceSet() {
        return this.resourceSet.get();
    }

    public void setResourceSet(ConfigResourceSet value) {
        this.resourceSet.set(value);
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="fk_inventory_item")
    public InventoryItem getSuggestedItem() {
        return this.suggestedItem.get();
    }

    public void setSuggestedItem(InventoryItem value) {
        this.suggestedItem.set(value);
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_group")
    public InventoryGroup getSuggestedGroup() {
        return this.suggestedGroup.get();
    }

    public void setSuggestedGroup(InventoryGroup value) {
        this.suggestedGroup.set(value);
    }

    @Column(name="upgrade")
    public boolean isUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(boolean value) {
        this.upgrade = value;
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy")})
    @Column(name="trigger_activation")
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy triggerActivation) {
        this.triggerActivationStrategy = triggerActivation;
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    @OneToMany(mappedBy="upsellSuggestion", targetEntity=UpsellItem.class)
    public List<UpsellItem> getUpsellItems() {
        return this.upsellItems;
    }

    protected void setUpsellItems(List<UpsellItem> values) {
        this.upsellItems.set(values);
    }

    @OneToMany(mappedBy="upsellSuggestion", targetEntity=UpsellTriggerLink.class)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.DELETE, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.DELETE_ORPHAN})
    public List<UpsellTriggerLink> getTriggerLinks() {
        return this.triggerLinks;
    }

    protected void setTriggerLinks(List<UpsellTriggerLink> values) {
        this.triggerLinks.set(values);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public int compareTo(Object o) {
        if (o instanceof Sequenced) {
            return ((Sequenced)o).getSequence() - this.sequence;
        }
        return 0;
    }

    @Override
    public void save() {
        this.resourceSet.saveChild();
        PersistenceManager.save(this);
        this.upsellItems.saveChild();
        this.triggerLinks.saveChild();
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
        this.resourceSet.deleteChild();
        this.upsellItems.deleteChild();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public boolean isActive(TriggerActivationContext context) {
        return this.triggerActivationStrategy.isActive(this, context);
    }

    @Override
    @Transient
    public List<AbstractTrigger> getTriggers() {
        if (this.cachedTriggers == null) {
            this.cachedTriggers = new ArrayList<AbstractTrigger>(this.triggerLinks.size());
            for (UpsellTriggerLink link : this.triggerLinks) {
                this.cachedTriggers.add(link.getTrigger());
            }
        }
        return this.cachedTriggers;
    }

    @Override
    public boolean removeTrigger(AbstractTrigger theTrigger) {
        UpsellTriggerLink trigger = null;
        for (UpsellTriggerLink next : this.triggerLinks) {
            if (!next.getTrigger().equals(theTrigger)) continue;
            trigger = next;
        }
        if (trigger != null) {
            this.triggerLinks.remove(trigger);
            this.cachedTriggers = null;
        }
        return trigger != null;
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger theTrigger) {
        UpsellTriggerLink newLink = null;
        for (UpsellTriggerLink next : this.triggerLinks) {
            if (!next.getTrigger().equals(theTrigger)) continue;
            newLink = next;
        }
        if (newLink == null) {
            newLink = new UpsellTriggerLink(this, theTrigger);
            this.triggerLinks.add(newLink);
            this.cachedTriggers = null;
        }
        return newLink;
    }

    public UpsellItem addInventoryItem(InventoryItem invItem) {
        UpsellItem newItem = null;
        for (UpsellItem item : this.upsellItems) {
            if (!item.getInventoryItem().equals(invItem)) continue;
            newItem = item;
        }
        if (newItem == null) {
            newItem = new UpsellItem(this, invItem);
            this.upsellItems.add(newItem);
            this.cachedUpsells = null;
        }
        return newItem;
    }

    public boolean removeInventoryItem(InventoryItem invItem) {
        UpsellItem toRemove = null;
        for (UpsellItem item : this.upsellItems) {
            if (!item.getInventoryItem().equals(invItem)) continue;
            toRemove = item;
        }
        if (toRemove != null) {
            this.upsellItems.remove(toRemove);
            this.cachedUpsells = null;
        }
        return toRemove != null;
    }

    @Transient
    public List<InventoryItem> getInventoryItems() {
        if (this.cachedUpsells == null) {
            this.cachedUpsells = new ArrayList<InventoryItem>();
            for (UpsellItem item : this.upsellItems) {
                this.cachedUpsells.add(item.getInventoryItem());
            }
        }
        return this.cachedUpsells;
    }

    @Column(name="repeated")
    public boolean isRepeated() {
        return this.repeated;
    }

    public void setRepeated(boolean value) {
        this.repeated = value;
    }

    @Override
    public String toString() {
        return this.label != null ? this.label : "<No Label>";
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> DESCRIPTION;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<ConfigResourceSet> RESOURCE_SET;
        public PropertiedObject.Property<InventoryItem> SUGGESTED_ITEM;
        public PropertiedObject.Property<InventoryGroup> SUGGESTED_GROUP;
        public PropertiedObject.Property UPGRADE;
        public PropertiedObject.Property<TriggerActivationStrategy> TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<UpsellItem> UPSELL_ITEMS;
        public PropertiedObject.Property<UpsellTriggerLink> TRIGGER_LINKS;
        public PropertiedObject.Property REPEATED;
    }
}

