/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.users;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.users.GodPermission;
import ordermate.database.users.OMApplication;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionLoader;

public abstract class AllPermissions {
    public static final String WAITERMATE = "WaiterMate";
    public static final String OFFICEMATE = "OfficeMate";
    public static final String STOCKCONTROL = "StockControl";
    public static final String AccessSalesReport = "Access Sales Report";
    public static final String ViewDebtorReport = "View Debtor Report";
    public static final String ViewCoversReports = "View Covers Reports";
    public static final String AccessCOGSReport = "Access COGS Report";
    public static final String AccessItemGPReport = "Access Item GP Report";
    public static final String AccessPeriodStockReport = "Access Period Stock Report";
    public static final String AccessSalesByAreaReport = "Access Sales By Area Report";
    public static final String AccessItemIngredientsscreen = "Access Item Ingredients screen";
    public static final String AccessStockUsageReport = "Access Stock Usage Report";
    public static final String AccessStockOnHandReport = "Access Stock On Hand Report";
    public static final String ClosedAccountReports = "Closed Account Reports";
    public static final String Skims = "Skims";
    public static final String ViewTransactionJournal = "View Transaction Journal";
    public static final String VoucherReports = "Voucher Reports";
    public static final String AccessCoupons = "Access Coupons";
    public static final String AccessDriverManifest = "Access Driver Manifest";
    public static final String ViewReservationsReports = "View Reservations Reports";
    public static final String CustomerAdmin = "Customer Admin";
    public static final String AccessStocktakescreen = "Access Stocktake screen";
    public static final String AccessUsersscreen = "Access Users screen";
    public static final String AccessWastagesScreen = "Access Wastages screen";
    public static final String AccessTransfersScreen = "Access Transfers Screen";
    private static Map<Permission, OMApplication> permissions = new HashMap<Permission, OMApplication>();
    public static Permission CASHDRAWER;
    public static Permission MOVE_TABLE;
    public static Permission EXIT;
    public static Permission SAFE_RESTART;
    public static Permission CLOCK_ON;
    public static Permission CLOCK_OFF;
    public static Permission PRINT_TIMESHEET;
    public static Permission PAY;
    public static Permission PRINT_BILL;
    public static Permission TRANSFER_ITEMS;
    public static Permission SAVE;
    public static Permission DELETE_ITEM;
    public static Permission SYSTEM_ADMIN;
    public static Permission SHOW_ONLINE;
    public static Permission ACCOUNT_ADMIN;
    public static Permission DISCOUNT;
    public static Permission DELETE_PAY_TRANSACTION;
    public static Permission VIEW_TAKINGS;
    public static Permission VIEW_TERMINAL_TAKINGS;
    public static Permission VIEW_CASHDRAWER_TAKINGS;
    public static Permission VIEW_ACCOUNTS_TAKINGS;
    public static Permission CLOSED_ACCOUNTS;
    public static Permission UNLOCK_ACCOUNTS;
    public static Permission EDIT_PRICE;
    public static Permission CUSTOM_DISCOUNT;
    public static Permission OPTIMISE;
    public static Permission RESERVATIONS;
    public static Permission SPLIT_BILL;
    public static Permission ASSIGN_LOYALTY_CARD;
    public static Permission SURCHARGE;
    public static Permission DAILY_DISCOUNT_OR_SURCHARGE;
    public static Permission USER_ADMIN;
    public static Permission CUSTOMER_ADMIN;
    public static Permission CASHDRAWER_ADMIN;
    public static Permission BARSTOCK;
    public static Permission EDIT_RESERVATIONS;
    public static Permission PAY_CUSTOMER_ACCOUNTS;
    public static Permission PAY_TABS;
    public static Permission TRAINING_MODE;
    public static Permission VIEW_INGREDIENTS;
    public static Permission EDIT_TERMINAL_LOCATION;
    public static Permission PAY_CLOSED_ACCOUNT;
    public static Permission NEW_TRADING_DAY;
    public static Permission KITCHEN_NOTES;
    public static Permission EDIT_BARCODES;
    public static Permission ORDERMATE_ADMIN;
    public static Permission POS_GEAR;
    public static Permission CUSTOMER_DISCOUNT;
    public static Permission SKIMS;
    public static Permission EDIT_SKIMS;
    public static Permission DOWNLOAD_ACCOUNT;
    public static Permission REDIRECT_PRINTERS;
    public static Permission REPRINT_PREP_DOCKETS;
    public static Permission PRINT_TAKINGS;
    public static Permission PRINT_SALES;
    public static Permission UNLOCK_TABLE_GROUP;
    public static Permission PAY_ROOM_ACCOUNT;
    public static Permission PAY_TO_LOYALTY;
    public static Permission VIEW_CREDIT_LIMIT;
    public static Permission CHANGE_CREDIT_LIMIT;
    public static Permission PERMANENT_PRICE_CHANGE;
    public static Permission VIEW_BACKUP_FOLDER;
    public static Permission DELETE_CUSTOMER;
    public static Permission CUSTOMER_COMMENT;
    public static Permission VIEW_PREVIOUS_SALES;
    public static Permission USE_STOCK_CONTROL;
    public static Permission ACCESS_STOCK_CONTROL_OPTIONS;
    public static Permission EDIT_ITEM_INGREDIENTS;
    public static Permission EXPORT_CUSTOMERS;
    public static Permission EXPORT_ALL_CUSTOMERS;
    public static Permission EXPORT_INVOICES;
    public static Permission EXPORT_SETTINGS;
    public static Permission EXPORT_RECONCILIATIONS;
    public static Permission IMPORT_MENU;
    public static Permission ACCESS_SUPPLIERS_SCREEN;
    public static Permission ADD_SUPPLIERS;
    public static Permission EDIT_SUPPLIERS;
    public static Permission DELETE_SUPPLIERS;
    public static Permission ACCESS_STOCK_AREAS_SCREEN;
    public static Permission ADD_STOCK_AREAS;
    public static Permission EDIT_STOCK_AREAS;
    public static Permission DELETE_STOCK_AREAS;
    public static Permission ACCESS_STOCK_ITEMS_SCREEN;
    public static Permission ADD_STOCK_ITEMS;
    public static Permission EDIT_STOCK_ITEMS;
    public static Permission EDIT_STOCK_ITEM_WITH_USAGE;
    public static Permission DELETE_STOCK_ITEMS;
    public static Permission ACCESS_MENU_CATEGORIES_SCREEN;
    public static Permission ADD_MENU_CATEGORIES;
    public static Permission EDIT_MENU_CATEGORIES;
    public static Permission DELETE_MENU_CATEGORIES;
    public static Permission ACCESS_ITEM_INGREDIENTS_SCREEN;
    public static Permission ACCESS_OPTION_INGREDIENTS_SCREEN;
    public static Permission ACCESS_INVOICES_SCREEN;
    public static Permission ADD_INVOICES;
    public static Permission EDIT_INVOICES;
    public static Permission DELETE_INVOICES;
    public static Permission ACCESS_SUGGESTED_ORDER_SCREEN;
    public static Permission CREATE_PURCHASE_ORDER;
    public static Permission ALLOW_ORDERING_FROM_SUPPLIERS;
    public static Permission ACCESS_STOCKTAKES_SCREEN;
    public static Permission CREATE_STOCKTAKE;
    public static Permission EDIT_STOCKTAKE;
    public static Permission DELETE_STOCKTAKE;
    public static Permission SAVE_STOCKTAKE;
    public static Permission DISPLAY_STOCKTAKE_EXPECTED_COLUMN;
    public static Permission ACCESS_ADJUSTMENT_SCREEN;
    public static Permission ADD_ADJUSTMENTS;
    public static Permission EDIT_ADJUSTMENTS;
    public static Permission CHANGE_ADJUSTMENT_USER;
    public static Permission DELETE_ADJUSTMENTS;
    public static Permission ACCESS_TRANSFER_SCREEN;
    public static Permission ADD_TRANSFERS;
    public static Permission EDIT_TRANSFERS;
    public static Permission CHANGE_TRANSFER_USER;
    public static Permission DELETE_TRANSFERS;
    public static Permission ACCESS_WASTAGES_SCREEN;
    public static Permission ADD_WASTAGES;
    public static Permission EDIT_WASTAGES;
    public static Permission CHANGE_WASTAGE_USER;
    public static Permission DELETE_WASTAGES;
    public static Permission ACCESS_PRE_PRODUCTION_SCREEN;
    public static Permission ACCESS_STOCK_ON_HAND_REPORT;
    public static Permission ACCESS_ITEM_GP_REPORT;
    public static Permission ACCESS_STOCK_USAGE_REPORT;
    public static Permission ACCESS_COGS_REPORT;
    public static Permission ACCESS_PERIOD_STOCK_REPORT;
    public static Permission ACCESS_SALES_BY_AREA_REPORT;
    public static Permission ACCESS_SALES_REPORT;
    public static Permission ACCESS_DEBTOR_TRANSACTION;
    public static Permission ACCESS_USERS_SCREEN;
    public static Permission ACCESS_COUPONS_SCREEN;
    public static Permission ADD_USERS;
    public static Permission EDIT_USERS;
    public static Permission DELETE_USERS;
    public static Permission ACCESS_PERMISSIONS_SCREEN;
    public static Permission TIPS;
    public static Permission MESSAGE_OF_THE_DAY;
    public static Permission CLEAR_EVENT_LOG;
    public static Permission CONFIG_INTEGRATIONS;
    public static Permission CONFIG_GIFT_VOUCHERS;
    public static Permission TRIGGER_MANUAL_OVERRIDE;
    public static Permission VOUCHERS_ADMIN;
    public static Permission VOUCHERS_GEN;
    public static Permission VOUCHER_REPORTS;
    public static Permission EMAIL_TAX_INVOICES;
    public static Permission EMAIL_TAX_INVOICES_WAITERMATE;
    public static Permission ACCESS_BUSINESS_INFO;
    public static Permission ACCESS_BUSINESS_NAME_NUMBER;
    public static Permission EDIT_ADVANCED_ORDERMATE_PROPERTIES;
    public static Permission ACCESS_ADVANCED_ORDERMATE_PROPERTIES;
    public static Permission EMAIL_PO_TO_SUPPLIER;
    public static Permission ADD_PRIVILEGE_GROUP;
    public static Permission EDIT_PRIVILEGE_GROUP;
    public static Permission DELETE_PRIVILEGE_GROUP;
    public static Permission ORDERMATE_PROPERTIES;
    public static Permission DISCOUNT_REASONS;
    public static Permission VIEW_PRICE_LEVELS;
    public static Permission EDIT_PRICE_LEVELS;
    public static Permission VIEW_PRICES;
    public static Permission EDIT_PRICES;
    public static Permission VIEW_TRIGGERS;
    public static Permission EDIT_TRIGGERS;
    public static Permission VIEW_COMBOS;
    public static Permission EDIT_COMBOS;
    public static Permission BREAK_COMBOS;
    public static Permission MAKE_COMBOS;
    public static Permission MANUALLY_CHANGE_PRICE_LEVEL;
    public static Permission USE_INACTIVE_PRICE_LEVEL;
    public static Permission AUTO_FILL_OUT_OVERRIDE_PRICE_LEVEL;
    public static Permission DEBTOR_REFUND;
    public static Permission DEBTOR_STATEMENT;
    public static Permission DEBTOR_TRANSFER;
    public static Permission DEBTOR_ORDER_DETAILS;
    public static Permission DEBTOR_PAY;
    public static Permission DEBTOR_EDIT_DETAILS;
    public static Permission DEBTOR_SET_CUSTOMER;
    public static Permission DEBTOR_SET_TERMS;
    public static Permission DEBTOR_REPORT;
    public static Permission DEBTOR_CREATE_NEW;
    public static Permission DEBTOR_FORCE_CHECK_OUT;
    public static Permission ACCESS_COURSES;
    public static Permission REMOVE_COURSE;
    public static Permission ADD_COURSE;
    public static Permission CONFIG_TERMINAL_MODES;
    public static Permission EDIT_PRICE_UPDATE_METHOD;
    public static Permission MYTILLS_RECONCILIATION;
    public static Permission WAITERMATE_RECONCILIATION_BLIND;
    public static Permission WAITERMATE_CUSTOM_REFUND;
    public static Permission WAITERMATE_RECONCILIATION;
    public static Permission PRINTING_OPTIONS;
    public static Permission TERMINAL_OPTIONS;
    public static Permission ALL_DEVICES;
    public static Permission ACCESS_MENU_PROFILES;
    public static Permission REPLICATION;
    public static Permission REPLICATION_SETUP;
    public static Permission ACCESS_QUICK_SALE_NAV_INFO;
    public static Permission INVENTORY_SIZES;
    public static Permission INVENTORY_ADDS;
    public static Permission INVENTORY_OPTIONS;
    public static Permission PRICE_ADJUSTMENTS;
    public static Permission VIEW_CLOSED_ACCOUNTS;
    public static Permission LIQUORFILE_SETUP;
    public static Permission SCANDATA_EXPORT;
    public static Permission PRICEBOOK_LINKING;
    public static Permission MENU_SECTION_EDIT;
    public static Permission CONFIG_COLOURS;
    public static Permission STOCK_RESET;
    public static Permission STOCK_REQUISITION_ACCESS;
    public static Permission STOCK_REQUISITION_TRANSFER;
    public static Permission UNLOCK_STOCK_REQUISITION;
    public static Permission VIEW_GOOGLE_MAPS;
    public static Permission QUICK_SALE_OVERRIDE;
    public static Permission VIEW_COVERS_REPORT;
    public static Permission VIEW_DISCOUNT_REPORT;
    public static Permission VIEW_TRANSACTION_JOURNAL;
    public static Permission MONTHLY_EXPORT;
    public static Permission FEEDBACK;
    public static Permission TWITTER;
    public static Permission CASHOUT;
    public static Permission CASHOUT_WITH_PURCHASE;
    public static Permission OFFLINE_EFTPOS;
    public static Permission MODIFY_IP;
    public static Permission TIP_ADJUST;
    public static Permission ORDER_BELOW_MIN;
    public static Permission VIEW_RESERVATIONS;
    public static Permission EDIT_TIMESHEET;
    public static Permission ADJUST_TIME;
    public static Permission MESSAGING;
    public static Permission MOVE_TABS;
    public static Permission EDIT_COMPLETED_RECONCILIATIONS;
    public static Permission ALTER_TABLE_STATE;
    public static Permission EDIT_CUSTOMER_LOYALTY;
    public static Permission EDIT_KIOSK;
    public static Permission EDIT_PRINTER_GROUPS;
    public static Permission EDIT_SHIFTS;
    public static Permission DAY_PARTS;
    public static Permission LOCATIONS;
    public static Permission EDIT_UPSELLS;
    public static Permission SETUP_MY_LOGIN;
    public static Permission CHANGE_SHIFTS;
    public static Permission QUICK_REFUND;
    public static Permission SET_CUSTOMER_ON_ACCOUNT;
    public static Permission ACCESS_DEBTOR_ACCOUNTS;
    public static Permission REMOVE_PAYMENT_SURCHARGE;
    public static Permission ACCESS_BARTABS;
    public static Permission CREATE_BARTAB;
    public static Permission PREAUTH_BARTAB;
    public static Permission LAUNCH_EXTERNAL_WEB_LINKS;
    public static Permission VIEW_PREVIOUS_DAY_TAKINGS;
    public static Permission VIEW_PREVIOUS_SHIFTS;
    public static Permission STOCK_INVOICE_DATE_CORRECTION;
    public static Permission DELIVERY_NOTE_PRICE_CORRECTION;
    public static Permission DELIVERY_NOTE_QTY_CORRECTION;
    public static Permission DELIVERY_NOTE_ITEM_ADD;
    public static Permission DELIVERY_NOTE_ITEM_REMOVE;
    public static Permission INVOICE_PRICE_CORRECTION;
    public static Permission INVOICE_QTY_CORRECTION;
    public static Permission INVOICE_ITEM_ADD;
    public static Permission INVOICE_ITEM_REMOVE;
    public static Permission CREDIT_NOTE_PRICE_CORRECTION;
    public static Permission CREDIT_NOTE_QTY_CORRECTION;
    public static Permission CREDIT_NOTE_ITEM_ADD;
    public static Permission CREDIT_NOTE_ITEM_REMOVE;
    public static Permission PURCHASE_ORDER_PRICE_CORRECTION;
    public static Permission PURCHASE_ORDER_QTY_CORRECTION;
    public static Permission PURCHASE_ORDER_ITEM_ADD;
    public static Permission PURCHASE_ORDER_ITEM_REMOVE;
    public static Permission ACCESS_DRIVER_MANIFEST;
    public static Permission ACCESS_USER_REPORTS;
    public static Permission ASSIGN_DELIVERY_TO_OTHERS;
    public static Permission ASSIGN_DELIVERY;
    public static Permission ASSIGN_INTEGRATED_DELIVERY;
    public static Permission RETURN_DRIVER;
    public static Permission SETTLE_DELIVERY;
    public static Permission PRINT_DRIVER_SUMMARY;
    public static Permission ALLOW_DELIVERY_TO_WARN_ZONE;
    public static Permission DELIVERY_ZONES;
    public static Permission EDIT_VOUCHER_EXPIRY_DATE;
    public static Permission ALLOW_EXPIRED_VOUCHER;
    public static Permission PAYMENT_TYPE;
    public static Permission PERFORM_MOTO;
    public static Permission ACCESS_OPAY_SETTINGS;
    public static final Permission GOD_ONLY;
    static String loadPermissionQueryPrefix;

    private AllPermissions() {
    }

    protected static Permission loadPermission(String name) throws Exception {
        Permission p = PermissionLoader.getInstance().load(name);
        if (p == null) {
            throw new Exception("The permission \"" + name + "\" could not be found in the database.");
        }
        permissions.put(p, p.getApplication());
        return p;
    }

    public static Set getPermissions() {
        return Collections.unmodifiableSet(permissions.keySet());
    }

    public static List<Permission> getPermissionsForApp(OMApplication app) {
        ArrayList<Permission> perms = new ArrayList<Permission>();
        for (Permission p : permissions.keySet()) {
            if (!permissions.get(p).equals((Object)app)) continue;
            perms.add(p);
        }
        Collections.sort(perms);
        return perms;
    }

    public static List<OMApplication> getPermissionsApplications() {
        return Arrays.asList(OMApplication.values());
    }

    public static void loadAllPermissions() {
        try {
            permissions.clear();
            CASHDRAWER = AllPermissions.loadPermission("Cashdrawer");
            MOVE_TABLE = AllPermissions.loadPermission("Move Table");
            EXIT = AllPermissions.loadPermission("Exit");
            SAFE_RESTART = AllPermissions.loadPermission("Safe Restart");
            CLOCK_ON = AllPermissions.loadPermission("Clock On");
            CLOCK_OFF = AllPermissions.loadPermission("Clock Off");
            PRINT_TIMESHEET = AllPermissions.loadPermission("View/Print Timesheets");
            PAY = AllPermissions.loadPermission("Pay");
            PRINT_BILL = AllPermissions.loadPermission("Print Bill");
            TRANSFER_ITEMS = AllPermissions.loadPermission("Transfer Items");
            SAVE = AllPermissions.loadPermission("Save");
            DELETE_ITEM = AllPermissions.loadPermission("Delete Item");
            SYSTEM_ADMIN = AllPermissions.loadPermission("System Admin");
            ACCOUNT_ADMIN = AllPermissions.loadPermission("Account Admin");
            DISCOUNT = AllPermissions.loadPermission("Discount");
            DELETE_PAY_TRANSACTION = AllPermissions.loadPermission("Delete Pay Transaction");
            VIEW_TAKINGS = AllPermissions.loadPermission("View Takings");
            SHOW_ONLINE = AllPermissions.loadPermission("Show Online Sections");
            VIEW_TERMINAL_TAKINGS = AllPermissions.loadPermission("Terminal Takings");
            VIEW_CASHDRAWER_TAKINGS = AllPermissions.loadPermission("CashDrawer Takings");
            VIEW_ACCOUNTS_TAKINGS = AllPermissions.loadPermission("Account Takings");
            CLOSED_ACCOUNTS = AllPermissions.loadPermission("Closed Accounts");
            UNLOCK_ACCOUNTS = AllPermissions.loadPermission("Unlock Accounts");
            EDIT_PRICE = AllPermissions.loadPermission("Edit Price");
            CUSTOM_DISCOUNT = AllPermissions.loadPermission("Custom Discount");
            OPTIMISE = AllPermissions.loadPermission("Optimise");
            RESERVATIONS = AllPermissions.loadPermission("Reservations");
            SPLIT_BILL = AllPermissions.loadPermission("Split Bill");
            ASSIGN_LOYALTY_CARD = AllPermissions.loadPermission("Assign Loyalty Card");
            SURCHARGE = AllPermissions.loadPermission("Surcharge");
            DAILY_DISCOUNT_OR_SURCHARGE = AllPermissions.loadPermission("Daily Discount or Surcharge");
            USER_ADMIN = AllPermissions.loadPermission("User Admin");
            CUSTOMER_ADMIN = AllPermissions.loadPermission(CustomerAdmin);
            CASHDRAWER_ADMIN = AllPermissions.loadPermission("Cashdrawer Admin");
            BARSTOCK = AllPermissions.loadPermission("Barstock");
            EDIT_RESERVATIONS = AllPermissions.loadPermission("Edit Reservations");
            PAY_CUSTOMER_ACCOUNTS = AllPermissions.loadPermission("Pay Customer Accounts");
            PAY_TABS = AllPermissions.loadPermission("Pay Tabs");
            TRAINING_MODE = AllPermissions.loadPermission("Training Mode");
            VIEW_INGREDIENTS = AllPermissions.loadPermission("View Ingredients");
            EDIT_TERMINAL_LOCATION = AllPermissions.loadPermission("Edit Terminal Location");
            PAY_CLOSED_ACCOUNT = AllPermissions.loadPermission("Pay Closed Account");
            NEW_TRADING_DAY = AllPermissions.loadPermission("New Trading Day");
            KITCHEN_NOTES = AllPermissions.loadPermission("Kitchen Notes");
            EDIT_BARCODES = AllPermissions.loadPermission("Edit Barcodes");
            ORDERMATE_ADMIN = AllPermissions.loadPermission("Ordermate Admin");
            POS_GEAR = AllPermissions.loadPermission("POSGear");
            CUSTOMER_DISCOUNT = AllPermissions.loadPermission("Customer Discount");
            DELETE_CUSTOMER = AllPermissions.loadPermission("Delete Customer");
            CUSTOMER_COMMENT = AllPermissions.loadPermission("Edit Customer Comments");
            SKIMS = AllPermissions.loadPermission(Skims);
            EDIT_SKIMS = AllPermissions.loadPermission("Edit Skims");
            REDIRECT_PRINTERS = AllPermissions.loadPermission("Redirect Printers");
            REPRINT_PREP_DOCKETS = AllPermissions.loadPermission("Reprint Prep Dockets");
            PRINT_TAKINGS = AllPermissions.loadPermission("Print Takings");
            PRINT_SALES = AllPermissions.loadPermission("Print Sales");
            UNLOCK_TABLE_GROUP = AllPermissions.loadPermission("Unlock Table Group");
            PAY_ROOM_ACCOUNT = AllPermissions.loadPermission("Pay Room Accounts");
            PAY_TO_LOYALTY = AllPermissions.loadPermission("Pay To Loyalty");
            VIEW_CREDIT_LIMIT = AllPermissions.loadPermission("View Credit Limit");
            CHANGE_CREDIT_LIMIT = AllPermissions.loadPermission("Change Credit Limit");
            PERMANENT_PRICE_CHANGE = AllPermissions.loadPermission("Permanent Price Change");
            VIEW_PREVIOUS_SALES = AllPermissions.loadPermission("View Previous Sales");
            REMOVE_PAYMENT_SURCHARGE = AllPermissions.loadPermission("Remove Payment Surcharge");
            ACCESS_BARTABS = AllPermissions.loadPermission("Access BarTabs");
            CREATE_BARTAB = AllPermissions.loadPermission("Create BarTab");
            PREAUTH_BARTAB = AllPermissions.loadPermission("Preauth BarTab");
            TRIGGER_MANUAL_OVERRIDE = AllPermissions.loadPermission("Activate Trigger");
            SET_CUSTOMER_ON_ACCOUNT = AllPermissions.loadPermission("Set Customer On Accounts");
            MAKE_COMBOS = AllPermissions.loadPermission("Make Combos");
            BREAK_COMBOS = AllPermissions.loadPermission("Break Combos");
            MANUALLY_CHANGE_PRICE_LEVEL = AllPermissions.loadPermission("Manually change price level");
            USE_INACTIVE_PRICE_LEVEL = AllPermissions.loadPermission("Use inactive price level");
            DEBTOR_REFUND = AllPermissions.loadPermission("Debtor Refund");
            DEBTOR_STATEMENT = AllPermissions.loadPermission("Print Statement");
            DEBTOR_TRANSFER = AllPermissions.loadPermission("Transfer");
            DEBTOR_ORDER_DETAILS = AllPermissions.loadPermission("View Details");
            DEBTOR_PAY = AllPermissions.loadPermission("Pay Off Debtor");
            DEBTOR_EDIT_DETAILS = AllPermissions.loadPermission("Edit Details");
            DEBTOR_SET_CUSTOMER = AllPermissions.loadPermission("Set Customer");
            DEBTOR_SET_TERMS = AllPermissions.loadPermission("Set Terms");
            DEBTOR_REPORT = AllPermissions.loadPermission(ViewDebtorReport);
            DEBTOR_CREATE_NEW = AllPermissions.loadPermission("Create Debtor");
            ACCESS_DEBTOR_ACCOUNTS = AllPermissions.loadPermission("Access Debtor Accounts");
            TIPS = AllPermissions.loadPermission("Tips");
            TIP_ADJUST = AllPermissions.loadPermission("Integrated EFTPOS Tipping");
            MESSAGE_OF_THE_DAY = AllPermissions.loadPermission("Message of the day");
            ALTER_TABLE_STATE = AllPermissions.loadPermission("Alter Table State");
            STOCK_RESET = AllPermissions.loadPermission("Reset Stock Countdown");
            STOCK_REQUISITION_ACCESS = AllPermissions.loadPermission("Access Stock Requisitions");
            STOCK_REQUISITION_TRANSFER = AllPermissions.loadPermission("Transfer Stock Requisition");
            UNLOCK_STOCK_REQUISITION = AllPermissions.loadPermission("Unlock Stock Requisition");
            VIEW_GOOGLE_MAPS = AllPermissions.loadPermission("View customer maps");
            CASHOUT = AllPermissions.loadPermission("Cashout Without Purchase");
            CASHOUT_WITH_PURCHASE = AllPermissions.loadPermission("Cashout With Purchase");
            OFFLINE_EFTPOS = AllPermissions.loadPermission("Offline Eftpos");
            ORDER_BELOW_MIN = AllPermissions.loadPermission("Allow Order Below Minimum Delivery");
            ADJUST_TIME = AllPermissions.loadPermission("Adjust Time");
            MOVE_TABS = AllPermissions.loadPermission("Move Tabs");
            VIEW_BACKUP_FOLDER = AllPermissions.loadPermission("View Backup Folder");
            QUICK_SALE_OVERRIDE = AllPermissions.loadPermission("Quicksale override");
            FEEDBACK = AllPermissions.loadPermission("Feedback");
            TWITTER = AllPermissions.loadPermission("Twitter");
            EDIT_CUSTOMER_LOYALTY = AllPermissions.loadPermission("Edit Customer Loyalty Details");
            ASSIGN_DELIVERY_TO_OTHERS = AllPermissions.loadPermission("Assign deliveries to others");
            ASSIGN_DELIVERY = AllPermissions.loadPermission("Assign Delivery");
            RETURN_DRIVER = AllPermissions.loadPermission("Return Driver");
            SETTLE_DELIVERY = AllPermissions.loadPermission("Settle Delivery");
            PRINT_DRIVER_SUMMARY = AllPermissions.loadPermission("Print Driver Summary");
            ALLOW_DELIVERY_TO_WARN_ZONE = AllPermissions.loadPermission("Allow Delivery to Warn Areas");
            SETUP_MY_LOGIN = AllPermissions.loadPermission("Setup My Login");
            CHANGE_SHIFTS = AllPermissions.loadPermission("Change Shifts");
            WAITERMATE_RECONCILIATION_BLIND = AllPermissions.loadPermission("WaiterMate Reconciliation - Blind");
            WAITERMATE_RECONCILIATION = AllPermissions.loadPermission("WaiterMate Reconciliation");
            WAITERMATE_CUSTOM_REFUND = AllPermissions.loadPermission("WaiterMate Custom Refund");
            QUICK_REFUND = AllPermissions.loadPermission("Quick Refund");
            LAUNCH_EXTERNAL_WEB_LINKS = AllPermissions.loadPermission("Launch External Web Links");
            VIEW_PREVIOUS_DAY_TAKINGS = AllPermissions.loadPermission("View Previous Days Takings");
            VIEW_PREVIOUS_SHIFTS = AllPermissions.loadPermission("View All Previous Shifts");
            EDIT_VOUCHER_EXPIRY_DATE = AllPermissions.loadPermission("Edit Voucher Expiry Date");
            ALLOW_EXPIRED_VOUCHER = AllPermissions.loadPermission("Allow Expired Voucher");
            VOUCHERS_ADMIN = AllPermissions.loadPermission("Vouchers Admin");
            VOUCHERS_GEN = AllPermissions.loadPermission("Generate Voucher");
            ACCESS_USER_REPORTS = AllPermissions.loadPermission("Access User Reports");
            EXPORT_CUSTOMERS = AllPermissions.loadPermission("Export Customers");
            EXPORT_ALL_CUSTOMERS = AllPermissions.loadPermission("Export All Customers");
            EXPORT_INVOICES = AllPermissions.loadPermission("Export Invoices");
            EXPORT_SETTINGS = AllPermissions.loadPermission("Export Settings");
            EXPORT_RECONCILIATIONS = AllPermissions.loadPermission("Export Reconciliations");
            IMPORT_MENU = AllPermissions.loadPermission("Import Menu");
            CLEAR_EVENT_LOG = AllPermissions.loadPermission("Clear Event Log");
            ACCESS_MENU_CATEGORIES_SCREEN = AllPermissions.loadPermission("Access Menu Categories screen");
            ADD_MENU_CATEGORIES = AllPermissions.loadPermission("Add Menu Category");
            EDIT_MENU_CATEGORIES = AllPermissions.loadPermission("Edit Menu Category");
            DELETE_MENU_CATEGORIES = AllPermissions.loadPermission("Delete Menu Category");
            MENU_SECTION_EDIT = AllPermissions.loadPermission("Menu Sections");
            ACCESS_USERS_SCREEN = AllPermissions.loadPermission(AccessUsersscreen);
            ACCESS_COUPONS_SCREEN = AllPermissions.loadPermission(AccessCoupons);
            ADD_USERS = AllPermissions.loadPermission("Add User");
            EDIT_USERS = AllPermissions.loadPermission("Edit User");
            DELETE_USERS = AllPermissions.loadPermission("Delete User");
            ACCESS_PERMISSIONS_SCREEN = AllPermissions.loadPermission("Access Privileges screen");
            VIEW_PRICE_LEVELS = AllPermissions.loadPermission("View Price Levels");
            EDIT_PRICE_LEVELS = AllPermissions.loadPermission("Edit Price Levels");
            AUTO_FILL_OUT_OVERRIDE_PRICE_LEVEL = AllPermissions.loadPermission("Auto Fill Out Override Price Level");
            VIEW_PRICES = AllPermissions.loadPermission("View Prices");
            EDIT_PRICES = AllPermissions.loadPermission("Edit Prices");
            VIEW_TRIGGERS = AllPermissions.loadPermission("View triggers");
            EDIT_TRIGGERS = AllPermissions.loadPermission("Edit triggers");
            VIEW_COMBOS = AllPermissions.loadPermission("View Combos");
            EDIT_COMBOS = AllPermissions.loadPermission("Edit Combos");
            ACCESS_COURSES = AllPermissions.loadPermission("Access Courses");
            REMOVE_COURSE = AllPermissions.loadPermission("Remove Course");
            ADD_COURSE = AllPermissions.loadPermission("Add Course");
            CONFIG_TERMINAL_MODES = AllPermissions.loadPermission("Configure Terminal Modes");
            MYTILLS_RECONCILIATION = AllPermissions.loadPermission("MyTills Reconciliation");
            PRINTING_OPTIONS = AllPermissions.loadPermission("Printing Options");
            TERMINAL_OPTIONS = AllPermissions.loadPermission("Terminal Options");
            ALL_DEVICES = AllPermissions.loadPermission("Configure Devices");
            ACCESS_MENU_PROFILES = AllPermissions.loadPermission("Access Menu Profiles");
            REPLICATION = AllPermissions.loadPermission("Access Replication");
            REPLICATION_SETUP = AllPermissions.loadPermission("Setup Replication");
            CONFIG_INTEGRATIONS = AllPermissions.loadPermission("Configure Integrations");
            CONFIG_GIFT_VOUCHERS = AllPermissions.loadPermission("Configure Gift Vouchers");
            ORDERMATE_PROPERTIES = AllPermissions.loadPermission("Ordermate Properties");
            INVENTORY_SIZES = AllPermissions.loadPermission("Inventory Sizes");
            INVENTORY_ADDS = AllPermissions.loadPermission("Edit Pluses");
            INVENTORY_OPTIONS = AllPermissions.loadPermission("Edit Options");
            PRICE_ADJUSTMENTS = AllPermissions.loadPermission("Price Adjustments");
            DISCOUNT_REASONS = AllPermissions.loadPermission("Discount Reasons");
            VIEW_CLOSED_ACCOUNTS = AllPermissions.loadPermission(ClosedAccountReports);
            ACCESS_SALES_REPORT = AllPermissions.loadPermission(AccessSalesReport);
            ACCESS_DEBTOR_TRANSACTION = AllPermissions.loadPermission("Debtor Transaction Summary");
            ACCESS_DRIVER_MANIFEST = AllPermissions.loadPermission(AccessDriverManifest);
            ACCESS_QUICK_SALE_NAV_INFO = AllPermissions.loadPermission("Access Quick Sale Nav");
            CONFIG_COLOURS = AllPermissions.loadPermission("Config Colours");
            LIQUORFILE_SETUP = AllPermissions.loadPermission("Liquorfile Setup");
            SCANDATA_EXPORT = AllPermissions.loadPermission("Scandata Export");
            PRICEBOOK_LINKING = AllPermissions.loadPermission("Pricebook Linking");
            VIEW_COVERS_REPORT = AllPermissions.loadPermission(ViewCoversReports);
            VIEW_DISCOUNT_REPORT = AllPermissions.loadPermission("View Discount Reports");
            VIEW_TRANSACTION_JOURNAL = AllPermissions.loadPermission(ViewTransactionJournal);
            MONTHLY_EXPORT = AllPermissions.loadPermission("Monthly Report Transmit");
            VIEW_RESERVATIONS = AllPermissions.loadPermission(ViewReservationsReports);
            EDIT_TIMESHEET = AllPermissions.loadPermission("Edit Timesheets");
            DELIVERY_ZONES = AllPermissions.loadPermission("Edit Delivery Zones");
            MESSAGING = AllPermissions.loadPermission("Messaging");
            EDIT_COMPLETED_RECONCILIATIONS = AllPermissions.loadPermission("Edit Completed Reconciliation");
            EDIT_KIOSK = AllPermissions.loadPermission("Edit Kiosk");
            EDIT_PRINTER_GROUPS = AllPermissions.loadPermission("Edit Printer Groups");
            EDIT_SHIFTS = AllPermissions.loadPermission("Edit Shifts");
            DAY_PARTS = AllPermissions.loadPermission("Day Parts");
            LOCATIONS = AllPermissions.loadPermission("Locations");
            EDIT_UPSELLS = AllPermissions.loadPermission("Edit Upsells");
            DEBTOR_FORCE_CHECK_OUT = AllPermissions.loadPermission("Force Room Checkout");
            VOUCHER_REPORTS = AllPermissions.loadPermission(VoucherReports);
            ACCESS_ADVANCED_ORDERMATE_PROPERTIES = AllPermissions.loadPermission("Access Advanced Ordermate Properties");
            EDIT_ADVANCED_ORDERMATE_PROPERTIES = AllPermissions.loadPermission("Edit Advanced Ordermate Properties");
            ACCESS_BUSINESS_NAME_NUMBER = AllPermissions.loadPermission("Access Business Name Number");
            ACCESS_BUSINESS_INFO = AllPermissions.loadPermission("Access Business Info");
            USE_STOCK_CONTROL = AllPermissions.loadPermission("Use Stock Control");
            ACCESS_STOCK_CONTROL_OPTIONS = AllPermissions.loadPermission("Access Stock Control options");
            EDIT_ITEM_INGREDIENTS = AllPermissions.loadPermission("Edit Item Ingredients");
            ACCESS_SUPPLIERS_SCREEN = AllPermissions.loadPermission("Access Suppliers screen");
            ADD_SUPPLIERS = AllPermissions.loadPermission("Add Supplier");
            EDIT_SUPPLIERS = AllPermissions.loadPermission("Edit Supplier");
            DELETE_SUPPLIERS = AllPermissions.loadPermission("Delete Supplier");
            ACCESS_STOCK_AREAS_SCREEN = AllPermissions.loadPermission("Access Stock Areas screen");
            ADD_STOCK_AREAS = AllPermissions.loadPermission("Add Stock Area");
            EDIT_STOCK_AREAS = AllPermissions.loadPermission("Edit Stock Area");
            DELETE_STOCK_AREAS = AllPermissions.loadPermission("Delete Stock Area");
            ACCESS_STOCK_ITEMS_SCREEN = AllPermissions.loadPermission("Access Stock Items screen");
            ADD_STOCK_ITEMS = AllPermissions.loadPermission("Add Stock Item");
            EDIT_STOCK_ITEMS = AllPermissions.loadPermission("Edit Stock Item");
            EDIT_STOCK_ITEM_WITH_USAGE = AllPermissions.loadPermission("Edit Stock Item With Usage");
            DELETE_STOCK_ITEMS = AllPermissions.loadPermission("Delete Stock Item");
            ACCESS_ITEM_INGREDIENTS_SCREEN = AllPermissions.loadPermission(AccessItemIngredientsscreen);
            ACCESS_OPTION_INGREDIENTS_SCREEN = AllPermissions.loadPermission("Add Option Ingredients Item");
            ACCESS_INVOICES_SCREEN = AllPermissions.loadPermission("Access Invoices screen");
            ADD_INVOICES = AllPermissions.loadPermission("Add invoice");
            EDIT_INVOICES = AllPermissions.loadPermission("Edit invoice");
            DELETE_INVOICES = AllPermissions.loadPermission("Delete invoice");
            ACCESS_SUGGESTED_ORDER_SCREEN = AllPermissions.loadPermission("Access Suggested Order screen");
            CREATE_PURCHASE_ORDER = AllPermissions.loadPermission("Create Purchase Order");
            ALLOW_ORDERING_FROM_SUPPLIERS = AllPermissions.loadPermission("Allow Ordering from Suppliers");
            ACCESS_STOCKTAKES_SCREEN = AllPermissions.loadPermission(AccessStocktakescreen);
            CREATE_STOCKTAKE = AllPermissions.loadPermission("Create Stocktake");
            EDIT_STOCKTAKE = AllPermissions.loadPermission("Edit Stocktake");
            DELETE_STOCKTAKE = AllPermissions.loadPermission("Delete Stocktake");
            SAVE_STOCKTAKE = AllPermissions.loadPermission("Save Stocktake");
            DISPLAY_STOCKTAKE_EXPECTED_COLUMN = AllPermissions.loadPermission("Display Stocktake theoretical column");
            ACCESS_ADJUSTMENT_SCREEN = AllPermissions.loadPermission("Access Adjustments screen");
            ADD_ADJUSTMENTS = AllPermissions.loadPermission("Add adjustment");
            EDIT_ADJUSTMENTS = AllPermissions.loadPermission("Edit adjustment");
            CHANGE_ADJUSTMENT_USER = AllPermissions.loadPermission("Change adjustment user");
            DELETE_ADJUSTMENTS = AllPermissions.loadPermission("Delete adjustment");
            ACCESS_TRANSFER_SCREEN = AllPermissions.loadPermission("Access Transfers screen");
            ADD_TRANSFERS = AllPermissions.loadPermission("Add transfer");
            EDIT_TRANSFERS = AllPermissions.loadPermission("Edit transfer");
            CHANGE_TRANSFER_USER = AllPermissions.loadPermission("Change transfer user");
            DELETE_TRANSFERS = AllPermissions.loadPermission("Delete transfer");
            ACCESS_WASTAGES_SCREEN = AllPermissions.loadPermission(AccessWastagesScreen);
            ADD_WASTAGES = AllPermissions.loadPermission("Add wastage");
            EDIT_WASTAGES = AllPermissions.loadPermission("Edit wastage");
            CHANGE_WASTAGE_USER = AllPermissions.loadPermission("Change wastage user");
            DELETE_WASTAGES = AllPermissions.loadPermission("Delete wastage");
            ACCESS_PRE_PRODUCTION_SCREEN = AllPermissions.loadPermission("Access Pre Production Screen");
            ACCESS_STOCK_ON_HAND_REPORT = AllPermissions.loadPermission(AccessStockOnHandReport);
            ACCESS_ITEM_GP_REPORT = AllPermissions.loadPermission(AccessItemGPReport);
            ACCESS_STOCK_USAGE_REPORT = AllPermissions.loadPermission(AccessStockUsageReport);
            ACCESS_COGS_REPORT = AllPermissions.loadPermission(AccessCOGSReport);
            ACCESS_PERIOD_STOCK_REPORT = AllPermissions.loadPermission(AccessPeriodStockReport);
            ACCESS_SALES_BY_AREA_REPORT = AllPermissions.loadPermission(AccessSalesByAreaReport);
            ACCESS_SALES_BY_AREA_REPORT = AllPermissions.loadPermission(AccessSalesByAreaReport);
            EDIT_PRICE_UPDATE_METHOD = AllPermissions.loadPermission("Price Update Method");
            EMAIL_TAX_INVOICES = AllPermissions.loadPermission("Email & Download Tax Invoices");
            EMAIL_TAX_INVOICES_WAITERMATE = AllPermissions.loadPermission("Email Tax Invoices");
            EMAIL_PO_TO_SUPPLIER = AllPermissions.loadPermission("Email PO to Supplier");
            DOWNLOAD_ACCOUNT = AllPermissions.loadPermission("Download Account");
            ADD_PRIVILEGE_GROUP = AllPermissions.loadPermission("Add Privilege Group");
            EDIT_PRIVILEGE_GROUP = AllPermissions.loadPermission("Edit Privilege Group");
            DELETE_PRIVILEGE_GROUP = AllPermissions.loadPermission("Delete Privilege Group");
            MODIFY_IP = AllPermissions.loadPermission("Modify IP Address");
            STOCK_INVOICE_DATE_CORRECTION = AllPermissions.loadPermission("Edit Stock Invoice - Date Correction");
            DELIVERY_NOTE_PRICE_CORRECTION = AllPermissions.loadPermission("Delivery Note - Price Correction");
            DELIVERY_NOTE_QTY_CORRECTION = AllPermissions.loadPermission("Delivery Note - Quantity Correction");
            DELIVERY_NOTE_ITEM_ADD = AllPermissions.loadPermission("Delivery Note - Adding Items");
            DELIVERY_NOTE_ITEM_REMOVE = AllPermissions.loadPermission("Delivery Note - Removing Items");
            INVOICE_PRICE_CORRECTION = AllPermissions.loadPermission("Invoice - Price Correction");
            INVOICE_QTY_CORRECTION = AllPermissions.loadPermission("Invoice - Quantity Correction");
            INVOICE_ITEM_ADD = AllPermissions.loadPermission("Invoice - Adding Items");
            INVOICE_ITEM_REMOVE = AllPermissions.loadPermission("Invoice - Removing Items");
            CREDIT_NOTE_PRICE_CORRECTION = AllPermissions.loadPermission("Credit Note - Price Correction");
            CREDIT_NOTE_QTY_CORRECTION = AllPermissions.loadPermission("Credit Note - Quantity Correction");
            CREDIT_NOTE_ITEM_ADD = AllPermissions.loadPermission("Credit Note - Adding Items");
            CREDIT_NOTE_ITEM_REMOVE = AllPermissions.loadPermission("Credit Note - Removing Items");
            PURCHASE_ORDER_PRICE_CORRECTION = AllPermissions.loadPermission("Purchase Order - Price Correction");
            PURCHASE_ORDER_QTY_CORRECTION = AllPermissions.loadPermission("Purchase Order - Quantity Correction");
            PURCHASE_ORDER_ITEM_ADD = AllPermissions.loadPermission("Purchase Order - Adding Items");
            PURCHASE_ORDER_ITEM_REMOVE = AllPermissions.loadPermission("Purchase Order - Removing Items");
            PERFORM_MOTO = AllPermissions.loadPermission("MOTO");
            ACCESS_OPAY_SETTINGS = AllPermissions.loadPermission("Access Opay Settings");
            PAYMENT_TYPE = AllPermissions.loadPermission("Payment Type");
            PermissionLoader.disposeOfInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load permissions", ex);
        }
    }

    static {
        GOD_ONLY = new GodPermission();
        loadPermissionQueryPrefix = "SELECT config_permission.* FROM config_permission WHERE Name = '";
        AllPermissions.loadAllPermissions();
    }
}

