/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.users;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.users.OMApplication;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_permission")
@AccessType(value="property")
@AttributeOverride(name="label", column=@Column(name="Name"))
public class Permission
extends PersistentObject
implements Comparable<Permission> {
    public static final Props Properties = new Props();
    public static String godOnly_Category = "Dealer Configuration";
    private String name = "";
    private String description = "";
    private String category = "";
    private OMApplication application = OMApplication.WaiterMate;

    public Permission() {
    }

    public Permission(Permission toCopy) {
        this.setName(toCopy.getName());
        this.setDescription(toCopy.getDescription());
        this.setCategory(toCopy.getCategory());
        this.setApplication(toCopy.getApplication());
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Column(name="category")
    public String getCategory() {
        return this.category;
    }

    @Transient
    public boolean isStockControlPermission() {
        return Permission.isCategoryStockControl(this.getCategory());
    }

    public static boolean isCategoryStockControl(String category) {
        return category.startsWith("Stock");
    }

    @Override
    public int compareTo(Permission p) {
        int retval = this.category.compareTo(p.getCategory());
        if (retval == 0) {
            retval = this.name.compareTo(p.getName());
        }
        return retval;
    }

    @Transient
    String getDefaultPermission() {
        return "DISABLED";
    }

    protected void setCategory(String newCategory) {
        this.category = newCategory;
    }

    protected void setName(String newName) {
        this.name = newName;
    }

    protected void setDescription(String newDescription) {
        this.description = newDescription;
    }

    @Column(name="application")
    @Enumerated(value=EnumType.STRING)
    public OMApplication getApplication() {
        return this.application;
    }

    protected void setApplication(OMApplication application) {
        this.application = application;
    }

    public static Permission getPermissionByName(String name) {
        String sql = Query.select(Permission.class).equals(Permission.Properties.NAME, name).toString();
        return PersistenceManager.getObjectList(Permission.class, sql, null).get(0);
    }

    public static List<Permission> getAlPermissionList() {
        String sql = Query.select(Permission.class).toString();
        return PersistenceManager.getObjectList(Permission.class, sql, null);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property NAME;
        public PropertiedObject.Property DESCRIPTION;
        public PropertiedObject.Property CATEGORY;
        public PropertiedObject.Property<OMApplication> APPLICATION;
    }
}

