/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.users;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentList;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.Syncable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionGroupLink;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="config_permission_group")
@AccessType(value="property")
@AttributeOverride(name="label", column=@Column(name="Name"))
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class PermissionGroup
extends PersistentDisplayableObject
implements Saveable,
Syncable {
    public static final int SYSTEM_ADMINISTRATOR_LEVEL = 9;
    public static final int DEALER_LEVEL = 7;
    public static final int MINIMUM_LEVEL = 1;
    public static final String PERMANENT_PERMISSION_GROUP = "Administrator";
    public static final Props Properties = new Props();
    private String systemState = "ACTIVE";
    private PersistentWriteableList<PermissionGroupLink> permissionLinks;
    private int level;
    private String aliasLabel;
    private Date updateDate;
    private transient boolean firstSave;
    @Transient
    private transient Map<Long, PermissionGroupLink> accessLevelCache;
    public static final String HIDDEN = "HIDDEN";
    public static final String DISABLED = "DISABLED";
    public static final String ENABLED = "ENABLED";
    private static PermissionGroup godPermissionGroup;
    private static final LocalCacheListManager<PermissionGroup> cachedPermissionGroups;

    @Deprecated
    public PermissionGroup() {
        this.permissionLinks = this.createWriteableList(PermissionGroup.Properties.PERMISSION_LINKS);
        this.level = 1;
        this.aliasLabel = null;
        this.updateDate = new Date(0L);
        this.firstSave = true;
        this.accessLevelCache = new HashMap<Long, PermissionGroupLink>(200);
    }

    public PermissionGroup(PermissionGroup groupToCopy) {
        this.permissionLinks = this.createWriteableList(PermissionGroup.Properties.PERMISSION_LINKS);
        this.level = 1;
        this.aliasLabel = null;
        this.updateDate = new Date(0L);
        this.firstSave = true;
        this.accessLevelCache = new HashMap<Long, PermissionGroupLink>(200);
        this.setLabel(groupToCopy.getLabel());
        this.setLevel(groupToCopy.getLevel());
        this.setAliasLabel(groupToCopy.getAliasLabel());
    }

    private static void initGodPermissionGroup() {
        if (godPermissionGroup == null) {
            godPermissionGroup = new PermissionGroup(){
                private Long cachedID = null;

                @Override
                public void save() {
                }

                @Override
                public void delete() {
                }

                @Override
                public boolean hasChanged() {
                    return false;
                }

                @Override
                public String getAccessLevel(Permission perm) {
                    return PermissionGroup.ENABLED;
                }

                @Override
                public boolean hasPermission(Permission perm) {
                    return true;
                }

                @Override
                public int getLevel() {
                    return 9;
                }

                @Override
                public boolean isSystemAdministrator() {
                    return true;
                }

                @Override
                public boolean isPersistent() {
                    return true;
                }

                @Override
                public Long getID() {
                    if (this.cachedID == null) {
                        this.cachedID = 1.getPermissionGroupForName(PermissionGroup.PERMANENT_PERMISSION_GROUP).getID();
                    }
                    return this.cachedID;
                }

                @Override
                public PersistentObjectSnapshot getSnapshot() {
                    return null;
                }
            };
            godPermissionGroup.setLabel("System level");
            List<PermissionGroupLink> links = godPermissionGroup.getPermissionLinks();
            for (PermissionGroupLink link : links) {
                link.setAccessLevel(ENABLED);
            }
        }
    }

    public static PermissionGroup getGodPermissionGroup() {
        PermissionGroup.initGodPermissionGroup();
        return godPermissionGroup;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Column(name="alias_label")
    @Basic(optional=true)
    public String getAliasLabel() {
        return this.aliasLabel;
    }

    public void setAliasLabel(String value) {
        this.aliasLabel = value;
    }

    @Column(name="level")
    public int getLevel() {
        return this.level;
    }

    @Override
    @Column(name="update_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    @Override
    public void setUpdateDate(Date value) {
        this.updateDate = value;
    }

    public void setLevel(int newLevel) {
        if (newLevel < 1 || newLevel >= 9) {
            throw new IllegalArgumentException("The privilege level must be between 1 and 9 (excluded), cannot accept a level of " + newLevel);
        }
        this.level = newLevel;
    }

    @Transient
    public boolean isSystemAdministrator() {
        return false;
    }

    public String getAccessLevel(Permission perm) {
        if (perm == null) {
            return ENABLED;
        }
        if (this.getAccessLevelCache().isEmpty()) {
            for (PermissionGroupLink link : this.permissionLinks) {
                this.getAccessLevelCache().put(link.getPermissionID(), link);
            }
        }
        if (this.getAccessLevelCache().containsKey(perm.getID())) {
            return this.getAccessLevelCache().get(perm.getID()).getAccessLevel();
        }
        return perm.getDefaultPermission();
    }

    public void setAccessLevel(Permission perm, String access) {
        this.getPermissionLink(perm).setAccessLevel(access);
        this.getAccessLevelCache().clear();
    }

    public PermissionGroupLink getPermissionLink(Permission perm) {
        for (PermissionGroupLink link : this.permissionLinks) {
            if (link.getPermission() == null || !link.getPermission().equals(perm)) continue;
            return link;
        }
        return null;
    }

    public boolean hasPermission(Permission perm) {
        return this.getAccessLevel(perm).equals(ENABLED);
    }

    private void initPermissionLinks() {
        if (this.permissionLinks.size() == 0) {
            Set permissions = AllPermissions.getPermissions();
            for (Permission perm : permissions) {
                PermissionGroupLink link = new PermissionGroupLink(this, perm);
                this.permissionLinks.add(link);
            }
        }
    }

    @OneToMany(mappedBy="permissionGroup", targetEntity=PermissionGroupLink.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public List<PermissionGroupLink> getPermissionLinks() {
        return this.permissionLinks.getUnmodifiable();
    }

    @Override
    public void delete() {
        throw new IllegalStateException("Cannot delete a Permission Group!");
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (this.firstSave) {
            this.initPermissionLinks();
            this.firstSave = false;
        }
        this.setUpdateDate(new Date());
        PersistenceManager.save(this);
        cachedPermissionGroups.clearCache();
        this.permissionLinks.saveChild();
    }

    public static PermissionGroup getPermissionGroupForName(String name) {
        String sql = Query.select(PermissionGroup.class).active(PermissionGroup.class).equals(PermissionGroup.Properties.LABEL, name).toString();
        return PersistenceManager.getObject(PermissionGroup.class, sql, null);
    }

    public static PermissionGroup getPermissionGroupByLevel(int level) {
        String sql = Query.select(PermissionGroup.class).active(PermissionGroup.class).equals(PermissionGroup.Properties.LEVEL, level).toString();
        return PersistenceManager.getObject(PermissionGroup.class, sql, null);
    }

    public static List<PermissionGroup> getPermissionGroupUpdatedAfter(Date date) {
        String sql = Query.select(PermissionGroup.class).active(PermissionGroup.class).greaterThan(PermissionGroup.Properties.UPDATE_DATE, date, SQLDateType.TIMESTAMP).orderBy(PermissionGroup.Properties.UPDATE_DATE).toString();
        return PersistenceManager.getObjectList(PermissionGroup.class, sql, null);
    }

    public static List<PermissionGroup> getAllPermission() {
        String sql = Query.select(PermissionGroup.class).active(PermissionGroup.class).orderBy(PermissionGroup.Properties.UPDATE_DATE).toString();
        return PersistenceManager.getObjectList(PermissionGroup.class, sql, null);
    }

    public static List<PermissionGroup> getPermissionGroups() {
        return cachedPermissionGroups.getList();
    }

    public static List<PermissionGroup> getUniquePermissionGroups() {
        List<PermissionGroup> allGroups = PermissionGroup.getPermissionGroups();
        ArrayList<PermissionGroup> filteredGroups = new ArrayList<PermissionGroup>();
        HashSet<String> checkedSet = new HashSet<String>();
        for (PermissionGroup group : allGroups) {
            if (checkedSet.contains(group.getLabel())) continue;
            checkedSet.add(group.getLabel());
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    @Transient
    public static PermissionGroup getCachedPermissionGroup(PersistentObjDescriptor<PermissionGroup> desc) {
        PermissionGroup cachedGroup;
        if (desc.getID() != null && (cachedGroup = cachedPermissionGroups.getByID(desc.getID())) != null) {
            return cachedGroup;
        }
        return desc.resolveObject();
    }

    protected void setPermissionLinks(List<PermissionGroupLink> links) {
        this.permissionLinks = this.permissionLinks.clone();
        this.permissionLinks.set(links);
    }

    protected void setSystemState(String state) {
        this.systemState = state;
    }

    @Transient
    private Map<Long, PermissionGroupLink> getAccessLevelCache() {
        if (this.accessLevelCache == null) {
            this.accessLevelCache = new HashMap<Long, PermissionGroupLink>(400);
        }
        return this.accessLevelCache;
    }

    @Transient
    public List<Permission> getPermissions(Set allPermissions) {
        ArrayList<Permission> returnList = new ArrayList<Permission>();
        for (PermissionGroupLink link : this.permissionLinks) {
            if (!allPermissions.contains(link.getPermission())) continue;
            returnList.add(link.getPermission());
        }
        return returnList;
    }

    @Override
    public String toString() {
        return this.getDisplayLabel();
    }

    @Transient
    public String getDisplayLabel() {
        if (this.aliasLabel != null && !this.aliasLabel.isEmpty()) {
            return this.aliasLabel;
        }
        return this.getLabel();
    }

    public static void clearCachedPermissionsGroups() {
        cachedPermissionGroups.clearCache();
    }

    public static void setCachedPermissionGroupsQueryList(PersistentList<PermissionGroup> newList) {
        cachedPermissionGroups.setList(newList);
    }

    static {
        cachedPermissionGroups = new LocalCacheListManager<PermissionGroup>(Query.createQueryList(PermissionGroup.class, Query.select(PermissionGroup.class).active(PermissionGroup.class).orderBy(PermissionGroup.Properties.LEVEL)));
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property<PermissionGroupLink> PERMISSION_LINKS;
        public PropertiedObject.Property<String> ALIAS_LABEL;
        public PropertiedObject.Property LEVEL;
        public PropertiedObject.Property<Date> UPDATE_DATE;
        public PersistentObject.DerivedProperty<String> DISPLAY_LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)PermissionGroup.class), "displayLabel");
    }
}

