/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.users;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.persistence.Syncable;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionGroup;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="config_permission_group_link")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class PermissionGroupLink
extends PersistentObject
implements SaveableChild,
Syncable {
    public static final Props Properties = new Props();
    private Reference<PermissionGroup> permissionGroup;
    private Reference<Permission> permission;
    private String accessLevel;
    private Date updateDate;

    public PermissionGroupLink() {
        this.permissionGroup = this.createReference(PermissionGroupLink.Properties.PERMISSION_GROUP);
        this.permission = this.createReference(PermissionGroupLink.Properties.PERMISSION);
        this.accessLevel = "DISABLED";
        this.updateDate = new Date(0L);
    }

    PermissionGroupLink(PermissionGroup permGroup, Permission perm) {
        this.permissionGroup = this.createReference(PermissionGroupLink.Properties.PERMISSION_GROUP);
        this.permission = this.createReference(PermissionGroupLink.Properties.PERMISSION);
        this.accessLevel = "DISABLED";
        this.updateDate = new Date(0L);
        this.permissionGroup.set(permGroup);
        this.permission.set(perm);
    }

    public PermissionGroupLink(PermissionGroupLink toClone) {
        this.permissionGroup = this.createReference(PermissionGroupLink.Properties.PERMISSION_GROUP);
        this.permission = this.createReference(PermissionGroupLink.Properties.PERMISSION);
        this.accessLevel = "DISABLED";
        this.updateDate = new Date(0L);
        this.setPermissionGroup(toClone.getPermissionGroup());
        this.setPermission(toClone.getPermission());
        this.setAccessLevel(toClone.getAccessLevel());
    }

    public void setPermissionGroup(PermissionGroup group) {
        this.permissionGroup.set(group);
    }

    public void setPermission(Permission perm) {
        this.permission.set(perm);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_permission_group")
    public PermissionGroup getPermissionGroup() {
        return this.permissionGroup.get();
    }

    @ManyToOne
    @JoinColumn(name="FK_config_permission")
    public Permission getPermission() {
        return this.permission.get();
    }

    @Transient
    public Long getPermissionID() {
        return this.permission.getID();
    }

    @Override
    @Column(name="update_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    @Override
    public void setUpdateDate(Date value) {
        this.updateDate = value;
    }

    boolean isLinkingPermission(Permission perm) {
        if (this.permission.getObjectID() != null && this.permission.getObjectID().equals(perm.getID())) {
            return true;
        }
        if (this.permission.getObjectID() == null || perm == null) {
            return this.getPermission().equals(perm);
        }
        return false;
    }

    @Column(name="access")
    public String getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(String access) {
        PermissionGroupLink.enforceAccessValidity(access);
        this.accessLevel = access;
    }

    public static List<PermissionGroupLink> getPermissionGroupLinkUpdatedAfter(Date date) {
        String sql = Query.select(PermissionGroupLink.class).greaterThan(PermissionGroupLink.Properties.UPDATE_DATE, date, SQLDateType.TIMESTAMP).orderBy(PermissionGroupLink.Properties.UPDATE_DATE).toString();
        return PersistenceManager.getObjectList(PermissionGroupLink.class, sql, null);
    }

    public static List<PermissionGroupLink> getAllPermissionGroupLink() {
        String sql = Query.select(PermissionGroupLink.class).orderBy(PermissionGroupLink.Properties.UPDATE_DATE).toString();
        return PersistenceManager.getObjectList(PermissionGroupLink.class, sql, null);
    }

    private static void enforceAccessValidity(String accessLevel) throws IllegalArgumentException {
        if (!PermissionGroupLink.isValidAccessLevel(accessLevel)) {
            throw new IllegalArgumentException("Access level must be one of \"ENABLED\", \"DISABLED\", or \"HIDDEN\": \"" + accessLevel + "\"");
        }
    }

    static boolean isValidAccessLevel(String accessLevel) {
        return accessLevel.equals("ENABLED") || accessLevel.equals("DISABLED") || accessLevel.equals("HIDDEN");
    }

    @Override
    public void deleteChild() {
        throw new UnsupportedOperationException("PermissionGroupLinks may not be deleted dynamically");
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        this.setUpdateDate(new Date());
        PersistenceManager.saveChild(this);
    }

    public static PermissionGroupLink getPermissionGroupLink(PermissionGroup permGroup, Permission perm) {
        String sql = Query.select(PermissionGroupLink.class).equals(PermissionGroupLink.Properties.PERMISSION, perm).equals(PermissionGroupLink.Properties.PERMISSION_GROUP, permGroup).toString();
        return PersistenceManager.getObject(PermissionGroupLink.class, sql, null);
    }

    @Override
    public String toString() {
        return super.toString() + " linking group: " + this.permissionGroup.getID() + " to permission : " + this.permission.getID();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Permission> PERMISSION;
        public PropertiedObject.Property<PermissionGroup> PERMISSION_GROUP;
        public PropertiedObject.Property ACCESS_LEVEL;
        public PropertiedObject.Property<Date> UPDATE_DATE;
    }
}

