/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.users;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ordermate.database.users.Permission;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class PermissionLoader {
    private static PermissionLoader instance;
    protected final Map<String, Permission> allPermissions;

    public static synchronized PermissionLoader getInstance() {
        if (instance == null) {
            instance = new PermissionLoader();
        }
        return instance;
    }

    public static void disposeOfInstance() {
        instance = null;
    }

    public PermissionLoader() {
        this(PersistenceManager.getObjectList(Permission.class, Query.select(Permission.class).toString(), PersistenceManager.EMPTY_OBJECT_ARRAY));
    }

    public PermissionLoader(List<Permission> permissionList) {
        HashMap<String, Permission> permissionLocal = new HashMap<String, Permission>();
        for (Permission currentPerm : new HashSet<Permission>(permissionList)) {
            if (permissionLocal.containsKey(currentPerm.getName())) continue;
            permissionLocal.put(currentPerm.getName(), currentPerm);
        }
        this.allPermissions = new CaseInsensitiveMap(permissionLocal);
    }

    public Permission load(String permissionName) {
        return this.allPermissions.get(permissionName);
    }

    public static void setInstance(PermissionLoader newInstance) {
        instance = newInstance;
    }
}

