/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.users;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.Syncable;
import au.com.ordermate.persistence.synchronisation.PersistenceListener;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.PermissionGroupLink;
import ordermate.database.users.User;
import ordermate.integration.permission.StoreSyncManager;

public class StoreSyncInterceptor
implements PersistenceListener {
    private final Map<Long, Date> loginSnaps = new HashMap<Long, Date>();
    private static StoreSyncInterceptor instance;
    private StoreSyncManager storeSyncManager = StoreSyncManager.getInstance();

    private StoreSyncInterceptor() {
    }

    public static StoreSyncInterceptor getInstance() {
        if (instance == null) {
            instance = new StoreSyncInterceptor();
        }
        return instance;
    }

    @Override
    public void objectChanged(PersistentObjectSnapshot snapshot, PersistenceOperation operation) {
        Object object;
        if (this.shouldSend(snapshot, operation) && (object = PersistenceManager.getByID(snapshot.getID(), snapshot.getObjectType())) != null && object instanceof Syncable) {
            this.storeSyncManager.update((PersistentObject)object);
        }
    }

    private boolean shouldSend(PersistentObjectSnapshot snapshot, PersistenceOperation operation) {
        if (PersistenceOperation.SAVE.equals((Object)operation) || PersistenceOperation.UPDATE.equals((Object)operation)) {
            if (PermissionGroup.class.isAssignableFrom(snapshot.getObjectType()) || PermissionGroupLink.class.isAssignableFrom(snapshot.getObjectType())) {
                return true;
            }
            if (User.class.isAssignableFrom(snapshot.getObjectType())) {
                if (PersistenceOperation.SAVE.equals((Object)operation)) {
                    return true;
                }
                Date current = this.loginSnaps.get(snapshot.getID());
                if (current != null) {
                    if (current.equals(snapshot.get(User.Properties.LAST_LOGIN))) {
                        return true;
                    }
                    this.loginSnaps.put(snapshot.getID(), snapshot.get(User.Properties.LAST_LOGIN));
                    return false;
                }
                this.loginSnaps.put(snapshot.getID(), snapshot.get(User.Properties.LAST_LOGIN));
                return true;
            }
        }
        return false;
    }
}

