/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.users;

import au.com.ordermate.gui.CompositeIconGenerator;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.Syncable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.awt.Color;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.departments.Department;
import ordermate.database.departments.Payrate;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.integration.drivertracking.DriverTrackingConfig;
import ordermate.database.misc.ApplicationType;
import ordermate.database.misc.SystemPassword;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionGroup;
import ordermate.gui.modify.security.UserSecurityManager;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import stockmate.database.interfaces.UserI;

@Entity
@Table(name="config_user")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@DiscriminatorColumn(name="user_type")
@DiscriminatorValue(value="ORDERMATE")
public class User
extends PersistentObject
implements Serializable,
Saveable,
UserI,
Displayable,
Syncable {
    public static final Color DELIVERY_ASSIGNED = new Color(255, 0, 0);
    private static final String SWIPECARD_PREFIX = "%ordermate-";
    private static final String SWIPECARD_SUFFIX = "?";
    public static final Props Properties = new Props();
    private String firstName;
    private String lastName;
    private String pin;
    private boolean driver;
    private String password;
    private Reference<PermissionGroup> permissionGroup;
    private String cardID;
    private String proximityBand;
    private String mobile;
    private String email;
    private Date dateOfBirth;
    private String systemState;
    private boolean hidden;
    private Price floatAmount;
    private String payrollID;
    private Date lastLogin;
    private Date updateDate;
    private boolean active;
    private Price perDeliveryRate;
    private Long hoId;
    private boolean autoAssign;
    private transient PermissionGroup cachedPermissionGroup;
    private transient UserSecurityManager userSecurityManager;
    private static User systemUser;
    private static User systemAdministrator;
    private PersistentWriteableList<Payrate> payrates;
    private Reference<DriverTrackingConfig> driverTracking;
    private boolean emailVerified;
    private static LocalCacheListManager<User> allUsers;
    private static LocalCacheListManager<User> allDrivers;

    public User() {
        this.permissionGroup = this.createReference(User.Properties.PERMISSION_GROUP);
        this.cardID = "";
        this.systemState = "ACTIVE";
        this.floatAmount = new Price(0.0, 0.01);
        this.updateDate = new Date(0L);
        this.active = true;
        this.perDeliveryRate = new Price(Price.ZERO_DOLLAR, 0.01);
        this.autoAssign = false;
        this.payrates = this.createWriteableList(User.Properties.PAYRATES);
        this.driverTracking = this.createReference(User.Properties.DRIVER_TRACKING);
        this.emailVerified = false;
    }

    protected User(User user) {
        this.permissionGroup = this.createReference(User.Properties.PERMISSION_GROUP);
        this.cardID = "";
        this.systemState = "ACTIVE";
        this.floatAmount = new Price(0.0, 0.01);
        this.updateDate = new Date(0L);
        this.active = true;
        this.perDeliveryRate = new Price(Price.ZERO_DOLLAR, 0.01);
        this.autoAssign = false;
        this.payrates = this.createWriteableList(User.Properties.PAYRATES);
        this.driverTracking = this.createReference(User.Properties.DRIVER_TRACKING);
        this.emailVerified = false;
        this.setID(user.getID());
        this.firstName = user.firstName;
        this.lastName = user.lastName;
        this.pin = user.pin;
        this.driver = user.driver;
        this.password = user.password;
        this.setPermissionGroup(user.getCachedPermissionGroup());
        this.cardID = user.getCardID();
        this.proximityBand = user.getProximityBand();
        this.systemState = "ACTIVE";
        this.hidden = user.hidden;
        this.floatAmount = user.floatAmount;
        this.payrollID = user.payrollID;
        this.active = user.active;
        this.hoId = user.hoId;
        this.updateDate = user.updateDate;
        this.emailVerified = user.emailVerified;
        this.setPerDeliveryRate(user.getPerDeliveryRate());
    }

    @Override
    @Transient
    public String getLabel() {
        return this.getName();
    }

    @Transient
    public String getName() {
        return this.firstName + " " + this.lastName;
    }

    @Column(name="FirstName")
    public String getFirstName() {
        return this.firstName;
    }

    @Column(name="Surname")
    public String getLastName() {
        return this.lastName;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setFirstName(String name) {
        this.firstName = name;
    }

    public void setLastName(String name) {
        this.lastName = name;
    }

    @Column(name="is_driver")
    public boolean isDriver() {
        return this.driver;
    }

    public void setDriver(boolean newDriver) {
        this.driver = newDriver;
    }

    @Column(name="Pin")
    public String getPin() {
        return this.pin;
    }

    public void setPerDeliveryRate(Price perDeliveryRate) {
        if (perDeliveryRate != null && perDeliveryRate.lessThan(Price.ZERO_DOLLAR)) {
            throw new IllegalArgumentException("Cannot set per delivery rate to a negative value.  Received: " + perDeliveryRate);
        }
        this.perDeliveryRate = perDeliveryRate;
    }

    @Column(name="per_delivery_rate")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getPerDeliveryRate() {
        return this.perDeliveryRate;
    }

    public void setPin(String str) {
        this.pin = str;
    }

    @Column(name="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    @Column(name="Active")
    public boolean isActive() {
        return this.active;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="FK_config_permission_group")
    public PermissionGroup getPermissionGroup() {
        return this.permissionGroup.get();
    }

    @Transient
    public PermissionGroup getCachedPermissionGroup() {
        PermissionGroup group = this.findCachedPermissionGroup();
        if (group == null) {
            return this.permissionGroup.get();
        }
        return group;
    }

    private PermissionGroup findCachedPermissionGroup() {
        if (this.cachedPermissionGroup == null && this.permissionGroup.getID() != null && this.permissionGroup.isExpanded() && !this.permissionGroup.get().isSystemAdministrator()) {
            PersistentObjDescriptor<PermissionGroup> group = new PersistentObjDescriptor<PermissionGroup>(this.permissionGroup);
            this.cachedPermissionGroup = this.userSecurityManager != null ? this.userSecurityManager.getCachedPermissionGroup(group) : PermissionGroup.getCachedPermissionGroup(group);
        }
        return this.cachedPermissionGroup;
    }

    public void setPermissionGroup(PermissionGroup group) {
        this.permissionGroup.set(group);
    }

    @Column(name="Hidden")
    public boolean isHidden() {
        return this.hidden;
    }

    public boolean hasPermission(Permission permission) {
        if (this.isSystemAdministrator()) {
            return true;
        }
        return this.getCachedPermissionGroup().hasPermission(permission);
    }

    public String getPermissionAccessLevel(Permission permission) {
        return this.getCachedPermissionGroup().getAccessLevel(permission);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="float_amount")
    public Price getFloatAmount() {
        return this.floatAmount;
    }

    public void setFloatAmount(double amt) {
        this.floatAmount = new Price(amt, 0.0);
    }

    public void setFloatAmount(Price amt) {
        this.floatAmount = amt;
    }

    public void setProximityBand(String proxBandID) {
        this.proximityBand = proxBandID;
    }

    public void setSwipecard(String swipecard) {
        this.cardID = swipecard;
    }

    @Transient
    public String getSwipecard() {
        return this.cardID;
    }

    @Column(name="UserID")
    public String getCardID() {
        return this.cardID == null ? this.cardID : StringUtils.formatSwipeCardForDisplay(this.cardID);
    }

    public void setCardID(String displayableCardID) {
        this.cardID = SWIPECARD_PREFIX + displayableCardID + SWIPECARD_SUFFIX;
    }

    @Column(name="proximity_band_id")
    public String getProximityBand() {
        return this.proximityBand;
    }

    public static User getUserByPin(String pin) {
        if (pin == null || pin.trim().isEmpty()) {
            return null;
        }
        String sql = Query.select(User.class).equals(User.Properties.PIN, pin).equals(User.Properties.SYSTEM_STATE, "ACTIVE").isNull(User.Properties.HO_ID).toString();
        User user = PersistenceManager.getObject(User.class, sql, null);
        if (user == null) {
            sql = Query.select(User.class).equals(User.Properties.PIN, pin).equals(User.Properties.SYSTEM_STATE, "ACTIVE").toString();
            user = PersistenceManager.getObject(User.class, sql, null);
        }
        return user;
    }

    public static User getUserByEmail(String email) {
        if (email == null || email.trim().isEmpty()) {
            return null;
        }
        String sql = Query.select(User.class).equals(User.Properties.EMAIL, email).equals(User.Properties.SYSTEM_STATE, "ACTIVE").isNull(User.Properties.HO_ID).toString();
        User user = PersistenceManager.getObject(User.class, sql, null);
        if (user == null) {
            sql = Query.select(User.class).equals(User.Properties.EMAIL, email).equals(User.Properties.SYSTEM_STATE, "ACTIVE").toString();
            user = PersistenceManager.getObject(User.class, sql, null);
        }
        return user;
    }

    public static User getUserBySwipecardHO(String cardID) {
        String sql = Query.select(User.class).equals(User.Properties.CARD_ID, cardID).equals(User.Properties.SYSTEM_STATE, "ACTIVE").toString();
        User user = PersistenceManager.getObject(User.class, sql, null);
        if (user != null && user.equals(User.getSystemAdministrator())) {
            return User.getSystemAdministrator();
        }
        return user;
    }

    public static User getUserBySwipecard(String cardID) {
        if (PersistenceManager.getPersistenceDelegate().isHeadOffice()) {
            return User.getUserBySwipecardHO(cardID);
        }
        if (SystemPassword.validate(cardID, ApplicationType.WaiterMate)) {
            return User.getSystemAdministrator();
        }
        if (cardID.equals("%vcs")) {
            return null;
        }
        String sql = Query.select(User.class).equals(User.Properties.CARD_ID, cardID).equals(User.Properties.SYSTEM_STATE, "ACTIVE").toString();
        User user = PersistenceManager.getObject(User.class, sql, null);
        return user;
    }

    public static User getUserByProximityBand(String bandID) {
        String sql = Query.select(User.class).equals(User.Properties.PROXIMITY_BAND, bandID).equals(User.Properties.SYSTEM_STATE, "ACTIVE").toString();
        return PersistenceManager.getObject(User.class, sql, null);
    }

    public static List<User> getUsers() {
        if (allUsers == null) {
            allUsers = new LocalCacheListManager<User>(Query.createQueryList(User.class, Query.select(User.class).active(User.class).equals(User.Properties.HIDDEN, 0.0).orderBy(User.Properties.FIRST_NAME).orderBy(User.Properties.LAST_NAME)));
        }
        return allUsers.getList();
    }

    public static List<User> getUsersUpdatedAfter(Date lastSyncTime) {
        String sql = Query.select(User.class).active(User.class).equals(User.Properties.HIDDEN, 0.0).not().isNull(User.Properties.EMAIL).not().isStringEmpty(User.Properties.EMAIL).greaterThan(User.Properties.UPDATE_DATE, lastSyncTime, SQLDateType.TIMESTAMP).equals(User.Properties.SYSTEM_STATE, "ACTIVE").orderBy(User.Properties.UPDATE_DATE).toString();
        return PersistenceManager.getObjectList(User.class, sql, null);
    }

    public static List<User> getAllUsersHasEmail() {
        String sql = Query.select(User.class).active(User.class).equals(User.Properties.HIDDEN, 0.0).not().isNull(User.Properties.EMAIL).not().isStringEmpty(User.Properties.EMAIL).equals(User.Properties.SYSTEM_STATE, "ACTIVE").orderBy(User.Properties.UPDATE_DATE).toString();
        return PersistenceManager.getObjectList(User.class, sql, null);
    }

    public static List<User> getClockedOnDrivers() {
        List<User> users = PersistenceManager.getObjectList(User.class, "SELECT config_user.* FROM finance_timesheet, config_user WHERE finance_timesheet.Time_OUT IS NULL AND config_user.is_driver = '1'AND finance_timesheet.FK_config_user = config_user.ID", null);
        return users;
    }

    public static List<User> getAllDrivers() {
        return allDrivers.getList();
    }

    public static List<User> getUsersWithPayoffPrivileges() {
        ArrayList<User> usersWhoCanPay = new ArrayList<User>();
        for (User user : User.getUsers()) {
            if (!user.hasPermission(AllPermissions.PAY)) continue;
            usersWhoCanPay.add(user);
        }
        return usersWhoCanPay;
    }

    public static synchronized User getSystemUser() {
        if (systemUser == null && (systemUser = User.getUserBySwipecard("OrderMate")) == null) {
            throw new IllegalStateException("Cannot find OrderMate user in DB");
        }
        return systemUser;
    }

    public static synchronized User getSystemAdministrator() {
        if (systemAdministrator == null) {
            String sql = Query.select(User.class).equals(User.Properties.CARD_ID, "%00110").equals(User.Properties.SYSTEM_STATE, "ACTIVE").toString();
            User templateUser = PersistenceManager.getObject(User.class, sql, PersistenceManager.EMPTY_OBJECT_ARRAY);
            if (templateUser == null) {
                IllegalStateException ex = new IllegalStateException("Cannot find the OrderMate administrator user in DB");
                OrderMate.LOG.error("Could not find the ordermate administrator user in the DB, cannot log in as system admin", (Throwable)ex);
                throw ex;
            }
            systemAdministrator = templateUser;
            systemAdministrator.setPermissionGroup(PermissionGroup.getGodPermissionGroup());
        }
        return systemAdministrator;
    }

    @Transient
    public boolean isSystemAdministrator() {
        return this.getCachedPermissionGroup() == PermissionGroup.getGodPermissionGroup();
    }

    @OneToMany(mappedBy="user", targetEntity=Payrate.class, fetch=FetchType.LAZY)
    public List<Payrate> getPayrates() {
        return this.payrates.getUnmodifiable();
    }

    public void addPayrate(Payrate newPayrate) {
        this.payrates.add(newPayrate);
    }

    public void removePayrate(Payrate newPayrate) {
        this.payrates.remove(newPayrate);
    }

    protected void setPayrates(List<Payrate> newPayrates) {
        this.payrates = this.payrates.clone();
        this.payrates.set(newPayrates);
    }

    public Payrate getPayrate(Department deptClockingOnTo) {
        for (Payrate toCheck : this.payrates) {
            if (!toCheck.getDepartment().equals(deptClockingOnTo)) continue;
            return toCheck;
        }
        return null;
    }

    @Transient
    public boolean isClockedOn() {
        try {
            return Data.database.isUserClockedOn(this.intID());
        }
        catch (RemoteException e) {
            Data.handleException(e);
            return false;
        }
    }

    public void clockOn(Department dept) {
        try {
            Data.database.clockUserOn(this.intID(), dept.intID(), this.getPayrate(dept).getPayRate().doubleValue());
            TerminalEventLog.logClockOnOff(this, true);
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    public void clockOff() {
        try {
            long timesheetId = Data.database.clockUserOff(this.intID());
            FinanceTimesheet timesheet = PersistenceManager.getByID(timesheetId, FinanceTimesheet.class);
            if (timesheet != null) {
                timesheet.save();
            }
            TerminalEventLog.logClockOnOff(this, false);
        }
        catch (RemoteException e) {
            Data.handleException(e);
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.setUpdateDate(new Date());
        PersistenceManager.save(this);
        this.payrates.saveChild();
    }

    @Override
    public void delete() {
        this.systemState = "DELETED";
        this.pin = null;
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="Payroll_ID")
    public String getPayrollID() {
        return this.payrollID;
    }

    public boolean hasPayrollID() {
        return this.payrollID != null && !this.payrollID.isEmpty();
    }

    public void setPayrollID(String userPayrollID) {
        this.payrollID = userPayrollID;
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    @Override
    @Transient
    public String getIcon() {
        String icon = null;
        if (this.isAutoAssign()) {
            if (this.isClockedOn()) {
                CompositeIconGenerator gen = new CompositeIconGenerator(32, 0);
                gen.addIcon("/ordermate/images/clock32.png");
                gen.addIcon("/waitermate/images/ok32.png");
                return gen.generateIcon();
            }
            return "/waitermate/images/ok32.png";
        }
        if (this.isClockedOn()) {
            icon = "/ordermate/images/clock32.png";
        }
        return icon;
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public void setHidden(boolean hide) {
        this.hidden = hide;
    }

    public void setSystemState(String state) {
        this.systemState = state;
    }

    @Column(name="mobile")
    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String newMobile) {
        this.mobile = newMobile;
    }

    @Column(name="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String value) {
        this.email = value;
    }

    @Column(name="dob")
    @Temporal(value=TemporalType.DATE)
    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date newDob) {
        this.dateOfBirth = newDob;
    }

    @Column(name="ho_id", nullable=true)
    public Long getHoId() {
        return this.hoId;
    }

    public void setHoId(Long value) {
        this.hoId = value;
    }

    @Transient
    public UserSecurityManager getUserSecurityManager() {
        return this.userSecurityManager;
    }

    public void setUserSecurityManager(UserSecurityManager manager) {
        this.userSecurityManager = manager;
    }

    @Transient
    public boolean isHeadOffice() {
        return this.hoId != null;
    }

    @Transient
    public List<Department> getDepartments() {
        HashSet<Department> depts = new HashSet<Department>();
        for (Payrate toCheck : this.payrates) {
            depts.add(toCheck.getDepartment());
        }
        return new ArrayList<Department>(depts);
    }

    @Column(name="last_login")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getLastLogin() {
        return this.lastLogin;
    }

    protected void setLastLogin(Date value) {
        this.lastLogin = value;
    }

    public void updateLastLogin() {
        this.lastLogin = new Date();
    }

    @Override
    @Column(name="update_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    @Override
    public void setUpdateDate(Date value) {
        this.updateDate = value;
    }

    @Transient
    public DriverTrackingConfig getDriverTracking() {
        return this.driverTracking.get();
    }

    protected void setDriverTracking(DriverTrackingConfig value) {
        this.driverTracking.set(value);
    }

    @Column(name="auto_assign")
    public boolean isAutoAssign() {
        return this.autoAssign;
    }

    public void setAutoAssign(boolean value) {
        this.autoAssign = value;
    }

    @Column(name="FK_config_driver_tracking")
    public Long getDriverTrackingId() {
        if (this.driverTracking.get() != null) {
            return this.driverTracking.get().getID();
        }
        return null;
    }

    @Deprecated
    protected void setDriverTrackingId(Long id) {
    }

    @Column(name="email_verified")
    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public void setEmailVerified(boolean emailVerified) {
        this.emailVerified = emailVerified;
    }

    static {
        allDrivers = new LocalCacheListManager<User>(Query.createQueryList(User.class, Query.select(User.class).active(User.class).equals(User.Properties.HIDDEN, 0.0).equals(User.Properties.DRIVER, 1.0).orderBy(User.Properties.FIRST_NAME).orderBy(User.Properties.LAST_NAME)));
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property FIRST_NAME;
        public PropertiedObject.Property LAST_NAME;
        public PropertiedObject.Property PIN;
        public PropertiedObject.Property DRIVER;
        public PropertiedObject.Property PASSWORD;
        public PropertiedObject.Property<PermissionGroup> PERMISSION_GROUP;
        public PropertiedObject.Property CARD_ID;
        public PropertiedObject.Property PROXIMITY_BAND;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property FLOAT_AMOUNT;
        public PropertiedObject.Property HIDDEN;
        public PropertiedObject.Property PAYROLL_ID;
        public PropertiedObject.Property ACTIVE;
        public PropertiedObject.Property PER_DELIVERY_RATE;
        public PropertiedObject.Property<String> MOBILE;
        public PropertiedObject.Property<String> EMAIL;
        public PropertiedObject.Property<Date> DATE_OF_BIRTH;
        public PropertiedObject.Property<Long> HO_ID;
        public PersistentObject.DerivedProperty<String> NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)User.class), "name");
        public PropertiedObject.Property<Payrate> PAYRATES;
        public PropertiedObject.Property<Date> LAST_LOGIN;
        public PropertiedObject.Property<Date> UPDATE_DATE;
        public PropertiedObject.Property<DriverTrackingConfig> DRIVER_TRACKING;
        public PropertiedObject.Property AUTO_ASSIGN;
        public PersistentObject.DerivedProperty<Long> DRIVER_TRACKING_ID = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)User.class), "driverTrackingId");
        public PropertiedObject.Property EMAIL_VERIFIED;
    }
}

