/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.users;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.users.User;

public class UserFingerprint
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private byte[] template;
    private Reference<User> user;
    private Finger finger;

    @Deprecated
    public UserFingerprint() {
        this.user = this.createReference(UserFingerprint.Properties.USER);
        this.finger = null;
    }

    public UserFingerprint(User theUser, Finger theFinger) {
        this.user = this.createReference(UserFingerprint.Properties.USER);
        this.finger = null;
        if (theUser == null) {
            throw new IllegalStateException("Cannot have a null user for a userFingerprint.");
        }
        if (theFinger == null) {
            throw new IllegalStateException("Cannot have a null finger for a userFingerprint.");
        }
        this.setUser(theUser);
        this.setFinger(theFinger);
    }

    public User getUser() {
        return this.user.get();
    }

    protected void setUser(User value) {
        this.user.set(value);
    }

    public byte[] getTemplate() {
        return this.template;
    }

    public void setTemplate(byte[] data) {
        this.template = data;
    }

    public Finger getFinger() {
        return this.finger;
    }

    public void setFinger(Finger theFinger) {
        this.finger = theFinger;
    }

    public static final List<UserFingerprint> getFingerprintsForUser(User user) {
        return PersistenceManager.getObjectList(UserFingerprint.class, Query.select(UserFingerprint.class).equals(UserFingerprint.Properties.USER, user).orderBy(UserFingerprint.Properties.FINGER).toString(), null);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property TEMPLATE;
        public PropertiedObject.Property FINGER;
    }

    public static enum Finger {
        LeftPinky,
        LeftRing,
        LeftMiddle,
        LeftIndex,
        LeftThumb,
        RightPinky,
        RightRing,
        RightMiddle,
        RightIndex,
        RightThumb;


        public static final Map<String, Finger> map() {
            HashMap<String, Finger> map = new HashMap<String, Finger>();
            for (Finger nextFinger : Finger.values()) {
                map.put(nextFinger.name(), nextFinger);
            }
            return map;
        }
    }
}

