/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.utils;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.util.StringUtils;
import java.util.Collections;
import java.util.List;

public class LiteralOperator
implements Operator<String> {
    private final String literal;

    public LiteralOperator(String value) {
        this.literal = value;
    }

    @Override
    public String getValue() {
        if (this.literal.startsWith("\"") && this.literal.endsWith("\"")) {
            return StringUtils.stripQuotes(this.literal);
        }
        return this.literal;
    }

    @Override
    public List<Operator> getOperands() {
        return Collections.emptyList();
    }

    @Override
    public void addOperand(Operator operand) {
    }

    @Override
    public String getLabel() {
        return "\"" + this.literal + "\"";
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getMaxOperands() {
        return 0;
    }

    @Override
    public int getMinOperands() {
        return 0;
    }
}

