/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.utils;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.persistence.util.property.PropertyValueHelper;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.online.OnlineIntegrationConfig;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.users.User;
import ordermate.database.utils.PropertyValueOperator;
import ordermate.integration.jaxb.online.sales.ObjectFactory;
import ordermate.integration.jaxb.online.sales.OrderMateSale;
import ordermate.jaxb.exporter.handlers.online.SalesAccountIntegrator;
import ordermate.jaxb.exporter.handlers.online.sales.SalesXMLIntegrationContext;

public class MarshallerOperator
extends PropertyValueOperator {
    public MarshallerOperator(AtomicReference<? extends PropertyValueHelper> helperReference, String property) {
        super(helperReference, property);
    }

    @Override
    public Object getValue() {
        String output = null;
        Object object = ((PropertyValueHelper)this.propertyHelper.get()).resolveValue(this.property);
        if (object instanceof Account) {
            output = this.handleAccount((Account)object);
        }
        return output;
    }

    @Override
    public List<Operator> getOperands() {
        return Collections.emptyList();
    }

    @Override
    public void addOperand(Operator operand) {
    }

    @Override
    public String getLabel() {
        return "#" + this.property + "#";
    }

    @Override
    public boolean isValid() {
        return ((PropertyValueHelper)this.propertyHelper.get()).resolveClazz(this.property) != null;
    }

    private String handleAccount(Account account) {
        String output = null;
        if (BarTabAccount.TYPE.getType().equals(account.getType())) {
            Terminal terminal = !Terminal.isLocalHostSetup() ? null : Terminal.getLocalHost();
            SalesXMLIntegrationContext context = new SalesXMLIntegrationContext(OnlineIntegrationConfig.getDefaultInstance().getInventoryProfile(), new EventContext(terminal, User.getSystemUser()), false);
            SalesAccountIntegrator integrator = new SalesAccountIntegrator(context);
            ObjectFactory factory = new ObjectFactory();
            OrderMateSale sale = context.getHandler(Account.class, OrderMateSale.class).exportDomainObject(account, factory);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            integrator.marshal(sale, bout);
            output = bout.toString();
        }
        return output;
    }
}

