/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.utils;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.util.property.PropertyValueHelper;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import ordermate.OrderMate;

public class PropertyValueOperator
implements Operator<Object> {
    protected final AtomicReference<? extends PropertyValueHelper> propertyHelper;
    protected final String property;

    public PropertyValueOperator(AtomicReference<? extends PropertyValueHelper> helperReference, String property) {
        this.property = property;
        this.propertyHelper = helperReference;
    }

    @Override
    public Object getValue() {
        return this.propertyHelper.get().resolveValue(this.property);
    }

    @Override
    public List<Operator> getOperands() {
        return Collections.emptyList();
    }

    @Override
    public void addOperand(Operator operand) {
    }

    @Override
    public String getLabel() {
        return "{" + this.property + "}";
    }

    @Override
    public boolean isValid() {
        try {
            PropertiedObject.Property prop = this.propertyHelper.get().resolveProperty(this.propertyHelper.get().resolveClazz(this.property), this.property);
            return prop != null;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot resolve property " + this.property);
            return false;
        }
    }

    @Override
    public int getMaxOperands() {
        return 0;
    }

    @Override
    public int getMinOperands() {
        return 0;
    }
}

