/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.utils;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.util.property.AbstractPropertyValueHelper;
import au.com.ordermate.util.StringUtils;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.users.User;

public class TriggerActivatedPropertyValueHelper
extends AbstractPropertyValueHelper {
    private TriggerActivationContext context;

    public void setContext(TriggerActivationContext yourContext) {
        this.context = yourContext;
    }

    @Override
    public Class<? extends PropertiedObject> resolveClazz(String classPropertyString) {
        if (StringUtils.isEmpty(classPropertyString)) {
            return null;
        }
        int index = classPropertyString.indexOf(".");
        if (index == 0) {
            OrderMate.LOG.error("Malformed class property String:" + classPropertyString);
            return null;
        }
        String clazzString = index == -1 ? classPropertyString : classPropertyString.substring(0, index).toLowerCase();
        Class overclazz = null;
        if (clazzString.equalsIgnoreCase("account")) {
            overclazz = Account.class;
        } else if (clazzString.equalsIgnoreCase("itemGroup")) {
            overclazz = ItemGroup.class;
        } else if (clazzString.equalsIgnoreCase("customer")) {
            overclazz = Customer.class;
        } else if (clazzString.equalsIgnoreCase("terminal")) {
            overclazz = Terminal.class;
        } else if (clazzString.equalsIgnoreCase("user")) {
            overclazz = User.class;
        } else {
            OrderMate.LOG.warn("Unknown Class:" + clazzString + " from propertyString:" + classPropertyString);
        }
        return overclazz;
    }

    @Override
    public Object resolvePropertyValue(PropertiedObject.Property property) {
        Class<PropertiedObject> clazz = property.getOwner();
        PropertiedObject operand = this.getOperand(clazz);
        if (operand == null) {
            return null;
        }
        Object value = null;
        try {
            value = PropertiedObject.PropsHelper.getPropertyValue(operand, property);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot resolve property from class", (Throwable)ex);
        }
        return value;
    }

    protected PropertiedObject getOperand(Class clazz) {
        PersistentObject operand = null;
        if (clazz != null && ItemGroup.class.isAssignableFrom(clazz)) {
            operand = Account.class.equals((Object)clazz) ? this.context.getAccount() : this.context.getItemGroup();
        } else if (User.class.equals((Object)clazz)) {
            operand = this.context.getUser();
        } else if (Customer.class.equals((Object)clazz)) {
            ItemGroup itemGp;
            operand = this.context.getCustomer();
            if (operand == null && (itemGp = this.context.getItemGroup()) != null) {
                operand = itemGp.getCustomer();
            }
        } else if (Terminal.class.equals((Object)clazz)) {
            operand = this.context.getTerminal();
        }
        return operand;
    }

    @Override
    protected Object resolveObject(String propertyString) {
        Class<? extends PropertiedObject> clazz = this.resolveClazz(propertyString);
        return this.getOperand(clazz);
    }
}

