/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.web;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.Date;
import java.util.Random;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Customer;
import ordermate.docketprocessor.DocketProcessor;
import org.apache.commons.lang.RandomStringUtils;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="web_customer_info")
@AccessType(value="property")
public class CustomerWebInfo
extends PersistentObject {
    public static final Props Properties = new Props();
    public static final int DEFAULT_PASSWORD_LENGTH = 6;
    private Reference<Customer> customer;
    private String password;
    private Date lastLogonDate;
    public static final String UPDATE_CUSTOMER_URI = "portal/customer/updateCustomer";

    public CustomerWebInfo() {
        this.customer = this.createReference(CustomerWebInfo.Properties.CUSTOMER);
        this.password = "";
    }

    public CustomerWebInfo(Customer customer) {
        this.customer = this.createReference(CustomerWebInfo.Properties.CUSTOMER);
        this.password = "";
        this.customer.set(customer);
    }

    @OneToOne
    @JoinColumn(name="fk_sales_customer", referencedColumnName="ID")
    public Customer getCustomer() {
        return this.customer.get();
    }

    public void setCustomer(Customer customer) {
        this.customer.set(customer);
    }

    @Column(name="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(name="last_logon_date")
    public Date getLastLogonDate() {
        return this.lastLogonDate;
    }

    public void setLastLogonDate(Date lastLogonDate) {
        this.lastLogonDate = lastLogonDate;
    }

    public static String generateDefaultCustomerPassword(Long id) {
        return RandomStringUtils.random((int)6, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(id));
    }

    @Transient
    private static String getPasswordDocketText(Customer customer, String password) {
        StringBuilder docketText = new StringBuilder();
        docketText.append("Card Number: " + customer.getCardID());
        docketText.append("\n");
        docketText.append("Password: " + password);
        docketText.append("\n\n");
        docketText.append(SystemProperty.getInstance().getCusPortalPasswordMsg());
        return docketText.toString();
    }

    public static void printPasswordDocketText(Customer customer) {
        if (!customer.isPersistent()) {
            throw new IllegalArgumentException("Customer must be persisted to generate default password.");
        }
        CustomerWebInfo.printPasswordDocketText(customer, CustomerWebInfo.generateDefaultCustomerPassword(customer.getID()));
    }

    public static void printPasswordDocketText(Customer customer, String password) {
        try {
            DocketProcessor.printSimpleDocketWithHeader(CustomerWebInfo.getPasswordDocketText(customer, password));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured printing reset password docket.", (Throwable)ex);
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Customer> CUSTOMER;
        public PropertiedObject.Property<String> PASSWORD;
        public PropertiedObject.Property<Date> LAST_LOGON_DATE;
    }
}

