/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow;

import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.workflow.WorkflowAccountScanRedemptionResult;

public class AccountRedemptionResultStringifier {
    private String title;
    private String information;

    public AccountRedemptionResultStringifier(WorkflowAccountScanRedemptionResult result) {
        if (result.isScanSuccessful()) {
            if (result.isAnythingRedeemed()) {
                this.title = "Thank you!";
                this.information = "Please collect your items from: " + this.getCounterList(result);
            } else {
                this.title = "Sorry!";
                this.information = "Your barcode is valid, but there aren't any items to redeem.";
                if (!result.getAlternateRedemptionTerminals().isEmpty()) {
                    this.information = this.information + "<br /><br />It looks like there are items you can redeem at: " + this.getRedemptionTerminalList(result);
                }
            }
        } else {
            this.title = "Sorry!";
            this.information = "That barcode does not seem to be valid. Please try again or see staff for help.";
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getInformationMessage() {
        return this.information;
    }

    private String getCounterList(WorkflowAccountScanRedemptionResult result) {
        StringBuilder sb = new StringBuilder("<ul id='redeemed-counter-list'>");
        for (KTSDocketPrinter counter : result.getPrintersRedeemedFrom()) {
            sb.append("<li class='redeemed-counter'>");
            sb.append(counter.getLabel());
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    private String getRedemptionTerminalList(WorkflowAccountScanRedemptionResult result) {
        StringBuilder sb = new StringBuilder("<ul id='alternate-terminal-list'>");
        for (String alternateTerminalName : result.getAlternateRedemptionTerminals()) {
            sb.append("<li class='alternate-terminal'>");
            sb.append(alternateTerminalName);
            sb.append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }
}

