/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.WorkflowHelper;
import ordermate.database.workflow.WorkflowProcess;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowPrintAction;
import ordermate.docketprocessor.WorkflowPrepPrintJob;

class TransferWorkflowProcess
extends WorkflowProcess {
    private Account targetAccount;
    private Set<SalesItemQuantity> alreadyAbsorbed;

    TransferWorkflowProcess(Account targetAccount) {
        this.targetAccount = targetAccount;
    }

    @Override
    protected void handleAbsorbedItems(Map<Workflow, WorkflowHelper> helpers) {
        this.alreadyAbsorbed = new HashSet<SalesItemQuantity>();
        for (Workflow workflow : helpers.keySet()) {
            WorkflowHelper helper = helpers.get(workflow);
            this.removeItemsFromActionSets(helper.getNewItemsList(), workflow);
            Workflow newWorkflow = this.createNewWorkflowForTargetAccount(helper, workflow);
            helpers.get(workflow).printOutAbsorbedItems(false, newWorkflow);
            newWorkflow.getPrintCache().doPrint(workflow.getAccount(), this.targetAccount);
        }
    }

    private Workflow createNewWorkflowForTargetAccount(WorkflowHelper helper, Workflow origWorkflow) {
        Workflow newWorkflow = origWorkflow.copyNoID(this.targetAccount, this.getContext());
        newWorkflow.setDateCreated(origWorkflow.getDateCreated());
        List<SalesItemQuantity> newQtys = this.getActualLinkedItems(helper.getNewItemsList());
        newWorkflow.setHandledItemQuantities(newQtys);
        this.addNewWorkflow(newWorkflow);
        this.setItemQtysFromActionSets(newQtys, newWorkflow);
        return newWorkflow;
    }

    private List<SalesItemQuantity> getActualLinkedItems(List<SalesItemQuantity> transferedQtys) {
        ArrayList<SalesItemQuantity> qtys = new ArrayList<SalesItemQuantity>();
        for (SalesItemQuantity transferedQty : transferedQtys) {
            SalesItemQuantity targetQty = this.getMatchingSalesQtyItem(transferedQty, this.targetAccount, this.alreadyAbsorbed);
            if (targetQty == null) continue;
            qtys.add(targetQty);
            this.alreadyAbsorbed.add(targetQty);
        }
        return qtys;
    }

    private void setItemQtysFromActionSets(List<SalesItemQuantity> newQtys, Workflow workflow) {
        for (WorkflowActionSet set : workflow.getActionSets()) {
            for (WorkflowAction action : set.getActions()) {
                if (!(action instanceof WorkflowPrintAction)) continue;
                ((WorkflowPrintAction)action).initialiseQuantities(newQtys);
            }
        }
    }

    @Override
    protected WorkflowPrepPrintJob createDocketForNormalQuantities(Account account, TriggerActivationContext context, List<SalesItemQuantity> normalQuantities, Workflow createdWorkflow) {
        HashSet<PrinterGroup> unhandledGroups = new HashSet<PrinterGroup>(PrinterGroup.getPrinterGroups());
        unhandledGroups.removeAll(createdWorkflow.getPrototypeHandledPrinterGroups());
        return normalQuantities.isEmpty() ? null : new WorkflowPrepPrintJob(account, context, null, null, normalQuantities, unhandledGroups, this.targetAccount, this.prepJob.isRushed());
    }
}

