/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ordermate.database.EventContext;
import ordermate.database.Sequenced;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.users.User;
import ordermate.database.workflow.WorkflowPrintCache;
import ordermate.database.workflow.WorkflowSalesItemQuantity;
import ordermate.database.workflow.WorkflowTriggerLink;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.event.WorkflowEvent;

public class Workflow
extends PersistentObject
implements TriggerActivated,
Saveable {
    public static final Props Properties = new Props();
    private int sequence;
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private String label;
    private TriggerActivationStrategy triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
    private boolean prototype = false;
    private boolean done = false;
    private Date dateCreated;
    private Date accountClosed;
    private Reference<Account> account;
    private Reference<User> user;
    private Reference<Terminal> terminal;
    private Reference<Shift> shift;
    private Reference<TradingDay> tradingDay;
    private transient EventContext context;
    private transient List<SalesItemQuantity> handledQtys;
    private transient Set<PrinterGroup> handledGroups;
    private transient boolean rushed;
    private transient List<SalesItemQuantity> newItems;
    private transient WorkflowPrintCache printCache;
    private PersistentWriteableList<WorkflowEvent> events;
    private PersistentWriteableList<WorkflowActionSet> actionSets;
    private PersistentWriteableList<WorkflowTriggerLink> triggerLinks;
    private PersistentWriteableList<WorkflowSalesItemQuantity> salesItemQuantities;

    public Workflow() {
        this.account = this.createReference(Workflow.Properties.ACCOUNT);
        this.user = this.createReference(Workflow.Properties.USER);
        this.terminal = this.createReference(Workflow.Properties.TERMINAL);
        this.shift = this.createReference(Workflow.Properties.SHIFT);
        this.tradingDay = this.createReference(Workflow.Properties.TRADING_DAY);
        this.rushed = false;
        this.newItems = null;
        this.printCache = new WorkflowPrintCache(this);
        this.events = (PersistentWriteableList)this.createList(Workflow.Properties.EVENTS);
        this.actionSets = (PersistentWriteableList)this.createList(Workflow.Properties.ACTION_SETS);
        this.triggerLinks = (PersistentWriteableList)this.createList(Workflow.Properties.TRIGGER_LINKS);
        this.salesItemQuantities = (PersistentWriteableList)this.createList(Workflow.Properties.SALES_ITEM_QUANTITIES);
    }

    private Workflow(Workflow thePrototype, Account anAccount, EventContext context) {
        this.account = this.createReference(Workflow.Properties.ACCOUNT);
        this.user = this.createReference(Workflow.Properties.USER);
        this.terminal = this.createReference(Workflow.Properties.TERMINAL);
        this.shift = this.createReference(Workflow.Properties.SHIFT);
        this.tradingDay = this.createReference(Workflow.Properties.TRADING_DAY);
        this.rushed = false;
        this.newItems = null;
        this.printCache = new WorkflowPrintCache(this);
        this.events = (PersistentWriteableList)this.createList(Workflow.Properties.EVENTS);
        this.actionSets = (PersistentWriteableList)this.createList(Workflow.Properties.ACTION_SETS);
        this.triggerLinks = (PersistentWriteableList)this.createList(Workflow.Properties.TRIGGER_LINKS);
        this.salesItemQuantities = (PersistentWriteableList)this.createList(Workflow.Properties.SALES_ITEM_QUANTITIES);
        this.setAccount(anAccount);
        this.dateCreated = new Date();
        this.sequence = thePrototype.sequence;
        this.label = thePrototype.label;
        this.prototype = false;
        this.setUser(context.getUser());
        this.setTerminal(context.getTerminal());
        this.setShift(context.getShift());
        this.setTradingDay(context.getTradingDay());
    }

    public Workflow generateWorkflow(Account anAccount, EventContext eventContext) {
        if (!this.prototype) {
            throw new IllegalStateException("Can only create a workflow from a prototypical workflow");
        }
        if (anAccount == null) {
            throw new IllegalArgumentException("Cannot create a workflow without an account");
        }
        Workflow newFlow = new Workflow(this, anAccount, eventContext);
        for (WorkflowActionSet set : this.actionSets) {
            newFlow.addActionSet(set.generateActionSet(newFlow));
        }
        return newFlow;
    }

    public Workflow copyNoID(Account anAccount, EventContext eventContext) {
        if (anAccount == null) {
            throw new IllegalArgumentException("Cannot create a workflow without an account");
        }
        Workflow newFlow = new Workflow(this, anAccount, eventContext);
        for (WorkflowActionSet set : this.actionSets) {
            newFlow.addActionSet(set.copyNoID(this));
        }
        for (WorkflowEvent event : this.events) {
            newFlow.addEvent(event.copyNoID(this));
        }
        return newFlow;
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState value) {
        this.systemState = value;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    protected void setDateCreated(Date value) {
        this.dateCreated = value;
    }

    public Account getAccount() {
        return this.account.get();
    }

    protected void setAccount(Account theAccount) {
        this.account.set(theAccount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkflowEvent> getEvents() {
        PersistentWriteableList<WorkflowEvent> persistentWriteableList = this.events;
        synchronized (persistentWriteableList) {
            return new ArrayList<WorkflowEvent>(this.events);
        }
    }

    protected void setEvents(List<WorkflowEvent> value) {
        this.events = this.events.clone();
        this.events.set(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(WorkflowEvent event) {
        PersistentWriteableList<WorkflowEvent> persistentWriteableList = this.events;
        synchronized (persistentWriteableList) {
            this.events.add(event);
        }
    }

    public void addActionSet(WorkflowActionSet actionSet) {
        this.actionSets.add(actionSet);
    }

    public void removeActionSet(WorkflowActionSet actionSet) {
        this.actionSets.remove(actionSet);
    }

    public int compareTo(Object o) {
        if (o instanceof Sequenced) {
            return this.sequence - ((Sequenced)o).getSequence();
        }
        return 0;
    }

    @Override
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy strategy) {
        this.triggerActivationStrategy = strategy;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public void setPrototype(boolean value) {
        this.prototype = value;
    }

    @Override
    public boolean isActive(TriggerActivationContext theContext) {
        return SystemState.ACTIVE_STATE.equals(this.getSystemState()) && this.triggerActivationStrategy.isActive(this, theContext);
    }

    @Override
    public List<AbstractTrigger> getTriggers() {
        ArrayList<AbstractTrigger> triggers = new ArrayList<AbstractTrigger>();
        for (WorkflowTriggerLink link : this.triggerLinks) {
            triggers.add(link.getTrigger());
        }
        return triggers;
    }

    public void setTriggers(List<? extends AbstractTrigger> newTriggers) {
        HashSet<AbstractTrigger> removeTriggers = new HashSet<AbstractTrigger>();
        for (WorkflowTriggerLink workflowTriggerLink : this.triggerLinks) {
            removeTriggers.add(workflowTriggerLink.getTrigger());
        }
        for (AbstractTrigger abstractTrigger : newTriggers) {
            WorkflowTriggerLink alreadyHaveLink = this.findLink(abstractTrigger);
            if (alreadyHaveLink != null) {
                removeTriggers.remove(abstractTrigger);
                continue;
            }
            this.triggerLinks.add(new WorkflowTriggerLink(this, abstractTrigger));
        }
        for (AbstractTrigger abstractTrigger : removeTriggers) {
            WorkflowTriggerLink currentLink = this.findLink(abstractTrigger);
            if (currentLink == null) continue;
            this.triggerLinks.remove(currentLink);
        }
    }

    @Override
    public boolean removeTrigger(AbstractTrigger trigger) {
        WorkflowTriggerLink toRemove = this.findLink(trigger);
        if (toRemove != null) {
            this.triggerLinks.remove(toRemove);
            return true;
        }
        return false;
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger trigger) {
        WorkflowTriggerLink theLink = this.findLink(trigger);
        if (theLink == null) {
            theLink = new WorkflowTriggerLink(this, trigger);
            this.triggerLinks.add(theLink);
        }
        return theLink;
    }

    private WorkflowTriggerLink findLink(AbstractTrigger trigger) {
        WorkflowTriggerLink foundLink = null;
        for (WorkflowTriggerLink link : this.triggerLinks) {
            if (!trigger.equals(link.getTrigger())) continue;
            foundLink = link;
            break;
        }
        return foundLink;
    }

    protected List<WorkflowTriggerLink> getTriggerLinks() {
        return this.triggerLinks.getUnmodifiable();
    }

    protected void setTriggerLinks(List<WorkflowTriggerLink> values) {
        this.triggerLinks = this.triggerLinks.clone();
        this.triggerLinks.set(values);
    }

    public List<WorkflowActionSet> getActionSets() {
        return this.actionSets.getUnmodifiable();
    }

    protected void setActionSets(List<WorkflowActionSet> newSets) {
        this.actionSets = this.actionSets.clone();
        this.actionSets.set(newSets);
    }

    public User getUser() {
        return this.user.get();
    }

    protected void setUser(User value) {
        this.user.set(value);
    }

    public Terminal getTerminal() {
        return this.terminal.get();
    }

    protected void setTerminal(Terminal value) {
        this.terminal.set(value);
    }

    public Shift getShift() {
        return this.shift.get();
    }

    protected void setShift(Shift value) {
        this.shift.set(value);
    }

    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    protected void setTradingDay(TradingDay value) {
        this.tradingDay.set(value);
    }

    public boolean isDone() {
        return this.done;
    }

    protected void setDone(boolean value) {
        this.done = value;
    }

    public void markAsDone() {
        this.done = true;
    }

    public EventContext getContext() {
        if (this.context == null) {
            this.context = new EventContext(this.getTerminal(), this.getUser(), this.getTradingDay(), this.getShift());
        }
        return this.context;
    }

    protected List<WorkflowSalesItemQuantity> getSalesItemQuantities() {
        return this.salesItemQuantities.getUnmodifiable();
    }

    protected void setSalesItemQuantities(List<WorkflowSalesItemQuantity> qtys) {
        this.salesItemQuantities = this.salesItemQuantities.clone();
        this.salesItemQuantities.set(qtys);
        this.handledQtys = null;
    }

    public List<SalesItemQuantity> getHandledItemQuantities() {
        if (this.handledQtys == null) {
            this.handledQtys = new ArrayList<SalesItemQuantity>(this.salesItemQuantities.size());
            for (WorkflowSalesItemQuantity quantity : this.salesItemQuantities) {
                this.handledQtys.add(quantity.getSalesItemQuantity());
            }
        }
        return Collections.unmodifiableList(this.handledQtys);
    }

    public SalesQuantity getNumOfHandledQuantities() {
        List<SalesItemQuantity> handledItemQuantities = this.getHandledItemQuantities();
        SalesQuantity handled = SalesQuantity.ZERO;
        for (SalesItemQuantity handledQty : handledItemQuantities) {
            handled = handled.add(handledQty.getQuantity());
        }
        return handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PrinterGroup> getCurrentlyHandledPrinterGroups() {
        if (this.handledGroups == null) {
            Workflow workflow = this;
            synchronized (workflow) {
                this.handledGroups = new HashSet<PrinterGroup>();
                for (SalesItemQuantity qty : this.getHandledItemQuantities()) {
                    for (SalesItem item : qty.getSalesLineItem().getSalesItems()) {
                        for (SalesComponent comp : item.getComponentList()) {
                            this.handledGroups.add(comp.getInventoryItem().getPrinterGroup());
                        }
                    }
                }
            }
        }
        return Collections.unmodifiableSet(this.handledGroups);
    }

    public synchronized void clearPrinterGroupCache() {
        this.handledGroups = null;
    }

    void setHandledItemQuantities(List<SalesItemQuantity> qtys) {
        if (!this.getSalesItemQuantities().isEmpty()) {
            throw new IllegalStateException("Cannot set the handled quantities on a workflow more than once.");
        }
        this.handledQtys = new ArrayList<SalesItemQuantity>(qtys);
        for (SalesItemQuantity qty : this.handledQtys) {
            this.salesItemQuantities.add(new WorkflowSalesItemQuantity(this, qty));
        }
    }

    public Set<PrinterGroup> getPrototypeHandledPrinterGroups() {
        HashSet<PrinterGroup> groups = new HashSet<PrinterGroup>();
        for (WorkflowActionSet actionSet : this.getActionSets()) {
            groups.addAll(actionSet.findPrototypeHandledGroups());
        }
        return groups;
    }

    @Override
    public void prepareForSave(SaveContext saveContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        PersistenceManager.save(this);
        PersistentWriteableList<WorkflowEvent> persistentWriteableList = this.events;
        synchronized (persistentWriteableList) {
            this.events.saveChild();
        }
        this.actionSets.saveChild();
        this.triggerLinks.saveChild();
        this.salesItemQuantities.saveChild();
    }

    @Override
    public void delete() {
        this.events.deleteChild();
        this.actionSets.deleteChild();
        this.triggerLinks.deleteChild();
        this.salesItemQuantities.deleteChild();
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        return this.label == null ? "<No Label>" : this.label + " ID(" + this.getID() + ") isDone(" + this.isDone() + ") ";
    }

    void addQuantity(SalesItemQuantity newQty) {
        this.salesItemQuantities.add(new WorkflowSalesItemQuantity(this, newQty));
        if (this.handledQtys == null) {
            this.getHandledItemQuantities();
        }
        this.handledQtys.add(newQty);
    }

    public void initialise() {
        for (WorkflowActionSet newSets : this.getActionSets()) {
            newSets.initialise();
        }
    }

    public WorkflowPrintCache getPrintCache() {
        return this.printCache;
    }

    public Date getAccountClosed() {
        return this.accountClosed;
    }

    public void setAccountClosed(Date accountClosed) {
        this.accountClosed = accountClosed;
    }

    public boolean isAccountClosed() {
        return this.accountClosed != null;
    }

    public void setRushed(boolean value) {
        this.rushed = value;
    }

    public boolean isRushed() {
        return this.rushed;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<Account> ACCOUNT;
        public PropertiedObject.Property<Date> DATE_CREATED;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property PROTOTYPE;
        public PropertiedObject.Property DONE;
        public PropertiedObject.Property<WorkflowEvent> EVENTS;
        public PropertiedObject.Property<WorkflowActionSet> ACTION_SETS;
        public PropertiedObject.Property<WorkflowTriggerLink> TRIGGER_LINKS;
        public PropertiedObject.Property<WorkflowSalesItemQuantity> SALES_ITEM_QUANTITIES;
        public PersistentObject.DerivedProperty<AbstractTrigger> TRIGGERS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Workflow.class), "triggers");
        public PersistentObject.DerivedProperty<EventContext> CONTEXT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)Workflow.class), "context");
        public PropertiedObject.Property<TriggerActivationStrategy> TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<Date> ACCOUNT_CLOSED;
    }
}

