/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.hardware.physical.kts.KTSDocketData;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.sales.Account;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.WorkflowAccountScanResult;
import ordermate.database.workflow.WorkflowManager;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowActionType;
import ordermate.database.workflow.action.WorkflowKTSStateAction;
import ordermate.database.workflow.action.condition.WorkflowCondition;
import ordermate.database.workflow.action.condition.WorkflowConditionType;
import ordermate.database.workflow.action.condition.WorkflowScannedCondition;

public class WorkflowAccountScanRedemptionResult
extends WorkflowAccountScanResult {
    private String scanOrigin;
    private Map<String, Set<KTSDocketPrinter>> terminalToPrinterMap = new HashMap<String, Set<KTSDocketPrinter>>();
    private Set<KTSDocketPrinter> printersWithHeldItems = new HashSet<KTSDocketPrinter>();

    public WorkflowAccountScanRedemptionResult(String barcode, Account account, String scannedAt) {
        super(barcode, account);
        this.scanOrigin = scannedAt;
        this.determineRedemptionPrinters();
        this.findHeldDockets();
    }

    public boolean isAnythingRedeemed() {
        for (KTSDocketPrinter printer : this.printersWithHeldItems) {
            if (!this.isPrinterRedeemableFrom(printer, this.scanOrigin)) continue;
            return true;
        }
        return false;
    }

    public Set<KTSDocketPrinter> getPrintersRedeemableFrom() {
        HashSet<KTSDocketPrinter> redeemableFrom = new HashSet<KTSDocketPrinter>();
        if (this.terminalToPrinterMap.get(null) != null) {
            redeemableFrom.addAll((Collection)this.terminalToPrinterMap.get(null));
        }
        if (this.terminalToPrinterMap.get(this.scanOrigin) != null) {
            redeemableFrom.addAll((Collection<KTSDocketPrinter>)this.terminalToPrinterMap.get(this.scanOrigin));
        }
        return redeemableFrom;
    }

    public Set<KTSDocketPrinter> getPrintersWithHeldItems() {
        return Collections.unmodifiableSet(this.printersWithHeldItems);
    }

    public Set<KTSDocketPrinter> getPrintersRedeemedFrom() {
        HashSet<KTSDocketPrinter> redeemedFrom = new HashSet<KTSDocketPrinter>();
        redeemedFrom.addAll(this.printersWithHeldItems);
        redeemedFrom.retainAll(this.getPrintersRedeemableFrom());
        return redeemedFrom;
    }

    public Set<String> getAlternateRedemptionTerminals() {
        HashSet<String> terminals = new HashSet<String>();
        Set<String> allTerminals = this.terminalToPrinterMap.keySet();
        allTerminals.removeAll(Arrays.asList(null, this.scanOrigin));
        block0: for (String key : allTerminals) {
            for (KTSDocketPrinter printer : this.terminalToPrinterMap.get(key)) {
                if (!this.printersWithHeldItems.contains(printer)) continue;
                terminals.add(key);
                continue block0;
            }
        }
        return terminals;
    }

    private void findHeldDockets() {
        List<KTSDocketData> dockets = PersistenceManager.getObjectList(KTSDocketData.class, Query.select(KTSDocketData.class).equals(KTSDocketData.Properties.SALES_ACCOUNT, this.getAccount()).toString());
        for (KTSDocketData docket : dockets) {
            if (!KTSDocketState.Hold.equals((Object)docket.getState())) continue;
            this.printersWithHeldItems.add(docket.getPrinter());
        }
    }

    private void determineRedemptionPrinters() {
        List<Workflow> workflows = WorkflowManager.getInstance().getWorkflowsHandlingAccount(this.getAccount());
        for (Workflow workflow : workflows) {
            for (WorkflowActionSet actionSet : workflow.getActionSets()) {
                if (actionSet.isCompleted()) continue;
                ArrayList<String> potentialScanTerminals = new ArrayList<String>();
                for (WorkflowScannedCondition condition : this.getScanConditions(actionSet)) {
                    if (condition.getScannedAt() == null) {
                        potentialScanTerminals.clear();
                        break;
                    }
                    potentialScanTerminals.add(condition.getScannedAt());
                }
                for (WorkflowKTSStateAction action : this.getStateActions(actionSet)) {
                    if (potentialScanTerminals.isEmpty()) {
                        this.addRedemptionAction(null, action);
                        continue;
                    }
                    for (String scanTerminal : potentialScanTerminals) {
                        this.addRedemptionAction(scanTerminal, action);
                    }
                }
            }
        }
    }

    private List<WorkflowScannedCondition> getScanConditions(WorkflowActionSet actionSet) {
        ArrayList<WorkflowScannedCondition> conditions = new ArrayList<WorkflowScannedCondition>();
        for (WorkflowCondition condition : actionSet.getConditions()) {
            if (!WorkflowConditionType.Scanned.equals((Object)condition.getConditionType())) continue;
            conditions.add((WorkflowScannedCondition)condition);
        }
        return conditions;
    }

    private List<WorkflowKTSStateAction> getStateActions(WorkflowActionSet actionSet) {
        ArrayList<WorkflowKTSStateAction> actions = new ArrayList<WorkflowKTSStateAction>();
        for (WorkflowAction action : actionSet.getActions()) {
            if (!WorkflowActionType.KTSState.equals((Object)action.getActionType())) continue;
            actions.add((WorkflowKTSStateAction)action);
        }
        return actions;
    }

    private void addRedemptionAction(String scannedAt, WorkflowKTSStateAction stateAction) {
        if (!this.terminalToPrinterMap.containsKey(scannedAt)) {
            this.terminalToPrinterMap.put(scannedAt, new HashSet());
        }
        Set<KTSDocketPrinter> redemptionPrinters = this.terminalToPrinterMap.get(scannedAt);
        if (stateAction.getKtsPrinter() == null) {
            redemptionPrinters.addAll(PersistenceManager.getObjectList(KTSDocketPrinter.class, Query.select(KTSDocketPrinter.class).active(KTSDocketPrinter.class).toString()));
        } else {
            redemptionPrinters.add(stateAction.getKtsPrinter());
        }
    }

    private boolean isPrinterRedeemableFrom(KTSDocketPrinter printer, String scannedAt) {
        Set<KTSDocketPrinter> printers = this.terminalToPrinterMap.get(null);
        if (printers != null && printers.contains(printer)) {
            return true;
        }
        printers = this.terminalToPrinterMap.get(scannedAt);
        return printers != null && printers.contains(printer);
    }
}

