/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow;

import au.com.ordermate.persistence.PersistenceManager;
import ordermate.OrderMate;
import ordermate.database.integration.BarcodePrefix;
import ordermate.database.misc.BarcodeUtils;
import ordermate.database.sales.Account;
import ordermate.database.workflow.WorkflowAccountScanRedemptionResult;
import ordermate.database.workflow.WorkflowManager;

class WorkflowBarcodeHandler {
    WorkflowBarcodeHandler() {
    }

    public WorkflowAccountScanRedemptionResult handleBarcode(String barcodeSwiped, String whoFrom) {
        WorkflowAccountScanRedemptionResult result = new WorkflowAccountScanRedemptionResult(barcodeSwiped, null, whoFrom);
        String strippedBarcode = BarcodeUtils.stripBarcodeDelimiter(barcodeSwiped);
        BarcodePrefix internalPrefix = BarcodeUtils.getInternalPrefix(strippedBarcode);
        if (internalPrefix != null && BarcodeUtils.BarcodePrefixGroup.Account.name().equals(internalPrefix.getName())) {
            String idString = strippedBarcode.substring(internalPrefix.getPrefix().length(), strippedBarcode.length() - 1);
            try {
                Long value = Long.valueOf(idString);
                OrderMate.LOG.info("Got barcoded account id:" + value.toString());
                Account account = PersistenceManager.getByID(value, Account.class);
                if (account != null) {
                    this.handleAccountScanned(account, whoFrom);
                    return new WorkflowAccountScanRedemptionResult(barcodeSwiped, account, whoFrom);
                }
                OrderMate.LOG.warn("Account scanned of ID " + value + " that is not within the database");
            }
            catch (Exception x) {
                OrderMate.LOG.error("Cannot process barcode for account " + barcodeSwiped);
            }
        }
        return result;
    }

    private void handleAccountScanned(Account theAccount, String whoFrom) {
        OrderMate.LOG.info("Account Scanned " + theAccount + " from " + whoFrom);
        WorkflowManager.getInstance().accountScanned(theAccount, whoFrom);
    }
}

