/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowActionType;
import ordermate.database.workflow.action.WorkflowPrintAction;

public class WorkflowHelper {
    private List<SalesItemQuantity> newQtys;
    private Workflow workflow;

    public WorkflowHelper(Workflow flow) {
        this.workflow = flow;
    }

    void absorbQuantity(SalesItemQuantity qty) {
        this.workflow.addQuantity(qty);
        if (this.newQtys == null) {
            this.newQtys = new ArrayList<SalesItemQuantity>();
        }
        this.newQtys.add(qty);
    }

    void printOutAbsorbedItems(boolean doMergeNonCompletedActions) {
        this.printOutAbsorbedItems(doMergeNonCompletedActions, this.workflow);
    }

    void printOutAbsorbedItems(boolean doMergeNonCompletedActions, Workflow workflowToAddTo) {
        if (this.newQtys != null) {
            if (workflowToAddTo == null) {
                workflowToAddTo = this.workflow;
            }
            HashSet<WorkflowPrintAction> newActions = new HashSet<WorkflowPrintAction>();
            for (WorkflowActionSet set : workflowToAddTo.getActionSets()) {
                for (WorkflowAction action : set.getActions()) {
                    if (!WorkflowActionType.Print.equals((Object)action.getActionType()) || ((WorkflowPrintAction)action).isChild()) continue;
                    if (set.isCompleted()) {
                        WorkflowPrintAction printAction = new WorkflowPrintAction((WorkflowPrintAction)action, this.newQtys);
                        if (printAction.getActionQtys().isEmpty()) continue;
                        newActions.add(printAction);
                        continue;
                    }
                    if (!doMergeNonCompletedActions) continue;
                    ((WorkflowPrintAction)action).initialiseQuantities(this.newQtys);
                }
            }
            for (WorkflowPrintAction action : newActions) {
                OrderMate.LOG.info("Printing out deleted / transferred items to:" + action.getVirtualPrinter());
                action.getActionSet().addAction(action);
                action.start(workflowToAddTo.getAccount(), this.workflow.getContext());
            }
            workflowToAddTo.save();
        }
    }

    public List<SalesItemQuantity> getNewItemsList() {
        return this.newQtys;
    }
}

