/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.synchronisation.PersistenceListener;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.hardware.physical.kts.KTSDocketData;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.WorkflowAccountScanRedemptionResult;
import ordermate.database.workflow.WorkflowBarcodeHandler;
import ordermate.database.workflow.WorkflowProcess;
import ordermate.database.workflow.WorkflowTriggerLink;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowActionType;
import ordermate.database.workflow.action.WorkflowPrintAction;
import ordermate.database.workflow.action.condition.WorkflowCondition;
import ordermate.database.workflow.event.WorkflowEvent;
import ordermate.database.workflow.event.WorkflowKTSEvent;
import ordermate.database.workflow.event.WorkflowPrintEvent;
import ordermate.database.workflow.event.WorkflowScannedEvent;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.PrepPrintJob;
import ordermate.docketprocessor.PrintJobInterceptor;
import ordermate.docketprocessor.WorkflowPrepPrintJob;

public class WorkflowManager
implements PrintJobInterceptor,
PersistenceListener {
    private static final WorkflowManager instance = new WorkflowManager();
    private List<Workflow> prototypes;
    private final Map<Account, List<Workflow>> accountWorkflowMap = new HashMap<Account, List<Workflow>>();
    private Set<Workflow> servicedWorkflows = new HashSet<Workflow>();
    private Timer timer;
    private static String INVALID_WORKFLOW_NO_ACCOUNT = "Workflow has no Account";
    private static int CUTOFF_DAYS = -2;
    private static int MINUTES_TO_DROP = 1;

    public static WorkflowManager getInstance() {
        return instance;
    }

    private WorkflowManager() {
    }

    List<Workflow> getPrototypes() {
        return this.prototypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Workflow> getWorkflowsHandlingAccount(Account account) {
        Map<Account, List<Workflow>> map = this.accountWorkflowMap;
        synchronized (map) {
            List<Workflow> workflowList = this.accountWorkflowMap.get(account);
            if (workflowList != null) {
                List<Workflow> list = workflowList;
                synchronized (list) {
                    return new ArrayList<Workflow>(workflowList);
                }
            }
            return Collections.emptyList();
        }
    }

    public void updateWorkflowTriggers() {
        for (Workflow workflow : this.prototypes) {
            for (WorkflowTriggerLink link : workflow.getTriggerLinks()) {
                link.collapseTrigger();
            }
        }
    }

    public void restartManager() {
        OrderMate.LOG.info("Restarting workflows");
        if (this.timer != null) {
            this.timer.cancel();
        }
        try {
            long sleepTime = SystemProperty.getInstance().getWorkflowFrequency() * 2L;
            OrderMate.LOG.info("Waiting " + sleepTime + " millis for last workflow cycle to finish");
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.initialiseManager();
    }

    public void initialiseManager() {
        this.initialiseManager(SystemProperty.getInstance().getWorkflowFrequency());
    }

    void initialiseManager(long delay) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                WorkflowManager.this.serviceAllWorkflows();
            }
        }, delay, delay);
        OrderMate.LOG.info("Initialising workflows");
        this.accountWorkflowMap.clear();
        this.prototypes = new ArrayList<Workflow>();
        this.retrieveWorkflows();
    }

    private void retrieveWorkflows() {
        ObjectQuery query = Query.select(Workflow.class).equals(Workflow.Properties.PROTOTYPE, "0").orderBy(Workflow.Properties.DATE_CREATED);
        List<Workflow> activeFlows = PersistenceManager.getObjectList(Workflow.class, query.toString());
        Calendar cal = Calendar.getInstance();
        cal.add(5, CUTOFF_DAYS);
        Date todaysDate = cal.getTime();
        int resuming = 0;
        int deleting = 0;
        for (Workflow flow : activeFlows) {
            if (this.isStaleWorkflow(flow, todaysDate)) {
                OrderMate.LOG.warn("Stale workflow found - deleting from database Workflow: " + flow + "\n Account:" + flow.getAccount());
                flow.delete();
                ++deleting;
                continue;
            }
            this.addWorkflow(flow);
            ++resuming;
        }
        OrderMate.LOG.info("Deleted " + deleting + " stale workflows, resuming " + resuming + " current workflows");
        query = Query.select(Workflow.class).equals(Workflow.Properties.PROTOTYPE, "1").orderBy(Workflow.Properties.SEQUENCE);
        List<Workflow> prototypeFlows = PersistenceManager.getObjectList(Workflow.class, query.toString());
        this.prototypes.addAll(prototypeFlows);
        OrderMate.LOG.info("Found " + this.prototypes.size() + " prototypical workflows");
    }

    private boolean isStaleWorkflow(Workflow flow, Date cutoffDate) {
        if (flow.getAccount() == null) {
            return true;
        }
        return flow.getAccount().getAccountState().equals((Object)AccountState.CLOSED) && flow.getDateCreated().before(cutoffDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractPrintJob interceptPrintJob(AbstractPrintJob job) {
        if (this.prototypes == null || this.prototypes.isEmpty()) {
            return job;
        }
        if (!(job instanceof PrepPrintJob) || job instanceof WorkflowPrepPrintJob) {
            return job;
        }
        PrepPrintJob prepJob = (PrepPrintJob)job;
        TriggerActivationContext context = prepJob.createTriggerContext();
        Account account = context.getAccount();
        Workflow workflow = this.createWorkflow(context);
        if (workflow != null) {
            workflow.setRushed(prepJob.isRushed());
            ArrayList<Workflow> workflows = new ArrayList<Workflow>();
            workflows.add(workflow);
            List<Workflow> workflowList = this.getWorkflowsHandlingAccount(account);
            Object object = this.servicedWorkflows;
            synchronized (object) {
                this.servicedWorkflows.addAll(workflowList);
            }
            try {
                prepJob = WorkflowProcess.process(job, workflowList, workflows);
            }
            finally {
                object = this.servicedWorkflows;
                synchronized (object) {
                    this.servicedWorkflows.removeAll(workflowList);
                }
            }
            for (Workflow newWorkflow : workflows) {
                if (newWorkflow.getHandledItemQuantities().isEmpty()) {
                    OrderMate.LOG.info("Workflow dropped: Handles no items for the account: " + workflow.getAccount());
                    continue;
                }
                if (SalesQuantity.ZERO.greaterThanOrEquals(newWorkflow.getNumOfHandledQuantities())) {
                    OrderMate.LOG.info("Workflow dropped: Handles no items for the account: " + workflow.getAccount());
                    continue;
                }
                OrderMate.LOG.info("Creating new Workflow for account:" + newWorkflow.getLabel());
                if (newWorkflow.equals(workflow)) {
                    newWorkflow.initialise();
                }
                newWorkflow.save();
                this.addWorkflow(newWorkflow);
                if (!newWorkflow.equals(workflow)) continue;
                this.serviceWorkflow(newWorkflow);
            }
        }
        return prepJob;
    }

    private Workflow createWorkflow(TriggerActivationContext context) {
        Workflow newFlow = null;
        for (Workflow workflow : this.prototypes) {
            if (!workflow.isActive(context)) continue;
            newFlow = workflow.generateWorkflow(context.getAccount(), context);
            break;
        }
        return newFlow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorkflow(Workflow workflow) {
        Account account = workflow.getAccount();
        Map<Account, List<Workflow>> map = this.accountWorkflowMap;
        synchronized (map) {
            if (!this.accountWorkflowMap.containsKey(account)) {
                this.accountWorkflowMap.put(account, new ArrayList());
            }
            this.accountWorkflowMap.get(account).add(workflow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceAllWorkflows() {
        HashSet<List<Workflow>> toService = new HashSet<List<Workflow>>();
        Map<Account, List<Workflow>> map = this.accountWorkflowMap;
        synchronized (map) {
            toService.addAll(this.accountWorkflowMap.values());
        }
        for (List list : toService) {
            ArrayList copy = new ArrayList(list.size());
            List list2 = list;
            synchronized (list2) {
                copy.addAll(list);
            }
            for (Workflow workflow : copy) {
                this.serviceWorkflow(workflow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceWorkflow(Workflow workflow) {
        Object account;
        Set<Workflow> set = this.servicedWorkflows;
        synchronized (set) {
            if (this.servicedWorkflows.contains(workflow)) {
                return;
            }
            this.servicedWorkflows.add(workflow);
        }
        try {
            if (workflow.getAccount() != null) {
                if (!this.isWorkflowDone(workflow)) {
                    this.serviceSets(workflow);
                    workflow.getPrintCache().doPrint();
                } else {
                    account = workflow.getAccount();
                    if (!((Account)account).isOpen()) {
                        if (!workflow.isAccountClosed()) {
                            this.markAccountClosed(workflow);
                        } else if (this.shouldDropWorkflow(workflow)) {
                            this.dropWorkflow(workflow);
                        }
                    }
                }
            } else {
                this.dropInvalidWorkflow(workflow, INVALID_WORKFLOW_NO_ACCOUNT);
            }
        }
        catch (Throwable e) {
            OrderMate.LOG.error("Workflow: " + workflow.getLabel() + " " + workflow.getID(), e);
            this.checkValidAndDropIfRequired(workflow);
        }
        finally {
            account = this.servicedWorkflows;
            synchronized (account) {
                this.servicedWorkflows.remove(workflow);
            }
        }
    }

    private void checkValidAndDropIfRequired(Workflow workflow) {
        if (workflow.getAccount() == null || workflow.getAccount().getID() == null || PersistenceManager.getByID(workflow.getAccount().getID(), Account.class) == null) {
            this.dropInvalidWorkflow(workflow, INVALID_WORKFLOW_NO_ACCOUNT);
        }
    }

    private void dropInvalidWorkflow(Workflow workflow, String reason) {
        OrderMate.LOG.info("Workflow: " + workflow.getLabel() + " " + workflow.getID() + " dropped, " + reason);
        workflow.setDone(true);
        this.markAccountClosed(workflow);
        this.dropWorkflow(workflow);
    }

    private void markAccountClosed(Workflow workflow) {
        workflow.setAccountClosed(Calendar.getInstance().getTime());
        workflow.save();
        if (workflow.getAccount() != null) {
            OrderMate.LOG.info("Marking workflow account_closed: " + workflow.getLabel() + " " + workflow.getID() + ", Account: " + workflow.getAccount().getLabel());
        } else {
            OrderMate.LOG.info("Marking workflow account_closed: " + workflow.getLabel() + " " + workflow.getID() + ", Account: No Account");
        }
    }

    private boolean shouldDropWorkflow(Workflow workflow) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(workflow.getAccountClosed());
        cal.add(12, MINUTES_TO_DROP);
        return cal.before(Calendar.getInstance());
    }

    private void serviceSets(Workflow workflow) {
        for (WorkflowActionSet set : workflow.getActionSets()) {
            if (set.isCompleted()) continue;
            boolean conditionsMet = true;
            for (WorkflowCondition condition : set.getConditions()) {
                conditionsMet = conditionsMet && condition.isMet();
            }
            if (!conditionsMet) continue;
            set.start();
        }
    }

    private boolean isWorkflowDone(Workflow workflow) {
        if (workflow.isDone()) {
            return true;
        }
        boolean done = true;
        if (workflow.isAccountClosed()) {
            OrderMate.LOG.info("Account(" + workflow.getAccount() + ") is closed. Mark the related workflow ID(" + workflow.getID() + ") as done.");
            done = true;
        } else if (SalesQuantity.ZERO.greaterThanOrEquals(workflow.getNumOfHandledQuantities())) {
            OrderMate.LOG.info("Account(" + workflow.getAccount() + ") has no quantity items. Mark the related workflow ID(" + workflow.getID() + ") as done.");
            done = true;
        } else {
            for (WorkflowActionSet actionSet : workflow.getActionSets()) {
                if (actionSet.isOptional() || actionSet.isCompleted()) continue;
                done = false;
                break;
            }
        }
        if (done) {
            this.serviceSets(workflow);
            workflow.markAsDone();
            workflow.save();
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropWorkflow(Workflow workflow) {
        OrderMate.LOG.info("Workflow completed, dropping workflow:" + workflow + "with account ID=" + workflow.getAccount().getID());
        List<Workflow> workflowList = null;
        Map<Account, List<Workflow>> map = this.accountWorkflowMap;
        synchronized (map) {
            List<Workflow> list = workflowList = this.accountWorkflowMap.get(workflow.getAccount());
            synchronized (list) {
                workflowList.remove(workflow);
                if (workflowList.isEmpty()) {
                    this.accountWorkflowMap.remove(workflow.getAccount());
                }
            }
        }
        workflow.delete();
    }

    public void docketFinishedPrinting(AbstractDocket docket) {
        if (!docket.getClassType().equals(AbstractDocket.DocketClassType.SALES_ACCOUNT)) {
            return;
        }
        SalesAccountDocket salesAccDocket = (SalesAccountDocket)docket;
        Account salesAcc = salesAccDocket.getSalesAccount();
        VirtualPrinter vPrinter = salesAccDocket.getOriginalPrinter();
        for (WorkflowAction workflowAction : this.getAllActionsForAccount(salesAcc)) {
            if (!(workflowAction instanceof WorkflowPrintAction)) continue;
            WorkflowPrintAction wfPrintAction = (WorkflowPrintAction)workflowAction;
            this.docketPrinted(vPrinter, salesAccDocket.getLastPrinter(), salesAcc, wfPrintAction.getPrinterGroups());
        }
    }

    protected List<WorkflowAction> getAllActionsForAccount(Account salesAcc) {
        List<Workflow> relatedWorkflows = this.getWorkflowsHandlingAccount(salesAcc);
        ArrayList<WorkflowAction> workflowActions = new ArrayList<WorkflowAction>();
        for (Workflow workflow : relatedWorkflows) {
            if (workflow.isDone()) continue;
            List<WorkflowActionSet> workflowActionSets = workflow.getActionSets();
            for (WorkflowActionSet was : workflowActionSets) {
                workflowActions.addAll(was.getActions());
            }
        }
        return workflowActions;
    }

    protected void docketPrinted(VirtualPrinter vPrinter, PhysicalPrintDevice printDevice, Account account, Set<PrinterGroup> groups) {
        List<Workflow> workflowList = this.getWorkflowsHandlingAccount(account);
        if (workflowList.isEmpty()) {
            return;
        }
        HashSet<PrinterGroup> printedGroups = new HashSet<PrinterGroup>();
        if (groups != null) {
            printedGroups.addAll(groups);
        } else {
            printedGroups.addAll(PrinterGroup.getPrinterGroups());
        }
        for (Workflow workflow : workflowList) {
            if (workflow.isDone()) continue;
            for (PrinterGroup group : printedGroups) {
                if (this.hasPrintEventForGroup(workflow, group, vPrinter)) continue;
                OrderMate.LOG.info("Printed event:" + group.getLabel() + " printed to " + vPrinter.getLabel());
                workflow.addEvent(new WorkflowPrintEvent(workflow, printDevice, vPrinter, group));
            }
            workflow.save();
        }
    }

    private boolean hasPrintEventForGroup(Workflow workflow, PrinterGroup group, VirtualPrinter virtualPrinter) {
        List<WorkflowEvent> events = workflow.getEvents();
        for (WorkflowEvent event : events) {
            WorkflowPrintEvent printEvent;
            if (!(event instanceof WorkflowPrintEvent) || !group.equals((printEvent = (WorkflowPrintEvent)event).getPrinterGroup()) || !virtualPrinter.equals(printEvent.getVirtualPrinter())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void objectChanged(PersistentObjectSnapshot snapshot, PersistenceOperation operation) {
        if (KTSDocketData.class.equals(snapshot.getObjectType())) {
            this.ktsDocketChanged(PersistenceManager.getByID(snapshot.getID(), KTSDocketData.class));
        } else if (Account.class.isAssignableFrom(snapshot.getObjectType())) {
            this.accountChanged(snapshot);
        }
    }

    void ktsDocketChanged(KTSDocketData data) {
        if (data == null) {
            return;
        }
        SalesAccountDocket docket = data.getSalesAccountDocket();
        if (docket == null) {
            return;
        }
        List<Workflow> workflowsList = this.getWorkflowsHandlingAccount(docket.getSalesAccount());
        for (Workflow workflow : workflowsList) {
            this.addKTSEventIfRequired(workflow, data);
        }
        if (docket.getTargetAccount() != null) {
            List<Workflow> targetAccWorkflowsList = this.getWorkflowsHandlingAccount(docket.getTargetAccount());
            for (Workflow workflow : targetAccWorkflowsList) {
                this.addKTSEventIfRequired(workflow, data);
            }
        }
    }

    private void addKTSEventIfRequired(Workflow workflow, KTSDocketData data) {
        SalesAccountDocket docket = data.getSalesAccountDocket();
        for (WorkflowActionSet actionSet : workflow.getActionSets()) {
            for (WorkflowAction action : actionSet.getActions()) {
                if (!action.getActionType().equals((Object)WorkflowActionType.Print) || ((WorkflowPrintAction)action).getDocket() == null || !((WorkflowPrintAction)action).getDocket().equals(docket)) continue;
                WorkflowKTSEvent event = new WorkflowKTSEvent(workflow, data.getPrinter(), data.getState());
                OrderMate.LOG.info("KTS Docket Changed ID: " + docket.getID() + ", adding event to workflow ID: " + workflow.getID());
                workflow.addEvent(event);
                workflow.save();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accountChanged(PersistentObjectSnapshot snapshot) {
        AccountState accountState = snapshot.get(Account.Properties.ACCOUNT_STATE);
        if (!AccountState.OPEN.equals((Object)accountState)) {
            Account account = PersistenceManager.getByID((Long)snapshot.get(Account.Properties.ID), Account.class);
            Map<Account, List<Workflow>> map = this.accountWorkflowMap;
            synchronized (map) {
                if (this.accountWorkflowMap.containsKey(account)) {
                    List<Workflow> flowList;
                    List<Workflow> list = flowList = this.accountWorkflowMap.get(account);
                    synchronized (list) {
                        for (Workflow flow : flowList) {
                            flow.setAccount(account);
                        }
                    }
                    this.accountWorkflowMap.put(account, flowList);
                }
            }
        }
    }

    public void accountScanned(Account theAccount, String fromWhere) {
        List<Workflow> workflows = this.getWorkflowsHandlingAccount(theAccount);
        for (Workflow workflow : workflows) {
            WorkflowScannedEvent event = new WorkflowScannedEvent(workflow, fromWhere);
            workflow.addEvent(event);
        }
    }

    Timer getTimer() {
        return this.timer;
    }

    public WorkflowAccountScanRedemptionResult gotBarcode(String barcode, String scannedAt) {
        WorkflowBarcodeHandler handler = new WorkflowBarcodeHandler();
        return handler.handleBarcode(barcode, scannedAt);
    }
}

