/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow;

import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.workflow.QuantitiesToPrint;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.WorkflowSalesItemQuantity;
import ordermate.database.workflow.action.WorkflowPrintAction;
import ordermate.database.workflow.event.WorkflowEvent;
import ordermate.database.workflow.event.WorkflowEventType;
import ordermate.database.workflow.event.WorkflowPrintEvent;
import ordermate.docketprocessor.DocketProcessor;

public class WorkflowPrintCache {
    private Workflow workflow;
    private Map<VirtualPrinter, Set<QuantitiesToPrint>> printItems = new HashMap<VirtualPrinter, Set<QuantitiesToPrint>>();
    private EventContext context;

    WorkflowPrintCache(Workflow theWorkflow) {
        this.workflow = theWorkflow;
    }

    public void cacheItemsToPrint(VirtualPrinter printer, List<SalesItemQuantity> qtys, WorkflowPrintAction action) {
        if (!this.printItems.containsKey(printer)) {
            this.printItems.put(printer, new HashSet());
        }
        QuantitiesToPrint newQtysToPrint = new QuantitiesToPrint();
        newQtysToPrint.addPrintAction(action, qtys);
        this.printItems.get(printer).add(newQtysToPrint);
    }

    void doPrint() {
        this.doPrint(this.workflow.getAccount(), null);
    }

    void doPrint(Account srcAccount, Account trgAccount) {
        this.context = this.workflow.getContext();
        if (this.printItems.size() == 0) {
            return;
        }
        HashSet<VirtualPrinter> completed = new HashSet<VirtualPrinter>();
        HashSet<PrinterGroup> groups = new HashSet<PrinterGroup>();
        HashSet<WorkflowPrintAction> actions = new HashSet<WorkflowPrintAction>();
        for (VirtualPrinter printer : this.printItems.keySet()) {
            LinkedHashSet<SalesItemQuantity> printThese = new LinkedHashSet<SalesItemQuantity>();
            for (QuantitiesToPrint nextQtys : this.printItems.get(printer)) {
                printThese.addAll(nextQtys.getQuantitiesToPrint());
                groups.addAll(nextQtys.getPrinterGroups());
                actions.addAll(nextQtys.getPrintActions());
            }
            if (!this.printToPrinter(srcAccount, printer, new ArrayList<SalesItemQuantity>(printThese), new HashSet<WorkflowPrintAction>(actions), groups, trgAccount)) continue;
            completed.add(printer);
        }
        for (VirtualPrinter printer : completed) {
            this.printItems.remove(printer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean printToPrinter(Account account, VirtualPrinter printer, List<SalesItemQuantity> qtys, Set<WorkflowPrintAction> actions, Set<PrinterGroup> groups, Account targetAccount) {
        boolean shouldLock;
        Account copyAccount = (Account)PersistenceManager.reacquire(account);
        boolean bl = shouldLock = !copyAccount.isLocked();
        if (shouldLock && !copyAccount.lock(this.context.getUser())) {
            OrderMate.LOG.info("Could not re-lock an account, aborting print.");
            return false;
        }
        boolean bool1 = this.itemsHavePrinted(this.workflow.getSalesItemQuantities());
        boolean bool2 = this.checkForPrintedSummaryEvents(this.workflow, printer);
        boolean hasPrintedSummary = bool1 && bool2;
        boolean success = false;
        try {
            for (SalesLineItem lineItem : copyAccount.getAllItems()) {
                for (SalesItem nextItem : lineItem.getSalesItems()) {
                    block7: for (SalesItemQuantity reacquiredQuantity : nextItem.getSalesItemQuantities()) {
                        for (SalesItemQuantity qty : qtys) {
                            if (!reacquiredQuantity.getID().equals(qty.getID())) continue;
                            int index = qtys.indexOf(qty);
                            qtys.set(index, reacquiredQuantity);
                            continue block7;
                        }
                    }
                }
            }
            for (SalesItemQuantity itemQty : qtys) {
                if (targetAccount != null) {
                    itemQty.getSalesLineItem().markPrinted();
                    itemQty.getSalesLineItem().saveChild();
                }
                itemQty.markAsNotPrinted();
            }
            HashMap<VirtualPrinter, Set<QuantitiesToPrint>> notifyPrinterQtys = new HashMap<VirtualPrinter, Set<QuantitiesToPrint>>();
            for (VirtualPrinter notifyPrinter : printer.getNotifyPrinters()) {
                Set<QuantitiesToPrint> quantitiesToPrint = this.printItems.get(notifyPrinter);
                notifyPrinterQtys.put(notifyPrinter, quantitiesToPrint);
            }
            DocketProcessor.printWorkflowPrepDocket(account, this.context, printer, actions, qtys, groups, notifyPrinterQtys, targetAccount, !hasPrintedSummary, this.workflow.isRushed());
            for (WorkflowSalesItemQuantity flowSalesItemQty : this.workflow.getSalesItemQuantities()) {
                flowSalesItemQty.markAsPrinted();
            }
            success = true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Couldn't print to selected printer:", (Throwable)ex);
            success = false;
        }
        finally {
            if (shouldLock) {
                copyAccount.unlock();
            }
        }
        return success;
    }

    protected boolean checkForPrintedSummaryEvents(Workflow work, VirtualPrinter printer) {
        List<WorkflowEvent> workflowEvents = work.getEvents();
        boolean foundEventWithPrinter = false;
        for (WorkflowEvent e : workflowEvents) {
            WorkflowPrintEvent wpEvent;
            if (!e.getEventType().equals((Object)WorkflowEventType.Print) || !(wpEvent = (WorkflowPrintEvent)e).getVirtualPrinter().equals(printer)) continue;
            foundEventWithPrinter = true;
            break;
        }
        return foundEventWithPrinter;
    }

    private boolean itemsHavePrinted(List<WorkflowSalesItemQuantity> qtys) {
        boolean allPrinted = true;
        for (WorkflowSalesItemQuantity q : qtys) {
            allPrinted = allPrinted && q.getPrintState().equals("PRINTED");
        }
        return allPrinted;
    }
}

