/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow;

import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.course.CoursePrintStatus;
import ordermate.database.course.SalesAccountCourse;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.workflow.NormalWorkflowProcess;
import ordermate.database.workflow.TransferWorkflowProcess;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.WorkflowHelper;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionSalesItemQuantity;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowPrintAction;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.PrepPrintJob;
import ordermate.docketprocessor.TransferPrepPrintJob;
import ordermate.docketprocessor.WorkflowPrepPrintJob;

abstract class WorkflowProcess {
    private List<Workflow> workflowsHandlingAccount;
    protected PrepPrintJob prepJob;
    private TriggerActivationContext activationContext;
    private Account srcAccount;
    private List<Workflow> newWorkflows;

    WorkflowProcess() {
    }

    protected PrepPrintJob doWork(AbstractPrintJob job, List<Workflow> workflows, List<Workflow> newWorkflowList) {
        this.prepJob = (PrepPrintJob)job;
        this.activationContext = this.prepJob.createTriggerContext();
        this.srcAccount = this.activationContext.getAccount();
        this.workflowsHandlingAccount = workflows;
        this.newWorkflows = newWorkflowList;
        for (Workflow existing : this.workflowsHandlingAccount) {
            existing.clearPrinterGroupCache();
        }
        List<SalesItemQuantity> normalQuantities = this.determineHandledQuantities(this.getOriginalNewWorkflow(), this.srcAccount, this.workflowsHandlingAccount);
        return this.printDocketForQuantites(normalQuantities);
    }

    protected Workflow getOriginalNewWorkflow() {
        return this.newWorkflows.get(0);
    }

    protected Workflow getNewestWorkflow() {
        return this.newWorkflows.get(this.newWorkflows.size() - 1);
    }

    private WorkflowPrepPrintJob printDocketForQuantites(List<SalesItemQuantity> normalQuantities) {
        if (!normalQuantities.isEmpty()) {
            return this.createDocketForNormalQuantities(this.srcAccount, this.activationContext, normalQuantities, this.getOriginalNewWorkflow());
        }
        return null;
    }

    protected void handleChangedQuantity(SalesItemQuantity qty, List<SalesItemQuantity> qtys, List<Workflow> workflows, Map<Workflow, WorkflowHelper> helpers) {
        SalesLineItem item = qty.getSalesLineItem();
        for (Workflow workflow : workflows) {
            SalesQuantity handled = SalesQuantity.ZERO;
            boolean isFound = false;
            List<SalesItemQuantity> handledQtys = workflow.getHandledItemQuantities();
            for (SalesItemQuantity handledQty : handledQtys) {
                if (!handledQty.getSalesLineItem().equals(item)) continue;
                handled = handled.add(handledQty.getQuantity());
                isFound = true;
            }
            if (!isFound) {
                for (SalesItemQuantity handledQty : handledQtys) {
                    if (!handledQty.getSalesLineItem().isEquivalentTo(item)) continue;
                    handled = handled.add(handledQty.getQuantity());
                }
            }
            if (!handled.greaterThan(SalesQuantity.ZERO)) continue;
            qtys.remove(qty);
            WorkflowHelper helper = helpers.get(workflow);
            if (helper == null) {
                helper = new WorkflowHelper(workflow);
                helpers.put(workflow, helper);
            }
            helper.absorbQuantity(qty);
            return;
        }
    }

    protected abstract void handleAbsorbedItems(Map<Workflow, WorkflowHelper> var1);

    protected void getNormalAndHandledQtys(Workflow newWorkflow, Account accountItemsBelongTo, List<SalesItemQuantity> qtys, List<SalesItemQuantity> normalQtys) {
        List<SalesLineItem> lineItems = accountItemsBelongTo.getAllItems();
        Set<PrinterGroup> printerGroups = newWorkflow.getPrototypeHandledPrinterGroups();
        for (SalesLineItem lineItem : lineItems) {
            for (SalesItem item : lineItem.getSalesItems()) {
                for (SalesComponent component : item.getComponentList()) {
                    List<SalesItemQuantity> itemQtys = item.getSalesItemQuantities();
                    if (!printerGroups.contains(component.getInventoryItem().getPrinterGroup())) {
                        for (SalesItemQuantity qty : itemQtys) {
                            normalQtys.add(qty);
                        }
                    }
                    for (SalesItemQuantity qty : itemQtys) {
                        if ("PRINTED".equals(qty.getPrintState())) continue;
                        if (!(accountItemsBelongTo instanceof TableAccount)) {
                            qtys.add(qty);
                            continue;
                        }
                        if (this.isCourseOnHold((TableAccount)accountItemsBelongTo, item)) continue;
                        qtys.add(qty);
                    }
                }
            }
        }
    }

    private boolean isCourseOnHold(TableAccount account, SalesItem item) {
        SalesAccountCourse salesAccountCourse = account.getSalesAccountCourse(item.getCourse());
        return salesAccountCourse != null && salesAccountCourse.getCoursePrintStatus() == CoursePrintStatus.HOLD;
    }

    protected List<SalesItemQuantity> determineHandledQuantities(Workflow newWorkflow, Account account, List<Workflow> workflowsHandlingAcc) {
        ArrayList<SalesItemQuantity> qtys = new ArrayList<SalesItemQuantity>();
        ArrayList<SalesItemQuantity> normalQtys = new ArrayList<SalesItemQuantity>();
        this.getNormalAndHandledQtys(newWorkflow, this.srcAccount, qtys, normalQtys);
        for (Workflow workflow : workflowsHandlingAcc) {
            qtys.removeAll(workflow.getHandledItemQuantities());
        }
        qtys.removeAll(normalQtys);
        for (SalesItemQuantity qty : new HashSet<SalesItemQuantity>(normalQtys)) {
            if (!"PRINTED".equals(qty.getPrintState())) continue;
            normalQtys.remove(qty);
        }
        HashMap<Workflow, WorkflowHelper> helpers = new HashMap<Workflow, WorkflowHelper>();
        for (SalesItemQuantity qty : new ArrayList<SalesItemQuantity>(qtys)) {
            if (!qty.isReversed() && !"MOVED".equals(qty.getItemState())) continue;
            this.handleChangedQuantity(qty, qtys, workflowsHandlingAcc, helpers);
        }
        this.handleSplitQuantityChanges(qtys, workflowsHandlingAcc, account);
        this.handleAbsorbedItems(helpers);
        newWorkflow.setHandledItemQuantities(qtys);
        return normalQtys;
    }

    private void handleSplitQuantityChanges(List<SalesItemQuantity> qtysToHandle, List<Workflow> workflowsHandlingAcc, Account account) {
        try {
            ArrayList<SalesItemQuantity> alreadyPrintedItems = new ArrayList<SalesItemQuantity>();
            for (SalesItemQuantity qty : qtysToHandle) {
                if (!"PRINTED".equals(qty.getPrintState())) continue;
                alreadyPrintedItems.add(qty);
            }
            for (SalesItemQuantity saleItemQty : alreadyPrintedItems) {
                SalesQuantity origSalesQty = SalesQuantity.ZERO;
                for (Workflow workflow : workflowsHandlingAcc) {
                    for (SalesItemQuantity origItemQty : workflow.getHandledItemQuantities()) {
                        if (!origItemQty.getSalesLineItem().isEquivalentTo(saleItemQty.getSalesLineItem(), true, true)) continue;
                        origSalesQty = origSalesQty.add(origItemQty.getQuantity());
                    }
                }
                SalesQuantity accSalesQty = SalesQuantity.ZERO;
                for (SalesLineItem item : account.getAllItems()) {
                    if (!item.isEquivalentTo(saleItemQty.getSalesLineItem(), true, true)) continue;
                    accSalesQty = accSalesQty.add(item.getQuantity());
                }
                if (!origSalesQty.equals(accSalesQty) && !origSalesQty.equals(accSalesQty.add(saleItemQty.getQuantity()))) continue;
                qtysToHandle.remove(saleItemQty);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("An error occured attempting to check existing handled split quantities.", (Throwable)ex);
        }
    }

    protected abstract WorkflowPrepPrintJob createDocketForNormalQuantities(Account var1, TriggerActivationContext var2, List<SalesItemQuantity> var3, Workflow var4);

    protected WorkflowPrepPrintJob createDocketForNormalQuantities(Account account, TriggerActivationContext context, List<SalesItemQuantity> normalQuantities, Workflow createdWorkflow, Account targetAccount) {
        HashSet<PrinterGroup> unhandledGroups = new HashSet<PrinterGroup>(PrinterGroup.getPrinterGroups());
        unhandledGroups.removeAll(createdWorkflow.getPrototypeHandledPrinterGroups());
        return normalQuantities.isEmpty() ? null : new WorkflowPrepPrintJob(account, context, null, null, normalQuantities, unhandledGroups, targetAccount, this.prepJob.isRushed());
    }

    public static PrepPrintJob process(AbstractPrintJob job, List<Workflow> workflows, List<Workflow> newWorkflows) {
        WorkflowProcess workflowProcess = job instanceof TransferPrepPrintJob ? new TransferWorkflowProcess(((TransferPrepPrintJob)job).getTargetAccount()) : new NormalWorkflowProcess();
        PrepPrintJob printJob = workflowProcess.doWork(job, workflows, newWorkflows);
        return printJob;
    }

    protected void addNewWorkflow(Workflow newWorkflow) {
        this.newWorkflows.add(newWorkflow);
    }

    protected TriggerActivationContext getContext() {
        return this.activationContext;
    }

    protected void removeItemsFromActionSets(List<SalesItemQuantity> removedItems, Workflow workflow) {
        for (WorkflowActionSet set : workflow.getActionSets()) {
            for (WorkflowAction action : set.getActions()) {
                if (!(action instanceof WorkflowPrintAction)) continue;
                this.removeAllQuantities(removedItems, (WorkflowPrintAction)action);
            }
        }
    }

    private void removeAllQuantities(List<SalesItemQuantity> toRemoveQty, WorkflowPrintAction action) {
        ArrayList<WorkflowActionSalesItemQuantity> newQtys = new ArrayList<WorkflowActionSalesItemQuantity>();
        newQtys.addAll(action.getActionQtys());
        for (WorkflowActionSalesItemQuantity nextQty : action.getActionQtys()) {
            for (SalesItemQuantity saleQty : toRemoveQty) {
                SalesItemQuantity targetQty = this.getMatchingSalesQtyItem(saleQty, this.srcAccount, null);
                if ((targetQty == null || !nextQty.getSalesItemQuantity().equals(targetQty)) && !nextQty.getSalesItemQuantity().getSalesLineItem().equals(saleQty.getSalesLineItem())) continue;
                newQtys.remove(nextQty);
            }
        }
        action.setActionQtys(newQtys);
    }

    protected SalesItemQuantity getMatchingSalesQtyItem(SalesItemQuantity removedItem, Account accountToSearch, Collection<SalesItemQuantity> alreadyFoundList) {
        for (SalesItem item : removedItem.getSalesLineItem().getSalesItems()) {
            for (SalesComponent component : item.getComponentList()) {
                SalesItemQuantity targetQty = this.getAccountsMatchingQuantity(component.getInventoryItem(), removedItem.getQuantity(), accountToSearch, alreadyFoundList, removedItem.getSalesLineItem().getCourse());
                if (targetQty == null) continue;
                return targetQty;
            }
        }
        return null;
    }

    private SalesItemQuantity getAccountsMatchingQuantity(InventoryItem invItem, SalesQuantity qty, Account accountToSearch, Collection<SalesItemQuantity> alreadyFoundList, int course) {
        for (SalesLineItem accountItem : accountToSearch.getItems()) {
            for (SalesItem item : accountItem.getSalesItems()) {
                for (SalesComponent component : item.getComponentList()) {
                    if (!component.getInventoryItem().equals(invItem)) continue;
                    for (SalesItemQuantity salesQty : item.getSalesItemQuantities()) {
                        if (salesQty.getSalesLineItem().getCourse() != course || !salesQty.getQuantity().getValue().equals(qty.getValue().abs()) || alreadyFoundList != null && alreadyFoundList.contains(salesQty)) continue;
                        return salesQty;
                    }
                }
            }
        }
        return null;
    }
}

