/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.workflow.Workflow;

public class WorkflowSalesItemQuantity
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<Workflow> workflow;
    private Reference<SalesItemQuantity> salesItemQuantity;
    private String printState;

    public WorkflowSalesItemQuantity() {
        this.workflow = this.createReference(WorkflowSalesItemQuantity.Properties.WORKFLOW);
        this.salesItemQuantity = this.createReference(WorkflowSalesItemQuantity.Properties.SALES_ITEM_QUANTITY);
        this.markAsNotPrinted();
    }

    WorkflowSalesItemQuantity(Workflow flow, SalesItemQuantity quantity) {
        this.workflow = this.createReference(WorkflowSalesItemQuantity.Properties.WORKFLOW);
        this.salesItemQuantity = this.createReference(WorkflowSalesItemQuantity.Properties.SALES_ITEM_QUANTITY);
        this.setWorkflow(flow);
        this.setSalesItemQuantity(quantity);
        this.markAsNotPrinted();
    }

    public Workflow getWorkflow() {
        return this.workflow.get();
    }

    protected void setWorkflow(Workflow value) {
        this.workflow.set(value);
    }

    public SalesItemQuantity getSalesItemQuantity() {
        return this.salesItemQuantity.get();
    }

    protected void setSalesItemQuantity(SalesItemQuantity value) {
        this.salesItemQuantity.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public void markAsPrinted() {
        if (this.getPrintState().equals("NOT_PRINTED")) {
            this.printState = "PRINTED";
        }
    }

    public void markAsNotPrinted() {
        this.printState = "NOT_PRINTED";
    }

    public String getPrintState() {
        return this.printState;
    }

    protected void setPrintState(String printState) {
        this.printState = printState;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Workflow> WORKFLOW;
        public PropertiedObject.Property<SalesItemQuantity> SALES_ITEM_QUANTITY;
        public PropertiedObject.Property PRINT_STATE;
    }
}

