/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.util.Collections;
import java.util.Set;
import ordermate.database.EventContext;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.sales.Account;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowActionState;
import ordermate.database.workflow.action.WorkflowActionType;

public abstract class WorkflowAction
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<WorkflowActionSet> actionSet;
    private WorkflowActionState state;
    private transient String label;

    public WorkflowAction() {
        this.actionSet = this.createReference(WorkflowAction.Properties.ACTION_SET);
        this.state = WorkflowActionState.NotStarted;
    }

    public WorkflowAction(WorkflowActionSet parent) {
        this.actionSet = this.createReference(WorkflowAction.Properties.ACTION_SET);
        this.state = WorkflowActionState.NotStarted;
        this.setActionSet(parent);
    }

    public void initialiseAction() {
    }

    public WorkflowActionSet getActionSet() {
        return this.actionSet.get();
    }

    protected void setActionSet(WorkflowActionSet newParent) {
        this.actionSet.set(newParent);
    }

    public WorkflowActionState getState() {
        return this.state;
    }

    protected void setState(WorkflowActionState value) {
        this.state = value;
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public void start(Account account, EventContext context) {
        this.setState(WorkflowActionState.Started);
        this.saveChild();
        if (this.performAction(account, context)) {
            this.setState(WorkflowActionState.Completed);
        } else {
            this.setState(WorkflowActionState.NotStarted);
        }
        this.saveChild();
    }

    protected abstract boolean performAction(Account var1, EventContext var2);

    protected abstract WorkflowAction createWorkflowAction(WorkflowActionSet var1);

    public abstract WorkflowActionType getActionType();

    public Set<? extends PrinterGroup> getPrinterGroups() {
        return Collections.emptySet();
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.verbaliseAction();
        }
        return this.label;
    }

    protected void clearLabel() {
        this.label = null;
    }

    protected abstract String verbaliseAction();

    public WorkflowAction generateAction(WorkflowActionSet parent) {
        WorkflowAction newAction = this.createWorkflowAction(parent);
        newAction.setState(WorkflowActionState.NotStarted);
        return newAction;
    }

    public abstract WorkflowAction copyNoID(WorkflowActionSet var1);

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<WorkflowActionSet> ACTION_SET;
        public PropertiedObject.Property<WorkflowActionState> STATE;
        public PersistentObject.DerivedProperty<String> LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)WorkflowAction.class), "label");
    }
}

