/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action;

import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowActionType;
import ordermate.database.workflow.action.WorkflowEmailAction;
import ordermate.database.workflow.action.WorkflowKTSStateAction;
import ordermate.database.workflow.action.WorkflowPrintAction;
import ordermate.database.workflow.action.WorkflowSMSAction;

public class WorkflowActionFactory {
    private WorkflowActionSet actionSet;

    public WorkflowActionFactory(WorkflowActionSet parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Cannot have a WorkflowActionFactory without a ActionSet.");
        }
        this.actionSet = parent;
    }

    public WorkflowAction createAction(WorkflowActionType type) {
        WorkflowAction action = null;
        if (WorkflowActionType.Email.equals((Object)type)) {
            action = new WorkflowEmailAction(this.actionSet);
        } else if (WorkflowActionType.SMS.equals((Object)type)) {
            action = new WorkflowSMSAction(this.actionSet);
        } else if (WorkflowActionType.Print.equals((Object)type)) {
            action = new WorkflowPrintAction(this.actionSet);
        } else if (WorkflowActionType.KTSState.equals((Object)type)) {
            action = new WorkflowKTSStateAction(this.actionSet);
        } else {
            throw new IllegalArgumentException("Unknown kind of WorkflowAction Type : " + (Object)((Object)type));
        }
        this.actionSet.addAction(action);
        return action;
    }
}

