/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionState;
import ordermate.database.workflow.action.WorkflowActionType;
import ordermate.database.workflow.action.WorkflowPrintAction;
import ordermate.database.workflow.action.condition.WorkflowCondition;

public class WorkflowActionSet
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<Workflow> workflow;
    private String label;
    private PersistentWriteableList<WorkflowAction> actions;
    private PersistentWriteableList<WorkflowCondition> conditions;
    private boolean optional;
    private WorkflowActionState state;

    public WorkflowActionSet() {
        this.workflow = this.createReference(WorkflowActionSet.Properties.WORKFLOW);
        this.actions = (PersistentWriteableList)this.createList(WorkflowActionSet.Properties.ACTIONS);
        this.conditions = (PersistentWriteableList)this.createList(WorkflowActionSet.Properties.CONDITIONS);
        this.state = WorkflowActionState.NotStarted;
    }

    public WorkflowActionSet(Workflow workflow) {
        this.workflow = this.createReference(WorkflowActionSet.Properties.WORKFLOW);
        this.actions = (PersistentWriteableList)this.createList(WorkflowActionSet.Properties.ACTIONS);
        this.conditions = (PersistentWriteableList)this.createList(WorkflowActionSet.Properties.CONDITIONS);
        this.state = WorkflowActionState.NotStarted;
        this.label = "New Action Set";
        this.setWorkflow(workflow);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public Workflow getWorkflow() {
        return this.workflow.get();
    }

    protected void setWorkflow(Workflow value) {
        this.workflow.set(value);
    }

    public WorkflowActionState getState() {
        return this.state;
    }

    protected void setState(WorkflowActionState value) {
        this.state = value;
    }

    public List<WorkflowAction> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    protected void setActions(List<WorkflowAction> value) {
        this.actions = this.actions.clone();
        this.actions.set(value);
    }

    public List<WorkflowCondition> getConditions() {
        return this.conditions.getUnmodifiable();
    }

    protected void setConditions(List<WorkflowCondition> value) {
        this.conditions = this.conditions.clone();
        this.conditions.set(value);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean value) {
        this.optional = value;
    }

    public boolean isCompleted() {
        return WorkflowActionState.Completed.equals((Object)this.state);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
        this.actions.saveChild();
        this.conditions.saveChild();
    }

    @Override
    public void deleteChild() {
        this.actions.deleteChild();
        this.conditions.deleteChild();
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public void start() {
        this.setState(WorkflowActionState.Started);
        this.saveChild();
        boolean successful = true;
        for (WorkflowAction action : this.getActions()) {
            if (WorkflowActionState.NotStarted.equals((Object)action.getState())) {
                try {
                    action.start(this.getWorkflow().getAccount(), this.getWorkflow().getContext());
                }
                catch (Exception ex) {
                    successful = false;
                    OrderMate.LOG.error("Couldn't perform workflow action successfully, marking as not started:", (Throwable)ex);
                }
            }
            successful = successful && WorkflowActionState.Completed.equals((Object)action.getState());
        }
        if (successful) {
            this.setState(WorkflowActionState.Completed);
            this.saveChild();
        }
    }

    public void addCondition(WorkflowCondition condition) {
        if (!this.conditions.contains(condition)) {
            this.conditions.add(condition);
        }
    }

    public void removeCondition(WorkflowCondition condition) {
        this.conditions.remove(condition);
        condition.deleteChild();
    }

    public void addAction(WorkflowAction action) {
        if (!this.actions.contains(action)) {
            this.actions.add(action);
        }
    }

    public void removeAction(WorkflowAction action) {
        this.actions.remove(action);
        action.deleteChild();
    }

    public WorkflowActionSet generateActionSet(Workflow newFlow) {
        WorkflowActionSet actionSet = new WorkflowActionSet(newFlow);
        for (WorkflowAction action : this.actions) {
            actionSet.addAction(action.generateAction(actionSet));
        }
        for (WorkflowCondition cond : this.conditions) {
            actionSet.addCondition(cond.generateCondition(actionSet));
        }
        actionSet.setOptional(this.isOptional());
        actionSet.setLabel(this.getLabel());
        return actionSet;
    }

    @Override
    public String toString() {
        StringBuilder SB = new StringBuilder("<html>");
        if (!this.getConditions().isEmpty()) {
            SB.append("If ");
            this.listify(SB, this.getConditions(), " and ");
            SB.append("<br>then ");
        } else {
            SB.append("Unconditionally ");
        }
        if (this.getActions().isEmpty()) {
            SB.append("do nothing");
        } else {
            this.listify(SB, this.getActions(), " and ");
        }
        SB.append("</html>");
        return SB.toString();
    }

    private void listify(StringBuilder SB, List objects, String joiner) {
        if (objects.size() == 1) {
            SB.append(objects.get(0).toString());
        } else {
            SB.append("<ul>");
            for (int i = 0; i < objects.size(); ++i) {
                SB.append("<li>").append(objects.get(i).toString());
                if (i < objects.size() - 1) {
                    SB.append(joiner);
                }
                SB.append("</li>");
            }
            SB.append("</ul>");
        }
    }

    public Set<PrinterGroup> findPrototypeHandledGroups() {
        HashSet<PrinterGroup> groups = new HashSet<PrinterGroup>();
        for (WorkflowAction action : this.getActions()) {
            if (!WorkflowActionType.Print.equals((Object)action.getActionType())) continue;
            groups.addAll(((WorkflowPrintAction)action).getPrinterGroups());
        }
        return groups;
    }

    public void initialise() {
        for (WorkflowAction action : this.getActions()) {
            action.initialiseAction();
        }
    }

    public WorkflowActionSet copyNoID(Workflow newWorkflow) {
        WorkflowActionSet newActionSet = new WorkflowActionSet();
        for (WorkflowAction action : this.getActions()) {
            newActionSet.addAction(action.copyNoID(newActionSet));
        }
        for (WorkflowCondition condition : this.getConditions()) {
            newActionSet.addCondition(condition.copyNoID(newActionSet));
        }
        newActionSet.setOptional(this.isOptional());
        newActionSet.setLabel(this.getLabel());
        newActionSet.setWorkflow(newWorkflow);
        newActionSet.setState(this.getState());
        return newActionSet;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Workflow> WORKFLOW;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<WorkflowAction> ACTIONS;
        public PropertiedObject.Property<WorkflowCondition> CONDITIONS;
        public PropertiedObject.Property OPTIONAL;
        public PropertiedObject.Property<WorkflowActionState> STATE;
    }
}

