/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action;

import au.com.ordermate.message.Email;
import au.com.ordermate.message.MessageServer;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowActionType;
import ordermate.integration.cloudback.OMOutgoingServiceResponse;
import ordermate.integration.cloudback.nudge.NudgeManager;

public class WorkflowEmailAction
extends WorkflowAction {
    public static final Props Properties = new Props();
    private String message;
    private boolean emailSent = false;

    public WorkflowEmailAction() {
    }

    public WorkflowEmailAction(WorkflowActionSet actionSet) {
        super(actionSet);
        this.message = "";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String value) {
        this.message = value;
    }

    @Override
    protected boolean performAction(Account account, EventContext context) {
        MessageServer server;
        if (StringUtils.isEmpty(this.getMessage())) {
            OrderMate.LOG.info("Cannot send email to customer, there is not message");
        }
        if (!NudgeManager.isNudgeConfigured() && !(server = MessageServer.getServer()).isConnected()) {
            OrderMate.LOG.info("Will not send Email, MessageServer is not connected");
            return true;
        }
        Customer customer = account.getCustomer();
        if (customer == null) {
            OrderMate.LOG.info("No customer for account, not sending Email:" + this.message + " for Account " + account);
            return true;
        }
        String address = customer.getEmail();
        if (StringUtils.isEmpty(address)) {
            OrderMate.LOG.info("No address found for customer, not sendind Email:" + this.message + " for Account " + account);
            return true;
        }
        OrderMate.LOG.info("Sending Email to customer:" + this.getMessage());
        Email email = new Email();
        email.setText(this.getMessage());
        String emailSender = SystemProperty.getInstance().getEmailSender();
        if (!StringUtils.isEmpty(emailSender)) {
            email.addSender(emailSender, emailSender);
        }
        email.addToRecipient(address, customer.getName());
        email.setSubject(BusinessInfo.getInstance().getName());
        if (NudgeManager.isNudgeConfigured()) {
            OMOutgoingServiceResponse omNudgeResponse = NudgeManager.getInstance().sendEmail(email);
            this.emailSent = omNudgeResponse.isSuccessful();
        } else {
            MessageServer.getServer().send(email.createMessage(MessageServer.getServer().getSession()));
        }
        return true;
    }

    public boolean isEmailSent() {
        return this.emailSent;
    }

    @Override
    protected WorkflowAction createWorkflowAction(WorkflowActionSet parent) {
        WorkflowEmailAction action = new WorkflowEmailAction(parent);
        action.setMessage(this.message);
        return action;
    }

    @Override
    protected String verbaliseAction() {
        return "Send Email to Customer";
    }

    @Override
    public WorkflowActionType getActionType() {
        return WorkflowActionType.Email;
    }

    @Override
    public WorkflowAction copyNoID(WorkflowActionSet newActionSet) {
        WorkflowEmailAction newAction = new WorkflowEmailAction(newActionSet);
        newAction.setMessage(this.getMessage());
        newAction.setState(this.getState());
        return newAction;
    }

    public static class Props
    extends WorkflowAction.Props {
        public PropertiedObject.Property<String> MESSAGE;
    }
}

