/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.Collections;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.sales.Account;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowActionType;

public class WorkflowKTSStateAction
extends WorkflowAction {
    public static final Props Properties = new Props();
    private KTSDocketState fromState = KTSDocketState.Hold;
    private KTSDocketState toState = KTSDocketState.Live;
    private Reference<KTSDocketPrinter> ktsPrinter;

    public WorkflowKTSStateAction() {
        this.ktsPrinter = this.createReference(WorkflowKTSStateAction.Properties.KTS_PRINTER);
    }

    public KTSDocketState getFromState() {
        return this.fromState;
    }

    public void setFromState(KTSDocketState newFromState) {
        this.fromState = newFromState;
    }

    public KTSDocketState getToState() {
        return this.toState;
    }

    public void setToState(KTSDocketState newTo) {
        this.toState = newTo;
    }

    public KTSDocketPrinter getKtsPrinter() {
        return this.ktsPrinter.get();
    }

    public void setKtsPrinter(KTSDocketPrinter newPrinter) {
        this.ktsPrinter.set(newPrinter);
    }

    public WorkflowKTSStateAction(WorkflowActionSet set) {
        super(set);
        this.ktsPrinter = this.createReference(WorkflowKTSStateAction.Properties.KTS_PRINTER);
        this.fromState = KTSDocketState.Hold;
        this.toState = KTSDocketState.Live;
        this.ktsPrinter.set(null);
    }

    @Override
    protected boolean performAction(Account account, EventContext context) {
        List<KTSDocketPrinter> printers;
        if (this.ktsPrinter.isNull()) {
            ObjectQuery query = Query.select(KTSDocketPrinter.class).active(KTSDocketPrinter.class);
            printers = PersistenceManager.getObjectList(KTSDocketPrinter.class, query.toString());
        } else {
            printers = Collections.singletonList(this.ktsPrinter.get());
        }
        for (KTSDocketPrinter nextPrinter : printers) {
            nextPrinter.changeKTSState(account, this.fromState, this.toState);
        }
        return !printers.isEmpty();
    }

    @Override
    protected WorkflowAction createWorkflowAction(WorkflowActionSet parent) {
        WorkflowKTSStateAction newAction = new WorkflowKTSStateAction(parent);
        newAction.setFromState(this.getFromState());
        newAction.setToState(this.getToState());
        newAction.setKtsPrinter(this.getKtsPrinter());
        return newAction;
    }

    @Override
    public WorkflowActionType getActionType() {
        return WorkflowActionType.KTSState;
    }

    @Override
    protected String verbaliseAction() {
        StringBuilder SB = new StringBuilder("Move dockets from ");
        SB.append(this.fromState == null ? "Any" : this.fromState.name());
        SB.append(" state to ").append(this.toState.name()).append(" on ");
        SB.append(this.ktsPrinter.isNull() ? "Any KTS" : this.ktsPrinter.get().getLabel());
        return SB.toString();
    }

    @Override
    public WorkflowAction copyNoID(WorkflowActionSet newActionSet) {
        WorkflowKTSStateAction newAction = new WorkflowKTSStateAction(newActionSet);
        newAction.setState(this.getState());
        newAction.setFromState(this.getFromState());
        newAction.setKtsPrinter(this.getKtsPrinter());
        newAction.setToState(this.getToState());
        return newAction;
    }

    public static class Props
    extends WorkflowAction.Props {
        public PropertiedObject.Property<KTSDocketState> FROM_STATE;
        public PropertiedObject.Property<KTSDocketState> TO_STATE;
        public PropertiedObject.Property<KTSDocketPrinter> KTS_PRINTER;
    }
}

