/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action;

import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionPrinterGroup;
import ordermate.database.workflow.action.WorkflowActionSalesItemQuantity;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowActionState;
import ordermate.database.workflow.action.WorkflowActionType;

public class WorkflowPrintAction
extends WorkflowAction {
    public static final Props Properties = new Props();
    private Reference<VirtualPrinter> virtualPrinter;
    private PersistentWriteableList<WorkflowActionPrinterGroup> actionPrinterGroups;
    private PersistentWriteableList<WorkflowActionSalesItemQuantity> actionQtys;
    private Reference<SalesAccountDocket> docket;
    private boolean child;
    private KTSDocketState ktsState;

    public WorkflowPrintAction() {
        this.virtualPrinter = this.createReference(WorkflowPrintAction.Properties.VIRTUAL_PRINTER);
        this.actionPrinterGroups = (PersistentWriteableList)this.createList(WorkflowPrintAction.Properties.ACTION_PRINTER_GROUPS);
        this.actionQtys = (PersistentWriteableList)this.createList(WorkflowPrintAction.Properties.ACTION_QTYS);
        this.docket = this.createReference(WorkflowPrintAction.Properties.DOCKET);
        this.child = false;
        this.ktsState = KTSDocketState.Live;
    }

    public WorkflowPrintAction(WorkflowActionSet actionSet) {
        super(actionSet);
        this.virtualPrinter = this.createReference(WorkflowPrintAction.Properties.VIRTUAL_PRINTER);
        this.actionPrinterGroups = (PersistentWriteableList)this.createList(WorkflowPrintAction.Properties.ACTION_PRINTER_GROUPS);
        this.actionQtys = (PersistentWriteableList)this.createList(WorkflowPrintAction.Properties.ACTION_QTYS);
        this.docket = this.createReference(WorkflowPrintAction.Properties.DOCKET);
        this.child = false;
        this.ktsState = KTSDocketState.Live;
    }

    public WorkflowPrintAction(WorkflowPrintAction toCopy, List<SalesItemQuantity> qtysToPrint) {
        super(toCopy.getActionSet());
        this.virtualPrinter = this.createReference(WorkflowPrintAction.Properties.VIRTUAL_PRINTER);
        this.actionPrinterGroups = (PersistentWriteableList)this.createList(WorkflowPrintAction.Properties.ACTION_PRINTER_GROUPS);
        this.actionQtys = (PersistentWriteableList)this.createList(WorkflowPrintAction.Properties.ACTION_QTYS);
        this.docket = this.createReference(WorkflowPrintAction.Properties.DOCKET);
        this.child = false;
        this.ktsState = KTSDocketState.Live;
        this.setVirtualPrinter(toCopy.getVirtualPrinter());
        this.setPrinterGroups(toCopy.getPrinterGroups());
        this.child = true;
        this.initialiseQuantities(qtysToPrint);
        this.setKtsState(toCopy.getKtsState());
    }

    @Override
    public void initialiseAction() {
        this.initialiseQuantities(null);
    }

    public VirtualPrinter getVirtualPrinter() {
        return this.virtualPrinter.get();
    }

    public void setVirtualPrinter(VirtualPrinter printer) {
        this.virtualPrinter.set(printer);
        this.clearLabel();
    }

    protected List<WorkflowActionPrinterGroup> getActionPrinterGroups() {
        return this.actionPrinterGroups;
    }

    protected void setActionPrinterGroups(List<WorkflowActionPrinterGroup> newGroups) {
        this.actionPrinterGroups = this.actionPrinterGroups.clone();
        this.actionPrinterGroups.set(newGroups);
        this.clearLabel();
    }

    public void addPrinterGroup(PrinterGroup group) {
        if (this.findPrinterGroup(group) == null) {
            WorkflowActionPrinterGroup newLink = new WorkflowActionPrinterGroup(this, group);
            this.getActionPrinterGroups().add(newLink);
            this.clearLabel();
        }
    }

    public void removePrinterGroup(PrinterGroup group) {
        WorkflowActionPrinterGroup link = this.findPrinterGroup(group);
        if (link != null) {
            this.getActionPrinterGroups().remove(link);
            link.deleteChild();
            this.clearLabel();
        }
    }

    private WorkflowActionPrinterGroup findPrinterGroup(PrinterGroup group) {
        for (WorkflowActionPrinterGroup nextLink : this.getActionPrinterGroups()) {
            if (!group.equals(nextLink.getPrinterGroup())) continue;
            return nextLink;
        }
        return null;
    }

    @Override
    protected boolean performAction(Account account, EventContext context) {
        OrderMate.LOG.info("Printing " + Arrays.toString(this.getActionPrinterGroups().toArray()) + " to " + this.getVirtualPrinter() + ", ID " + this.getID());
        if (account == null) {
            OrderMate.LOG.error("Cannot print a null account.");
            return true;
        }
        if (this.getVirtualPrinter() == null) {
            OrderMate.LOG.warn("Cannot print to null printer");
            return true;
        }
        Set<PrinterGroup> groups = this.getPrinterGroups();
        if (groups == null) {
            OrderMate.LOG.info("Nothing printed, no groups");
            return true;
        }
        List<SalesItemQuantity> qtys = this.getQuantitiesToPrint();
        if (qtys == null || qtys.isEmpty()) {
            OrderMate.LOG.info("Nothing to print");
            return true;
        }
        this.getActionSet().getWorkflow().getPrintCache().cacheItemsToPrint(this.getVirtualPrinter(), qtys, this);
        return true;
    }

    @Override
    protected WorkflowAction createWorkflowAction(WorkflowActionSet parent) {
        WorkflowPrintAction action = new WorkflowPrintAction(parent);
        action.setVirtualPrinter(this.getVirtualPrinter());
        for (WorkflowActionPrinterGroup group : this.getActionPrinterGroups()) {
            action.addPrinterGroup(group.getPrinterGroup());
        }
        action.setKtsState(this.getKtsState());
        return action;
    }

    @Override
    protected String verbaliseAction() {
        StringBuilder SB = new StringBuilder("print ");
        if (this.actionPrinterGroups.isEmpty()) {
            SB.append("nothing ");
        } else {
            for (WorkflowActionPrinterGroup nextGroup : this.getActionPrinterGroups()) {
                SB.append(nextGroup.getPrinterGroup().getLabel()).append(", ");
            }
            SB.deleteCharAt(SB.length() - 2);
        }
        SB.append("to ");
        if (this.getVirtualPrinter() == null) {
            SB.append("nowhere");
        } else {
            SB.append(this.getVirtualPrinter().getLabel());
        }
        SB.append(" as ").append((Object)this.getKtsState());
        return SB.toString();
    }

    @Override
    public WorkflowActionType getActionType() {
        return WorkflowActionType.Print;
    }

    public List<WorkflowActionSalesItemQuantity> getActionQtys() {
        return this.actionQtys;
    }

    public void setActionQtys(List<WorkflowActionSalesItemQuantity> qtys) {
        this.actionQtys = this.actionQtys.clone();
        this.actionQtys.set(qtys);
    }

    @Override
    public void saveChild() {
        super.saveChild();
        this.actionQtys.saveChild();
        this.actionPrinterGroups.saveChild();
    }

    @Override
    public void deleteChild() {
        super.deleteChild();
        this.actionQtys.deleteChild();
        this.actionPrinterGroups.deleteChild();
    }

    public boolean isChild() {
        return this.child;
    }

    protected void setChild(boolean value) {
        this.child = value;
    }

    public void initialiseQuantities(List<SalesItemQuantity> changedQuantities) {
        List<SalesItemQuantity> allQtys = changedQuantities;
        if (changedQuantities == null) {
            allQtys = this.getActionSet().getWorkflow().getHandledItemQuantities();
        }
        Set<PrinterGroup> groups = this.getPrinterGroups();
        block0: for (SalesItemQuantity qty : allQtys) {
            for (SalesItem item : qty.getSalesLineItem().getSalesItems()) {
                if (!groups.contains(item.getFirstInventoryItem().getPrinterGroup())) continue;
                WorkflowActionSalesItemQuantity actionQty = new WorkflowActionSalesItemQuantity(this, qty);
                this.actionQtys.add(actionQty);
                continue block0;
            }
        }
    }

    public List<SalesItemQuantity> getQuantitiesToPrint() {
        ArrayList<SalesItemQuantity> toPrint = new ArrayList<SalesItemQuantity>();
        for (WorkflowActionSalesItemQuantity nextQty : this.actionQtys) {
            toPrint.add(nextQty.getSalesItemQuantity());
        }
        return toPrint;
    }

    public Set<PrinterGroup> getPrinterGroups() {
        HashSet<PrinterGroup> printerGroups = new HashSet<PrinterGroup>();
        for (WorkflowActionPrinterGroup group : this.actionPrinterGroups) {
            printerGroups.add(group.getPrinterGroup());
        }
        return printerGroups;
    }

    public void setPrinterGroups(Set<PrinterGroup> groups) {
        Set<PrinterGroup> toSet = groups;
        if (toSet == null) {
            toSet = new HashSet<PrinterGroup>(PrinterGroup.getPrinterGroups());
        }
        ArrayList<WorkflowActionPrinterGroup> localCopy = new ArrayList<WorkflowActionPrinterGroup>(this.getActionPrinterGroups());
        for (WorkflowActionPrinterGroup nextGroup : localCopy) {
            if (toSet.contains(nextGroup.getPrinterGroup())) continue;
            this.actionPrinterGroups.remove(nextGroup);
            nextGroup.deleteChild();
        }
        for (PrinterGroup group : toSet) {
            this.addPrinterGroup(group);
        }
        this.clearLabel();
    }

    public SalesAccountDocket getDocket() {
        return this.docket.get();
    }

    public void setDocket(SalesAccountDocket value) {
        this.docket.set(value);
        this.setState(WorkflowActionState.Completed);
    }

    public KTSDocketState getKtsState() {
        return this.ktsState;
    }

    public void setKtsState(KTSDocketState state) {
        this.ktsState = state;
    }

    @Override
    public WorkflowAction copyNoID(WorkflowActionSet newActionSet) {
        WorkflowPrintAction newWorkflowAction = new WorkflowPrintAction(newActionSet);
        newWorkflowAction.setVirtualPrinter(this.getVirtualPrinter());
        newWorkflowAction.setPrinterGroups(this.getPrinterGroups());
        newWorkflowAction.setKtsState(this.getKtsState());
        newWorkflowAction.setChild(this.isChild());
        newWorkflowAction.setState(this.getState());
        return newWorkflowAction;
    }

    public static class Props
    extends WorkflowAction.Props {
        public PropertiedObject.Property<VirtualPrinter> VIRTUAL_PRINTER;
        public PropertiedObject.Property<WorkflowActionPrinterGroup> ACTION_PRINTER_GROUPS;
        public PropertiedObject.Property<WorkflowActionSalesItemQuantity> ACTION_QTYS;
        public PropertiedObject.Property<SalesAccountDocket> DOCKET;
        public PropertiedObject.Property CHILD;
        public PropertiedObject.Property<KTSDocketState> KTS_STATE;
    }
}

