/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action;

import au.com.ordermate.message.MessageServer;
import au.com.ordermate.message.SMS;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.message.SmsProvider;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.workflow.action.WorkflowAction;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.WorkflowActionType;

public class WorkflowSMSAction
extends WorkflowAction {
    private MessageServer server;
    public static final Props Properties = new Props();
    private String message;

    public WorkflowSMSAction() {
    }

    public WorkflowSMSAction(WorkflowActionSet parent) {
        super(parent);
    }

    @Override
    protected boolean performAction(Account account, EventContext context) {
        Customer customer = account.getCustomer();
        if (customer == null) {
            OrderMate.LOG.info("No customer for account, not sending SMS:" + this.message);
            return true;
        }
        String number = customer.getPhoneNumber();
        if (StringUtils.isEmpty(number)) {
            number = customer.getSecondaryPhoneNumber();
        }
        if (StringUtils.isEmpty(number)) {
            OrderMate.LOG.info("No customer phone number found for customer, not sendind SMS:" + this.message);
            return true;
        }
        OrderMate.LOG.info("Sending SMS to customer:" + this.getMessage());
        SmsProvider smsProvider = SmsProvider.getProvider();
        SMS sms = new SMS();
        sms.setPhoneNumber(number);
        sms.setText(this.getMessage());
        if (!this.isSmsTypeOverHTTP()) {
            MessageServer currentServer = this.getServer();
            if (!this.server.isSmtpConnected()) {
                OrderMate.LOG.info("Will not send SMS, MessageServer (SMTP) is not connected.");
                return true;
            }
            SMS.setup(smsProvider.getEmailSuffix(), smsProvider.getSubject(), smsProvider.getSenderEmail(), smsProvider.getSenderName());
            currentServer.send(sms.createMessage(currentServer.getSession()));
        } else {
            sms.sendSMSviaHTTP(false);
        }
        return true;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String value) {
        this.message = value;
    }

    @Override
    protected WorkflowAction createWorkflowAction(WorkflowActionSet parent) {
        WorkflowSMSAction action = new WorkflowSMSAction(parent);
        action.setMessage(this.getMessage());
        return action;
    }

    @Override
    protected String verbaliseAction() {
        return "Send SMS to Customer";
    }

    @Override
    public WorkflowActionType getActionType() {
        return WorkflowActionType.SMS;
    }

    @Override
    public WorkflowAction copyNoID(WorkflowActionSet newActionSet) {
        WorkflowSMSAction newAction = new WorkflowSMSAction(newActionSet);
        newAction.setMessage(this.getMessage());
        newAction.setState(this.getState());
        return newAction;
    }

    private MessageServer getServer() {
        if (this.server == null) {
            this.server = MessageServer.getServer();
        }
        if (this.server != null && !this.server.isSmtpConnected()) {
            this.server.connect();
        }
        return this.server;
    }

    private boolean isSmsTypeOverHTTP() {
        SmsProvider smsProvider = SmsProvider.getProvider();
        return smsProvider.getProviderType().equals((Object)SmsProvider.SMSProviderType.HTTP);
    }

    public static class Props
    extends WorkflowAction.Props {
        public PropertiedObject.Property<String> MESSAGE;
    }
}

