/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action.condition;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.condition.WorkflowConditionType;

public abstract class WorkflowCondition
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<WorkflowActionSet> actionSet;
    private boolean logicalNot;
    private transient String label;

    public WorkflowCondition() {
        this.actionSet = this.createReference(WorkflowCondition.Properties.ACTION_SET);
        this.logicalNot = false;
        this.label = null;
    }

    public WorkflowCondition(WorkflowActionSet theActionSet) {
        this.actionSet = this.createReference(WorkflowCondition.Properties.ACTION_SET);
        this.logicalNot = false;
        this.label = null;
        this.setActionSet(theActionSet);
    }

    public WorkflowActionSet getActionSet() {
        return this.actionSet.get();
    }

    protected void setActionSet(WorkflowActionSet value) {
        this.actionSet.set(value);
    }

    public abstract WorkflowConditionType getConditionType();

    public boolean isLogicalNot() {
        return this.logicalNot;
    }

    public void setLogicalNot(boolean value) {
        if (this.logicalNot != value) {
            this.clearLabel();
        }
        this.logicalNot = value;
    }

    public boolean isMet() {
        boolean met = this.isConditionMet(this.getActionSet().getWorkflow());
        if (this.logicalNot) {
            return !met;
        }
        return met;
    }

    protected abstract boolean isConditionMet(Workflow var1);

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public WorkflowCondition generateCondition(WorkflowActionSet parent) {
        WorkflowCondition newCondition = this.createCondition(parent);
        newCondition.setLogicalNot(this.logicalNot);
        return newCondition;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.verbaliseCondition();
        }
        return this.label;
    }

    protected void clearLabel() {
        this.label = null;
    }

    protected abstract WorkflowCondition createCondition(WorkflowActionSet var1);

    protected abstract String verbaliseCondition();

    public abstract WorkflowCondition copyNoID(WorkflowActionSet var1);

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<WorkflowActionSet> ACTION_SET;
        public PropertiedObject.Property LOGICAL_NOT;
        public PersistentObject.DerivedProperty<String> LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)WorkflowCondition.class), "label");
    }
}

