/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action.condition;

import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.condition.WorkflowCondition;
import ordermate.database.workflow.action.condition.WorkflowConditionType;
import ordermate.database.workflow.action.condition.WorkflowContainsCondition;
import ordermate.database.workflow.action.condition.WorkflowKTSCondition;
import ordermate.database.workflow.action.condition.WorkflowPrintedCondition;
import ordermate.database.workflow.action.condition.WorkflowScannedCondition;
import ordermate.database.workflow.action.condition.WorkflowTableGroupCondition;
import ordermate.database.workflow.action.condition.WorkflowTimeCondition;
import ordermate.database.workflow.action.condition.WorkflowTimeDueCondition;

public class WorkflowConditionFactory {
    private WorkflowActionSet actionSet;

    public WorkflowConditionFactory(WorkflowActionSet parent) {
        this.actionSet = parent;
        if (this.actionSet == null) {
            throw new IllegalStateException("Cannot create WorkflowConditions if they have no enclosing WorkflowActionSet.");
        }
    }

    public WorkflowCondition createCondition(WorkflowConditionType type) {
        WorkflowCondition condition = null;
        if (type == null) {
            throw new IllegalArgumentException("Cannot make a condition of null type");
        }
        if (type.equals((Object)WorkflowConditionType.KTS)) {
            condition = new WorkflowKTSCondition(this.actionSet);
        } else if (type.equals((Object)WorkflowConditionType.Printed)) {
            condition = new WorkflowPrintedCondition(this.actionSet);
        } else if (type.equals((Object)WorkflowConditionType.Time)) {
            condition = new WorkflowTimeCondition(this.actionSet);
        } else if (type.equals((Object)WorkflowConditionType.Contains)) {
            condition = new WorkflowContainsCondition(this.actionSet);
        } else if (type.equals((Object)WorkflowConditionType.TimeDue)) {
            condition = new WorkflowTimeDueCondition(this.actionSet);
        } else if (type.equals((Object)WorkflowConditionType.Scanned)) {
            condition = new WorkflowScannedCondition(this.actionSet);
        } else if (type.equals((Object)WorkflowConditionType.TableGroup)) {
            condition = new WorkflowTableGroupCondition(this.actionSet);
        } else {
            throw new IllegalArgumentException("Unknown kind of workflow condition:" + (Object)((Object)type));
        }
        this.actionSet.addCondition(condition);
        return condition;
    }
}

