/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action.condition;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.condition.WorkflowCondition;
import ordermate.database.workflow.action.condition.WorkflowConditionType;

public class WorkflowContainsCondition
extends WorkflowCondition {
    public static final Props Properties = new Props();
    private Reference<PrinterGroup> printerGroup;

    public WorkflowContainsCondition() {
        this.printerGroup = this.createReference(WorkflowContainsCondition.Properties.PRINTER_GROUP);
    }

    public WorkflowContainsCondition(WorkflowActionSet actionSet) {
        super(actionSet);
        this.printerGroup = this.createReference(WorkflowContainsCondition.Properties.PRINTER_GROUP);
    }

    @Override
    public WorkflowConditionType getConditionType() {
        return WorkflowConditionType.Contains;
    }

    @Override
    protected boolean isConditionMet(Workflow workflow) {
        if (this.getPrinterGroup() == null) {
            return true;
        }
        return workflow.getCurrentlyHandledPrinterGroups().contains(this.getPrinterGroup());
    }

    public PrinterGroup getPrinterGroup() {
        return this.printerGroup.get();
    }

    public void setPrinterGroup(PrinterGroup group) {
        this.printerGroup.set(group);
        this.clearLabel();
    }

    @Override
    protected WorkflowCondition createCondition(WorkflowActionSet parent) {
        WorkflowContainsCondition condition = new WorkflowContainsCondition(parent);
        condition.setPrinterGroup(this.getPrinterGroup());
        return condition;
    }

    @Override
    protected String verbaliseCondition() {
        StringBuilder SB = new StringBuilder("Workflow does ");
        if (this.isLogicalNot()) {
            SB.append("not ");
        }
        SB.append("handle items from ");
        if (this.getPrinterGroup() != null) {
            SB.append("printer group ").append(this.getPrinterGroup().getLabel());
        } else {
            SB.append("no printer group");
        }
        return SB.toString();
    }

    @Override
    public WorkflowCondition copyNoID(WorkflowActionSet newActionSet) {
        WorkflowContainsCondition newCondition = new WorkflowContainsCondition(newActionSet);
        newCondition.setPrinterGroup(this.getPrinterGroup());
        newCondition.setLogicalNot(this.isLogicalNot());
        return newCondition;
    }

    public static class Props
    extends WorkflowCondition.Props {
        public PropertiedObject.Property<PrinterGroup> PRINTER_GROUP;
    }
}

