/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action.condition;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.List;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.condition.WorkflowCondition;
import ordermate.database.workflow.action.condition.WorkflowConditionType;
import ordermate.database.workflow.event.WorkflowEvent;
import ordermate.database.workflow.event.WorkflowEventType;
import ordermate.database.workflow.event.WorkflowKTSEvent;
import ordermate.database.workflow.event.WorkflowPrintEvent;

public class WorkflowKTSCondition
extends WorkflowCondition {
    public static final Props Properties = new Props();
    private Reference<KTSDocketPrinter> ktsPrinter;
    private Reference<PrinterGroup> printerGroup;
    private KTSDocketState docketState;

    public WorkflowKTSCondition() {
        this.ktsPrinter = this.createReference(WorkflowKTSCondition.Properties.KTS_PRINTER);
        this.printerGroup = this.createReference(WorkflowKTSCondition.Properties.PRINTER_GROUP);
        this.docketState = KTSDocketState.Bump;
    }

    public WorkflowKTSCondition(WorkflowActionSet actionSet) {
        super(actionSet);
        this.ktsPrinter = this.createReference(WorkflowKTSCondition.Properties.KTS_PRINTER);
        this.printerGroup = this.createReference(WorkflowKTSCondition.Properties.PRINTER_GROUP);
        this.docketState = KTSDocketState.Bump;
    }

    public KTSDocketPrinter getKtsPrinter() {
        return this.ktsPrinter.get();
    }

    public void setKtsPrinter(KTSDocketPrinter value) {
        this.ktsPrinter.set(value);
        this.clearLabel();
    }

    public KTSDocketState getDocketState() {
        return this.docketState;
    }

    public void setDocketState(KTSDocketState newState) {
        this.docketState = newState;
        this.clearLabel();
    }

    public PrinterGroup getPrinterGroup() {
        return this.printerGroup.get();
    }

    public void setPrinterGroup(PrinterGroup value) {
        this.printerGroup.set(value);
        this.clearLabel();
    }

    @Override
    protected boolean isConditionMet(Workflow workflow) {
        if (this.getKtsPrinter() == null || this.getPrinterGroup() == null) {
            return true;
        }
        if (!workflow.getCurrentlyHandledPrinterGroups().contains(this.getPrinterGroup())) {
            return true;
        }
        List<WorkflowEvent> events = workflow.getEvents();
        WorkflowKTSEvent lastKtsEvent = null;
        WorkflowPrintEvent lastPrintEvent = null;
        for (WorkflowEvent event : events) {
            if (WorkflowEventType.KTS.equals((Object)event.getEventType())) {
                WorkflowKTSEvent ktsEvent = (WorkflowKTSEvent)event;
                if (!this.getKtsPrinter().equals(ktsEvent.getKtsPrinter())) continue;
                lastKtsEvent = ktsEvent;
                continue;
            }
            if (!WorkflowEventType.Print.equals((Object)event.getEventType())) continue;
            WorkflowPrintEvent printEvent = (WorkflowPrintEvent)event;
            if (!this.getKtsPrinter().equals(printEvent.getPhysicalPrintDevice()) || !this.getPrinterGroup().equals(printEvent.getPrinterGroup())) continue;
            lastPrintEvent = printEvent;
        }
        return lastPrintEvent != null && lastKtsEvent != null && this.docketState.equals((Object)lastKtsEvent.getDocketState());
    }

    @Override
    protected WorkflowCondition createCondition(WorkflowActionSet parent) {
        WorkflowKTSCondition condition = new WorkflowKTSCondition();
        condition.setKtsPrinter(this.getKtsPrinter());
        condition.setDocketState(this.getDocketState());
        condition.setPrinterGroup(this.getPrinterGroup());
        return condition;
    }

    @Override
    protected String verbaliseCondition() {
        StringBuilder SB = new StringBuilder();
        if (this.getPrinterGroup() != null) {
            SB.append(this.getPrinterGroup());
        } else {
            SB.append("Nothing");
        }
        SB.append(" is ");
        if (this.isLogicalNot()) {
            SB.append("not ");
        }
        SB.append(this.getDocketState().name()).append(" at ");
        SB.append(this.getKtsPrinter() == null ? "nowhere" : this.getKtsPrinter().getLabel());
        return SB.toString();
    }

    @Override
    public WorkflowConditionType getConditionType() {
        return WorkflowConditionType.KTS;
    }

    @Override
    public WorkflowCondition copyNoID(WorkflowActionSet newActionSet) {
        WorkflowKTSCondition newCondition = new WorkflowKTSCondition(newActionSet);
        newCondition.setKtsPrinter(this.getKtsPrinter());
        newCondition.setDocketState(this.getDocketState());
        newCondition.setPrinterGroup(this.getPrinterGroup());
        newCondition.setLogicalNot(this.isLogicalNot());
        return newCondition;
    }

    public static class Props
    extends WorkflowCondition.Props {
        public PropertiedObject.Property<KTSDocketPrinter> KTS_PRINTER;
        public PropertiedObject.Property<PrinterGroup> PRINTER_GROUP;
        public PropertiedObject.Property<KTSDocketState> DOCKET_STATE;
    }
}

