/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action.condition;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.condition.WorkflowCondition;
import ordermate.database.workflow.action.condition.WorkflowConditionType;
import ordermate.database.workflow.event.WorkflowEvent;
import ordermate.database.workflow.event.WorkflowEventType;
import ordermate.database.workflow.event.WorkflowPrintEvent;

public class WorkflowPrintedCondition
extends WorkflowCondition {
    public static final Props Properties = new Props();
    private Reference<VirtualPrinter> virtualPrinter;
    private Reference<PrinterGroup> printerGroup;

    public WorkflowPrintedCondition() {
        this.virtualPrinter = this.createReference(WorkflowPrintedCondition.Properties.VIRTUAL_PRINTER);
        this.printerGroup = this.createReference(WorkflowPrintedCondition.Properties.PRINTER_GROUP);
    }

    public WorkflowPrintedCondition(WorkflowActionSet theActionSet) {
        super(theActionSet);
        this.virtualPrinter = this.createReference(WorkflowPrintedCondition.Properties.VIRTUAL_PRINTER);
        this.printerGroup = this.createReference(WorkflowPrintedCondition.Properties.PRINTER_GROUP);
    }

    public VirtualPrinter getVirtualPrinter() {
        return this.virtualPrinter.get();
    }

    public void setVirtualPrinter(VirtualPrinter printer) {
        this.virtualPrinter.set(printer);
        this.clearLabel();
    }

    public PrinterGroup getPrinterGroup() {
        return this.printerGroup.get();
    }

    public void setPrinterGroup(PrinterGroup group) {
        this.printerGroup.set(group);
        this.clearLabel();
    }

    @Override
    protected boolean isConditionMet(Workflow workflow) {
        if (this.getPrinterGroup() != null && !workflow.getCurrentlyHandledPrinterGroups().contains(this.getPrinterGroup())) {
            return true;
        }
        if (this.getVirtualPrinter() == null) {
            return true;
        }
        boolean met = false;
        for (WorkflowEvent event : workflow.getEvents()) {
            if (!WorkflowEventType.Print.equals((Object)event.getEventType())) continue;
            WorkflowPrintEvent printEvent = (WorkflowPrintEvent)event;
            VirtualPrinter printer = printEvent.getVirtualPrinter();
            met = this.getVirtualPrinter().equals(printer);
            if (this.getPrinterGroup() != null) {
                boolean bl = met = met && this.getPrinterGroup().equals(printEvent.getPrinterGroup());
            }
            if (!met) continue;
            return true;
        }
        return false;
    }

    @Override
    protected WorkflowCondition createCondition(WorkflowActionSet parent) {
        WorkflowPrintedCondition condition = new WorkflowPrintedCondition(parent);
        condition.setVirtualPrinter(this.getVirtualPrinter());
        condition.setPrinterGroup(this.getPrinterGroup());
        return condition;
    }

    @Override
    protected String verbaliseCondition() {
        StringBuilder SB = new StringBuilder("Docket for ");
        if (this.getPrinterGroup() == null) {
            SB.append("all printer groups have ");
        } else {
            SB.append("printer group ").append(this.getPrinterGroup().getLabel()).append(" has ");
        }
        if (this.isLogicalNot()) {
            SB.append("not ");
        }
        SB.append("been printed to ").append(this.getVirtualPrinter() == null ? "nowhere " : this.getVirtualPrinter().getLabel());
        return SB.toString();
    }

    @Override
    public WorkflowConditionType getConditionType() {
        return WorkflowConditionType.Printed;
    }

    @Override
    public WorkflowCondition copyNoID(WorkflowActionSet newActionSet) {
        WorkflowPrintedCondition newCondition = new WorkflowPrintedCondition(newActionSet);
        newCondition.setVirtualPrinter(this.getVirtualPrinter());
        newCondition.setPrinterGroup(this.getPrinterGroup());
        newCondition.setLogicalNot(this.isLogicalNot());
        return newCondition;
    }

    public static class Props
    extends WorkflowCondition.Props {
        public PropertiedObject.Property<VirtualPrinter> VIRTUAL_PRINTER;
        public PropertiedObject.Property<PrinterGroup> PRINTER_GROUP;
    }
}

