/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action.condition;

import au.com.ordermate.persistence.PropertiedObject;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.condition.WorkflowCondition;
import ordermate.database.workflow.action.condition.WorkflowConditionType;
import ordermate.database.workflow.event.WorkflowEvent;
import ordermate.database.workflow.event.WorkflowEventType;
import ordermate.database.workflow.event.WorkflowScannedEvent;

public class WorkflowScannedCondition
extends WorkflowCondition {
    public static final Props Properties = new Props();
    private String scannedAt;

    public WorkflowScannedCondition() {
    }

    public WorkflowScannedCondition(WorkflowActionSet set) {
        super(set);
    }

    public String getScannedAt() {
        return this.scannedAt;
    }

    public void setScannedAt(String value) {
        this.scannedAt = value;
        if (this.scannedAt != null && this.scannedAt.trim().isEmpty()) {
            this.scannedAt = null;
        }
    }

    @Override
    public WorkflowConditionType getConditionType() {
        return WorkflowConditionType.Scanned;
    }

    @Override
    protected boolean isConditionMet(Workflow workflow) {
        for (WorkflowEvent event : workflow.getEvents()) {
            if (!WorkflowEventType.Scanned.equals((Object)event.getEventType())) continue;
            if (this.scannedAt != null && ((WorkflowScannedEvent)event).getScannedAt() != null) {
                if (!this.scannedAt.equalsIgnoreCase(((WorkflowScannedEvent)event).getScannedAt())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    protected WorkflowCondition createCondition(WorkflowActionSet parent) {
        WorkflowScannedCondition condition = new WorkflowScannedCondition(parent);
        condition.setScannedAt(this.getScannedAt());
        return condition;
    }

    @Override
    protected String verbaliseCondition() {
        if (this.scannedAt == null) {
            return "Account has been scanned";
        }
        return "Account has been scanned at " + this.scannedAt;
    }

    @Override
    public WorkflowCondition copyNoID(WorkflowActionSet newActionSet) {
        WorkflowScannedCondition newCondition = new WorkflowScannedCondition(newActionSet);
        return newCondition;
    }

    public static final class Props
    extends WorkflowCondition.Props {
        public PropertiedObject.Property<String> SCANNED_AT;
    }
}

