/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action.condition;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.condition.WorkflowCondition;
import ordermate.database.workflow.action.condition.WorkflowConditionType;

public class WorkflowTableGroupCondition
extends WorkflowCondition {
    public static final Props Properties = new Props();
    private Reference<TableGroup> tableGroup;

    @Deprecated
    public WorkflowTableGroupCondition() {
        this.tableGroup = this.createReference(WorkflowTableGroupCondition.Properties.TABLE_GROUP);
    }

    public WorkflowTableGroupCondition(WorkflowActionSet parent) {
        super(parent);
        this.tableGroup = this.createReference(WorkflowTableGroupCondition.Properties.TABLE_GROUP);
    }

    public void setTableGroup(TableGroup yourGroup) {
        this.tableGroup.set(yourGroup);
    }

    public TableGroup getTableGroup() {
        return this.tableGroup.get();
    }

    @Override
    public WorkflowConditionType getConditionType() {
        return WorkflowConditionType.TableGroup;
    }

    @Override
    protected boolean isConditionMet(Workflow workflow) {
        Account account = workflow.getAccount();
        LogicalTable table = null;
        if (account instanceof TableAccount) {
            table = ((TableAccount)account).getTable();
        } else if (account instanceof BarTabAccount) {
            table = ((BarTabAccount)account).getLogicalTable();
        }
        if (table != null) {
            if (this.tableGroup.isNull()) {
                return table.getTableGroup() == null;
            }
            return this.tableGroup.get().equals(table.getTableGroup());
        }
        return false;
    }

    @Override
    protected WorkflowCondition createCondition(WorkflowActionSet parent) {
        WorkflowTableGroupCondition newCond = new WorkflowTableGroupCondition(parent);
        newCond.setTableGroup(this.getTableGroup());
        return newCond;
    }

    @Override
    protected String verbaliseCondition() {
        StringBuilder SB = new StringBuilder("Account's table ");
        if (this.isLogicalNot()) {
            SB.append("does not belong to ");
        } else {
            SB.append("belongs to ");
        }
        SB.append(this.getTableGroup() == null ? "No Group" : this.getTableGroup().getLabel());
        return SB.toString();
    }

    @Override
    public WorkflowCondition copyNoID(WorkflowActionSet newActionSet) {
        WorkflowTableGroupCondition newCondition = new WorkflowTableGroupCondition(newActionSet);
        newCondition.setTableGroup(this.getTableGroup());
        newCondition.setLogicalNot(this.isLogicalNot());
        return newCondition;
    }

    public static class Props
    extends WorkflowCondition.Props {
        public PropertiedObject.Property<TableGroup> TABLE_GROUP;
    }
}

