/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action.condition;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.List;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.condition.WorkflowCondition;
import ordermate.database.workflow.action.condition.WorkflowConditionType;
import ordermate.database.workflow.event.WorkflowEvent;
import ordermate.database.workflow.event.WorkflowEventType;
import ordermate.database.workflow.event.WorkflowPrintEvent;

public class WorkflowTimeCondition
extends WorkflowCondition {
    public static final Props Properties = new Props();
    private int elapsed;
    private Reference<PrinterGroup> printerGroup;
    private Reference<VirtualPrinter> virtualPrinter;

    public WorkflowTimeCondition() {
        this.printerGroup = this.createReference(WorkflowTimeCondition.Properties.PRINTER_GROUP);
        this.virtualPrinter = this.createReference(WorkflowTimeCondition.Properties.VIRTUAL_PRINTER);
    }

    public WorkflowTimeCondition(WorkflowActionSet parent) {
        super(parent);
        this.printerGroup = this.createReference(WorkflowTimeCondition.Properties.PRINTER_GROUP);
        this.virtualPrinter = this.createReference(WorkflowTimeCondition.Properties.VIRTUAL_PRINTER);
        this.elapsed = 60;
    }

    public int getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(int value) {
        this.elapsed = value;
        this.clearLabel();
    }

    public PrinterGroup getPrinterGroup() {
        return this.printerGroup.get();
    }

    public void setPrinterGroup(PrinterGroup value) {
        this.printerGroup.set(value);
        this.clearLabel();
    }

    public VirtualPrinter getVirtualPrinter() {
        return this.virtualPrinter.get();
    }

    public void setVirtualPrinter(VirtualPrinter value) {
        this.virtualPrinter.set(value);
        this.clearLabel();
    }

    @Override
    protected boolean isConditionMet(Workflow workflow) {
        if (this.getPrinterGroup() != null && !workflow.getCurrentlyHandledPrinterGroups().contains(this.getPrinterGroup())) {
            return true;
        }
        WorkflowEvent sigEvent = null;
        long dif = 0L;
        if (this.getPrinterGroup() != null && this.getVirtualPrinter() != null) {
            List<WorkflowEvent> events = workflow.getEvents();
            for (WorkflowEvent event : events) {
                if (!WorkflowEventType.Print.equals((Object)event.getEventType())) continue;
                WorkflowPrintEvent printEvent = (WorkflowPrintEvent)event;
                if (!this.getPrinterGroup().equals(printEvent.getPrinterGroup()) || !this.getVirtualPrinter().equals(printEvent.getVirtualPrinter())) continue;
                sigEvent = printEvent;
            }
            if (sigEvent == null) {
                return false;
            }
            dif = System.currentTimeMillis() - sigEvent.getWhenCreated().getTime();
        } else {
            dif = System.currentTimeMillis() - workflow.getDateCreated().getTime();
        }
        return (long)(1000 * this.elapsed) < dif;
    }

    @Override
    protected WorkflowCondition createCondition(WorkflowActionSet parent) {
        WorkflowTimeCondition newCond = new WorkflowTimeCondition(parent);
        newCond.setElapsed(this.getElapsed());
        newCond.setVirtualPrinter(this.getVirtualPrinter());
        newCond.setPrinterGroup(this.getPrinterGroup());
        return newCond;
    }

    @Override
    protected String verbaliseCondition() {
        StringBuilder SB = new StringBuilder().append(this.elapsed).append(" seconds have elapsed since ");
        if (this.getPrinterGroup() != null && this.getVirtualPrinter() != null) {
            SB.append(this.getPrinterGroup().getLabel()).append(" was printed to ").append(this.getVirtualPrinter().getLabel());
        } else {
            SB.append(" workflow created");
        }
        return SB.toString();
    }

    @Override
    public WorkflowConditionType getConditionType() {
        return WorkflowConditionType.Time;
    }

    @Override
    public WorkflowCondition copyNoID(WorkflowActionSet newActionSet) {
        WorkflowTimeCondition newCondition = new WorkflowTimeCondition(newActionSet);
        newCondition.setElapsed(this.getElapsed());
        newCondition.setVirtualPrinter(this.getVirtualPrinter());
        newCondition.setPrinterGroup(this.getPrinterGroup());
        newCondition.setLogicalNot(this.isLogicalNot());
        return newCondition;
    }

    public static class Props
    extends WorkflowCondition.Props {
        public PropertiedObject.Property<PrinterGroup> PRINTER_GROUP;
        public PropertiedObject.Property<VirtualPrinter> VIRTUAL_PRINTER;
        public PropertiedObject.Property ELAPSED;
    }
}

