/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.action.condition;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.text.DecimalFormat;
import java.util.Calendar;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.action.WorkflowActionSet;
import ordermate.database.workflow.action.condition.WorkflowCondition;
import ordermate.database.workflow.action.condition.WorkflowConditionType;

public class WorkflowTimeDueCondition
extends WorkflowCondition {
    public static final Props Properties = new Props();
    private int timeBefore;

    public WorkflowTimeDueCondition() {
    }

    public WorkflowTimeDueCondition(WorkflowActionSet parent) {
        super(parent);
        this.timeBefore = 60;
    }

    public int getTimeBefore() {
        return this.timeBefore;
    }

    public void setTimeBefore(int value) {
        this.timeBefore = value;
        this.clearLabel();
    }

    @Override
    protected boolean isConditionMet(Workflow workflow) {
        long now;
        if (workflow.getAccount().getTimeDue() == null) {
            return true;
        }
        long timeDue = this.getAdjustedDueTime(workflow).getTimeInMillis() / 1000L;
        long dif = timeDue - (now = System.currentTimeMillis() / 1000L);
        return (long)this.timeBefore > dif;
    }

    @Override
    protected WorkflowCondition createCondition(WorkflowActionSet parent) {
        WorkflowTimeDueCondition newCond = new WorkflowTimeDueCondition(parent);
        newCond.setTimeBefore(this.getTimeBefore());
        return newCond;
    }

    @Override
    protected String verbaliseCondition() {
        StringBuilder SB = new StringBuilder();
        if (this.isLogicalNot()) {
            SB.append(" NOT ");
        }
        SB.append(new DecimalFormat("#.#").format((double)Math.abs(this.timeBefore) / 60.0));
        if (this.timeBefore < 0) {
            SB.append(" minutes after Time Due");
        } else {
            SB.append(" minutes before Time Due");
        }
        return SB.toString();
    }

    @Override
    public WorkflowConditionType getConditionType() {
        return WorkflowConditionType.TimeDue;
    }

    @Override
    public WorkflowCondition copyNoID(WorkflowActionSet newActionSet) {
        WorkflowTimeDueCondition newCondition = new WorkflowTimeDueCondition(newActionSet);
        newCondition.setTimeBefore(this.getTimeBefore());
        newCondition.setLogicalNot(this.isLogicalNot());
        return newCondition;
    }

    protected Calendar getAdjustedDueTime(Workflow workflow) {
        Calendar cal = Calendar.getInstance();
        if (workflow.getAccount().getTimeDue() != null) {
            if (workflow.getAccount().getDateDue() != null) {
                cal.setTime(DateTimeUtils.combineDateAndTime(workflow.getAccount().getDateDue(), workflow.getAccount().getTimeDue()));
            } else {
                cal.setTime(DateTimeUtils.combineDateAndTime(workflow.getAccount().getCreationDateTime(), workflow.getAccount().getTimeDue()));
            }
        } else {
            cal.setTime(workflow.getAccount().getCreationDateTime());
        }
        return cal;
    }

    public static class Props
    extends WorkflowCondition.Props {
        public PropertiedObject.Property TIME_BEFORE;
    }
}

