/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.event;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.event.WorkflowEvent;
import ordermate.database.workflow.event.WorkflowEventType;

public class WorkflowKTSEvent
extends WorkflowEvent {
    public static final Props Properties = new Props();
    private Reference<KTSDocketPrinter> ktsPrinter;
    private KTSDocketState docketState;

    public WorkflowKTSEvent() {
        this.ktsPrinter = this.createReference(WorkflowKTSEvent.Properties.KTS_PRINTER);
    }

    public WorkflowKTSEvent(Workflow workflow, KTSDocketPrinter thePrinter, KTSDocketState theState) {
        super(workflow);
        this.ktsPrinter = this.createReference(WorkflowKTSEvent.Properties.KTS_PRINTER);
        this.setKtsPrinter(thePrinter);
        this.docketState = theState;
    }

    @Override
    public WorkflowEventType getEventType() {
        return WorkflowEventType.KTS;
    }

    public KTSDocketState getDocketState() {
        return this.docketState;
    }

    protected void setDocketState(KTSDocketState newState) {
        this.docketState = newState;
    }

    public KTSDocketPrinter getKtsPrinter() {
        return this.ktsPrinter.get();
    }

    protected void setKtsPrinter(KTSDocketPrinter value) {
        this.ktsPrinter.set(value);
    }

    @Override
    public WorkflowEvent copyNoID(Workflow newWorkflow) {
        WorkflowKTSEvent newEvent = new WorkflowKTSEvent(newWorkflow, this.getKtsPrinter(), this.getDocketState());
        newEvent.setWhenCreated(this.getWhenCreated());
        return newEvent;
    }

    public static class Props
    extends WorkflowEvent.Props {
        public PropertiedObject.Property<KTSDocketPrinter> KTS_PRINTER;
        public PropertiedObject.Property<KTSDocketState> DOCKET_STATE;
    }
}

