/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.workflow.event;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.workflow.Workflow;
import ordermate.database.workflow.event.WorkflowEvent;
import ordermate.database.workflow.event.WorkflowEventType;

public class WorkflowPrintEvent
extends WorkflowEvent {
    public static final Props Properties = new Props();
    private Reference<VirtualPrinter> virtualPrinter;
    private Reference<PhysicalPrintDevice> physicalPrintDevice;
    private Reference<PrinterGroup> printerGroup;

    public WorkflowPrintEvent() {
        this.virtualPrinter = this.createReference(WorkflowPrintEvent.Properties.VIRTUAL_PRINTER);
        this.physicalPrintDevice = this.createReference(WorkflowPrintEvent.Properties.PHYSICAL_PRINT_DEVICE);
        this.printerGroup = this.createReference(WorkflowPrintEvent.Properties.PRINTER_GROUP);
    }

    public WorkflowPrintEvent(Workflow theWorkflow, PhysicalPrintDevice printDevice, VirtualPrinter printer, PrinterGroup group) {
        super(theWorkflow);
        this.virtualPrinter = this.createReference(WorkflowPrintEvent.Properties.VIRTUAL_PRINTER);
        this.physicalPrintDevice = this.createReference(WorkflowPrintEvent.Properties.PHYSICAL_PRINT_DEVICE);
        this.printerGroup = this.createReference(WorkflowPrintEvent.Properties.PRINTER_GROUP);
        this.setPhysicalPrintDevice(printDevice);
        this.setVirtualPrinter(printer);
        this.setPrinterGroup(group);
    }

    public VirtualPrinter getVirtualPrinter() {
        return this.virtualPrinter.get();
    }

    protected void setVirtualPrinter(VirtualPrinter value) {
        this.virtualPrinter.set(value);
    }

    public PhysicalPrintDevice getPhysicalPrintDevice() {
        return this.physicalPrintDevice.get();
    }

    protected void setPhysicalPrintDevice(PhysicalPrintDevice value) {
        this.physicalPrintDevice.set(value);
    }

    public PrinterGroup getPrinterGroup() {
        return this.printerGroup.get();
    }

    protected void setPrinterGroup(PrinterGroup group) {
        this.printerGroup.set(group);
    }

    @Override
    public WorkflowEventType getEventType() {
        return WorkflowEventType.Print;
    }

    @Override
    public WorkflowEvent copyNoID(Workflow newWorkflow) {
        WorkflowPrintEvent newEvent = new WorkflowPrintEvent(newWorkflow, this.getPhysicalPrintDevice(), this.getVirtualPrinter(), this.getPrinterGroup());
        newEvent.setWhenCreated(this.getWhenCreated());
        return newEvent;
    }

    public static class Props
    extends WorkflowEvent.Props {
        public PropertiedObject.Property<VirtualPrinter> VIRTUAL_PRINTER;
        public PropertiedObject.Property<PhysicalPrintDevice> PHYSICAL_PRINT_DEVICE;
        public PropertiedObject.Property<PrinterGroup> PRINTER_GROUP;
    }
}

