/*
 * Decompiled with CFR 0.152.
 */
package ordermate.dbconnection;

import au.com.ordermate.persistence.database.DatabaseConnection;
import au.com.ordermate.persistence.database.datasourcefactory.DataSourceFactory;
import au.com.ordermate.sql.HSQLDBDialect;
import au.com.ordermate.sql.SQL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import ordermate.database.DBConnectionInterface;
import ordermate.dbconnection.DatabaseControl;

public abstract class AbstractDatabaseConnection
implements DBConnectionInterface {
    private static final Map<AbstractDatabaseConnection, Object> dbConnections = new WeakHashMap<AbstractDatabaseConnection, Object>();
    private ReentrantLock lock = new ReentrantLock();
    private static long queryCount = 0L;

    public abstract Connection getDBConnection() throws SQLException;

    public abstract String getDatabaseName();

    public static DBConnectionInterface getDBConnectionInterface(DataSourceFactory dsFactory) {
        if (dsFactory != null) {
            return new DatabaseConnection(dsFactory);
        }
        return AbstractDatabaseConnection.getDBConnectionInterface();
    }

    public static long getQueryCount() {
        return queryCount;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public static DBConnectionInterface getDBConnectionInterface() {
        return new DatabaseControl(true);
    }

    public AbstractDatabaseConnection() {
        dbConnections.put(this, null);
    }

    @Override
    public void closeConnection() {
        try {
            Connection con = this.getDBConnection();
            if (con != null && !con.isClosed()) {
                con.close();
            }
            dbConnections.remove(this);
        }
        catch (SQLException ex) {
            Logger.getGlobal().log(Level.SEVERE, "Cannot close off database connection.", ex);
        }
    }

    public static void closeAllConnectionsOnExit() {
        Logger.getGlobal().log(Level.INFO, "Closing all database connections on exit.");
        for (AbstractDatabaseConnection connWrapper : dbConnections.keySet()) {
            try {
                Connection conn = connWrapper.getDBConnection();
                if (conn.isClosed()) continue;
                conn.close();
            }
            catch (Exception ex) {
                Logger.getGlobal().log(Level.WARNING, "Exception closing database connection " + connWrapper, ex);
            }
        }
    }

    @Override
    public void execute(String query, Object ... params) throws SQLException {
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getDBConnection();
            statement = connection.prepareStatement(query);
            this.fillOutParams(statement, params);
            ++queryCount;
            if (this.isDebugEnabled()) {
                System.out.println("DatabaseConnection Executing Update : \n" + query + "\nWith params: " + Arrays.toString(params) + "\nTotal Queries : " + queryCount);
            }
            statement.execute();
        }
        catch (SQLException e) {
            try {
                this.checkError(e);
                throw e;
            }
            catch (Throwable throwable) {
                this.release(statement, connection);
                throw throwable;
            }
        }
        this.release(statement, connection);
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        return this.executeQuery(query, new Object[0]);
    }

    @Override
    public ResultSet executeQuery(String query, Object ... params) throws SQLException {
        PreparedStatement statement = null;
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.getDBConnection();
            statement = connection.prepareStatement(query);
            this.fillOutParams(statement, params);
            ++queryCount;
            if (this.isDebugEnabled()) {
                System.out.println("DatabaseConnection Executing query : \n" + query + "\nWith params: " + Arrays.toString(params) + "\nTotal Queries : " + queryCount);
            }
            rs = statement.executeQuery();
            return rs;
        }
        catch (SQLException e) {
            try {
                if (statement != null) {
                    this.release(statement, connection);
                }
            }
            catch (SQLException ex) {
                Logger.getGlobal().log(Level.WARNING, "Could not release statement when exception was thrown.  Cause of original exception follows this messages", ex);
            }
            this.checkError(e);
            throw new SQLException(query, e);
        }
    }

    @Override
    public void execute(String query) throws SQLException {
        this.execute(query, new Object[0]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized long executeInsert(String query, Object ... params) throws SQLException {
        long l;
        Connection connection = null;
        PreparedStatement statement = null;
        Statement lastInsertIDPS = null;
        try {
            connection = this.getDBConnection();
            statement = SQL.supportsReturnGeneratedKeys() ? connection.prepareStatement(query, 1) : connection.prepareStatement(query);
            this.fillOutParams(statement, params);
            queryCount += 2L;
            if (this.isDebugEnabled()) {
                System.out.println("DatabaseConnection Executing insert: \n" + query + "\nWith params: " + Arrays.toString(params) + "\nTotal Queries : " + queryCount);
            }
            ResultSet rs = null;
            statement.execute();
            if (SQL.supportsReturnGeneratedKeys()) {
                rs = statement.getGeneratedKeys();
            } else {
                lastInsertIDPS = connection.createStatement();
                rs = lastInsertIDPS.executeQuery(SQL.lastInsertID());
            }
            long ID = -1L;
            if (rs.next()) {
                ID = rs.getLong(1);
            } else {
                Logger.getGlobal().log(Level.WARNING, "Cannot retrieve the last inserted ID (" + query + ").");
            }
            if (ID <= 0L && !(SQL.getDialect() instanceof HSQLDBDialect)) {
                throw new SQLException("Insert statement returned ID value of : " + ID);
            }
            this.release(rs);
            l = ID;
        }
        catch (SQLException e) {
            try {
                this.checkError(e);
                throw new SQLException(query, e);
                catch (Exception oe) {
                    Logger.getGlobal().log(Level.SEVERE, "Error while trying to execute a SQL operation.", oe);
                    throw new SQLException(oe);
                }
            }
            catch (Throwable throwable) {
                this.release(statement, connection);
                this.release(lastInsertIDPS, connection);
                throw throwable;
            }
        }
        this.release(statement, connection);
        this.release(lastInsertIDPS, connection);
        return l;
    }

    @Override
    public long executeInsert(String query) throws SQLException {
        return this.executeInsert(query, new Object[0]);
    }

    private void fillOutParams(PreparedStatement query, Object[] params) throws SQLException {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                java.util.Date parm;
                if (params[i] instanceof java.util.Date && params[i] != null && !((parm = (java.util.Date)params[i]) instanceof Date) && !(parm instanceof Time) && !(parm instanceof Timestamp)) {
                    params[i] = new Timestamp(parm.getTime());
                }
                query.setObject(i + 1, params[i]);
            }
        }
    }

    protected abstract void release(Statement var1, Connection var2) throws SQLException;

    @Override
    public abstract void release(ResultSet var1) throws SQLException;

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    protected synchronized void checkError(Exception e) {
        if (e instanceof SQLException) {
            int retryCount = 0;
            SQLException newSQLError = null;
            while (retryCount < 5 && !this.isConnected()) {
                ++retryCount;
                try {
                    this.reconnect();
                    Logger.getGlobal().log(Level.SEVERE, "Successfully reconnected to database");
                }
                catch (SQLException err) {
                    newSQLError = err;
                }
            }
            if (!this.isConnected()) {
                Logger.getGlobal().log(Level.SEVERE, "Tried to unsuccessfully reconnect 5 times. Giving up. Exception while trying to reconnect was: ", newSQLError);
            }
        }
    }

    public boolean isConnected() {
        Connection conn = null;
        try {
            conn = this.getDBConnection();
        }
        catch (SQLException sqle) {
            Logger.getGlobal().log(Level.SEVERE, sqle.getMessage());
            return false;
        }
        if (conn == null) {
            return false;
        }
        try {
            return !conn.isClosed();
        }
        catch (SQLException e) {
            Logger.getGlobal().log(Level.SEVERE, e.getMessage());
            return false;
        }
    }

    public synchronized PreparedStatement createPreparedStatement(String query) {
        try {
            Connection theConn = this.getDBConnection();
            if (theConn == null || theConn.isClosed()) {
                throw new IllegalStateException("Cannot call createPreparedStatement() without active connection");
            }
            PreparedStatement ps = theConn.prepareStatement(query);
            return ps;
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.SEVERE, "Error creating prepared statement", e);
            return null;
        }
    }

    public synchronized Statement createStatement() {
        try {
            Connection theConn = this.getDBConnection();
            if (theConn == null || theConn.isClosed()) {
                throw new IllegalStateException("Cannot call createStatement without active connection");
            }
            return theConn.createStatement();
        }
        catch (Exception ex) {
            Logger.getGlobal().log(Level.SEVERE, "Error creating statement object", ex);
            return null;
        }
    }
}

