/*
 * Decompiled with CFR 0.152.
 */
package ordermate.dbconnection;

import au.com.ordermate.configuration.Config;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class DatabaseConnectionFactory {
    public final Connection connectDB() throws ClassNotFoundException, SQLException {
        String dbName = Config.getStringValue("database_name");
        if (dbName == null) {
            return null;
        }
        return this.connectDB(dbName);
    }

    public final Connection connectDB(String dbName) throws ClassNotFoundException, SQLException {
        String port = Config.getStringValue("database_port");
        port = port != null && !port.isEmpty() ? ":" + port : ":3307";
        String dbDriverName = Config.getStringValue("database_driver_name");
        String dbPrefix = Config.getStringValue("database_prefix") + "://" + Config.getStringValue("database_server") + port + "/";
        String username = Config.getDecryptedStringValue("database_username");
        String password = Config.getDecryptedStringValue("database_password");
        String characterEncoding = "utf8";
        String jdbcUrl = dbPrefix + dbName;
        Properties params = new Properties();
        params.put("user", username);
        params.put("password", password);
        params.put("characterEncoding", characterEncoding);
        params.put("useUnicode", "true");
        params.put("jdbcurl", jdbcUrl);
        params.put("databaseName", dbName);
        Class.forName(dbDriverName);
        Connection con = DriverManager.getConnection(jdbcUrl, params);
        con.setCatalog(dbName);
        return con;
    }
}

