/*
 * Decompiled with CFR 0.152.
 */
package ordermate.dbconnection;

import au.com.ordermate.configuration.Config;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import ordermate.database.DBConnectionInterface;
import ordermate.dbconnection.AbstractDatabaseConnection;
import ordermate.dbconnection.DatabaseConnectionFactory;

public class DatabaseControl
extends AbstractDatabaseConnection
implements DBConnectionInterface {
    private Connection theConn = null;
    private PrintStream sqlOut = null;
    private String dbName;

    public DatabaseControl(boolean connectNow) {
        if (connectNow) {
            try {
                this.connectDB();
            }
            catch (ClassNotFoundException e) {
                Logger.getGlobal().log(Level.SEVERE, "Couldn't load Database driver: " + Config.getStringValue("database_driver_name"), e);
            }
            catch (SQLException e) {
                Logger.getGlobal().log(Level.SEVERE, "Couldn't obtain database connection.", e);
            }
        }
    }

    public DatabaseControl() throws ClassNotFoundException, SQLException {
        this(null);
    }

    public DatabaseControl(PrintStream newSqlOut) throws ClassNotFoundException, SQLException {
        this.sqlOut = newSqlOut;
        this.connectDB();
    }

    public boolean connectDB() throws ClassNotFoundException, SQLException {
        this.dbName = Config.getStringValue("database_name");
        if (this.dbName == null) {
            return false;
        }
        return this.connectDB(this.dbName);
    }

    public boolean connectHeadOfficeDB() throws ClassNotFoundException, SQLException {
        this.dbName = Config.getStringValue("head_office_database_name");
        if (this.dbName == null || this.dbName.trim().isEmpty()) {
            return false;
        }
        return this.connectDB(this.dbName);
    }

    public final synchronized void disconnectDB() throws SQLException {
        if (this.theConn != null && !this.theConn.isClosed()) {
            this.theConn.close();
        }
    }

    @Override
    public synchronized PreparedStatement createPreparedStatement(String query) {
        try {
            if (this.theConn == null || this.theConn.isClosed()) {
                throw new IllegalStateException("Cannot call createPreparedStatement() without active connection");
            }
            PreparedStatement ps = this.theConn.prepareStatement(query);
            if (this.sqlOut != null) {
                this.sqlOut.println(query);
            }
            return ps;
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.SEVERE, "Error creating prepared statement", e);
            return null;
        }
    }

    @Override
    public synchronized Statement createStatement() {
        try {
            if (this.theConn == null || this.theConn.isClosed()) {
                Logger.getGlobal().log(Level.WARNING, "Connection to db was not available, reconnecting.");
                this.connectDB();
                if (this.theConn == null) {
                    throw new IllegalStateException("Cannot call createStatement without active connection");
                }
            }
            return this.theConn.createStatement();
        }
        catch (Exception ex) {
            Logger.getGlobal().log(Level.SEVERE, "Error creating statement object", ex);
            return null;
        }
    }

    public synchronized boolean connectDB(String name) throws SQLException, ClassNotFoundException {
        if (this.theConn != null && !this.theConn.isClosed()) {
            throw new IllegalStateException("An active connection is already in use, cannot connect twice.");
        }
        this.dbName = name;
        this.theConn = new DatabaseConnectionFactory().connectDB(name);
        return this.theConn != null && !this.theConn.isClosed();
    }

    @Override
    public synchronized void reconnect() throws SQLException {
        try {
            this.disconnectDB();
            this.connectDB(this.dbName);
        }
        catch (ClassNotFoundException e) {
            Logger.getGlobal().log(Level.SEVERE, "Error loading the database driver : " + e, e);
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            Logger.getGlobal().log(Level.SEVERE, "Error reconnecting : " + e, e);
            throw e;
        }
    }

    public String toString() {
        return this.getDatabaseName();
    }

    @Override
    public synchronized Connection getDBConnection() {
        if (this.theConn == null) {
            throw new IllegalStateException("There is no current database connection.");
        }
        return this.theConn;
    }

    @Override
    protected void release(Statement statement, Connection connection) throws SQLException {
        if (statement != null) {
            statement.close();
        }
    }

    @Override
    public void release(ResultSet set) throws SQLException {
        if (set == null) {
            return;
        }
        try {
            Statement statement = set.getStatement();
            this.release(statement, null);
        }
        catch (Exception ex) {
            Logger.getGlobal().log(Level.WARNING, "Exception releasing prepared statement", ex);
        }
        try {
            set.close();
        }
        catch (Exception ex) {
            Logger.getGlobal().log(Level.WARNING, "Exception releasing result set", ex);
        }
    }

    @Override
    public String getDatabaseName() {
        return this.dbName;
    }
}

