/*
 * Decompiled with CFR 0.152.
 */
package ordermate.dbconnection.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ordermate.database.DBConnectionInterface;
import ordermate.dbconnection.metadata.FKColumnAbnormalTableMap;

public class MetaDataHelper {
    private DBConnectionInterface dc;
    private List<String> allTables;
    protected static FKColumnAbnormalTableMap abnormalTableMap = new FKColumnAbnormalTableMap();

    public MetaDataHelper(DBConnectionInterface newDc) {
        this.dc = newDc;
        this.populateAbnormalTableMapping();
    }

    protected void populateAbnormalTableMapping() {
    }

    public String toString() {
        return this.dc.toString();
    }

    public DBConnectionInterface getDatabaseConnection() {
        return this.dc;
    }

    public List<String> getAllTables() throws SQLException {
        if (this.allTables == null) {
            ResultSet resultSet = null;
            try {
                resultSet = this.dc.executeQuery("SHOW FULL TABLES WHERE TABLE_TYPE NOT LIKE 'VIEW'");
                this.allTables = this.singleColumnResultSetToListOfStrings(resultSet);
            }
            finally {
                if (resultSet != null && !resultSet.isClosed()) {
                    resultSet.close();
                }
            }
        }
        return this.allTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTables(String prefix) throws SQLException {
        ResultSet resultSet = null;
        try {
            List<String> retVal;
            resultSet = this.dc.executeQuery("SHOW TABLES LIKE '" + prefix + "%'");
            List<String> list = retVal = this.singleColumnResultSetToListOfStrings(resultSet);
            return list;
        }
        finally {
            if (resultSet != null && !resultSet.isClosed()) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getColumns(String tableName) throws SQLException {
        try (ResultSet resultSet = null;){
            List<String> retVal;
            resultSet = this.dc.executeQuery("SHOW COLUMNS FROM " + tableName);
            List<String> list = retVal = this.singleColumnResultSetToListOfStrings(resultSet);
            return list;
        }
    }

    public boolean hasColumn(String tableName, String columnName) throws SQLException {
        Iterator<String> columnsIt = this.getColumns(tableName).iterator();
        while (columnsIt.hasNext()) {
            String currentColumn = columnsIt.next().toString();
            if (!currentColumn.equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTable(String tableName) throws SQLException {
        Iterator<String> it = this.getAllTables().iterator();
        while (it.hasNext()) {
            if (!it.next().toString().equalsIgnoreCase(tableName)) continue;
            return true;
        }
        return false;
    }

    public boolean isFKColumn(String column) {
        if (column.length() < 3) {
            return false;
        }
        return column.substring(0, 3).equalsIgnoreCase("FK_");
    }

    public ColumnDescription describeColumn(String table, String column) throws SQLException {
        ResultSet rs = this.dc.executeQuery("DESCRIBE " + table + " " + column);
        if (rs.next()) {
            return new ColumnDescription(rs);
        }
        throw new SQLException("Could not find column : " + table + "." + column);
    }

    public String getFKColumnTableRefence(String column) {
        if (!this.isFKColumn(column)) {
            throw new IllegalArgumentException("Cannot get table for column that " + column + " is not an FKColumn");
        }
        if (abnormalTableMap.isInAbnormalFKColumnMap(column)) {
            return abnormalTableMap.getTableName(column);
        }
        return column.substring(3);
    }

    private List<String> singleColumnResultSetToListOfStrings(ResultSet resultSet) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        while (resultSet.next()) {
            list.add(resultSet.getString(1));
        }
        return list;
    }

    public static class ColumnDescription {
        public final String name;
        public final String type;
        public final boolean allowsNull;
        public final String defaultVal;

        public ColumnDescription(ResultSet descData) throws SQLException {
            boolean fieldCol = true;
            int typeCol = 2;
            int allowNullCol = 3;
            int defaultValCol = 5;
            this.name = descData.getString(1);
            this.type = descData.getString(2);
            this.allowsNull = descData.getString(3).equals("YES");
            this.defaultVal = descData.getString(5);
        }
    }
}

