/*
 * Decompiled with CFR 0.152.
 */
package ordermate.dbconnection.metadata.sanityCheck;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import ordermate.dbconnection.metadata.MetaDataHelper;
import ordermate.dbconnection.metadata.sanityCheck.AbstractSanityCheckCommand;
import ordermate.signals.Signal;

public class CheckCorrectColumnsAndTablesExist
extends AbstractSanityCheckCommand {
    private MetaDataHelper saneDB;
    private MetaDataHelper checkThisDB;

    public CheckCorrectColumnsAndTablesExist(MetaDataHelper newSaneDB, MetaDataHelper checkDB, Signal updateSignal) {
        super(updateSignal);
        this.saneDB = newSaneDB;
        this.checkThisDB = checkDB;
    }

    @Override
    public boolean execute() throws SQLException {
        this.sendStatusUpdateMsg("checking columns in sanityDB are in " + this.checkThisDB.toString());
        boolean returnVal = true;
        returnVal &= this.checkAllTables(this.saneDB, this.checkThisDB);
        this.sendStatusUpdateMsg("checking columns in " + this.checkThisDB.toString() + " are in sanityDB.");
        return returnVal &= this.checkAllTables(this.checkThisDB, this.saneDB);
    }

    private boolean checkAllTables(MetaDataHelper sane, MetaDataHelper checkThis) throws SQLException {
        boolean returnVal = true;
        List<String> saneTables = sane.getAllTables();
        List<String> checkTables = checkThis.getAllTables();
        if (saneTables.size() != checkTables.size()) {
            returnVal = false;
            String msg = "Sanity database and " + checkThis.toString() + " have a differing number of tables.  Need to find the missing tables.";
            this.getErrorList().add(msg);
        }
        Iterator<String> saneTablesIt = sane.getAllTables().iterator();
        while (saneTablesIt.hasNext()) {
            String currentTable = saneTablesIt.next().toString();
            if (!checkThis.hasTable(currentTable)) {
                this.getErrorList().add(currentTable + " not present in " + checkThis);
                returnVal = false;
                continue;
            }
            List<String> checkColumns = checkThis.getColumns(currentTable);
            if (checkColumns.size() == 0) {
                this.getErrorList().add(currentTable + " has no columns in " + checkThis);
                returnVal = false;
                continue;
            }
            Iterator<String> saneColumnsIt = sane.getColumns(currentTable).iterator();
            while (saneColumnsIt.hasNext()) {
                String currentColumn = saneColumnsIt.next().toString();
                if (checkThis.hasColumn(currentTable, currentColumn)) continue;
                this.getErrorList().add(currentTable + " is missing column " + currentColumn + " in " + checkThis);
                returnVal = false;
            }
        }
        return returnVal;
    }
}

