/*
 * Decompiled with CFR 0.152.
 */
package ordermate.dbconnection.metadata.sanityCheck;

import java.sql.SQLException;
import java.util.Iterator;
import ordermate.dbconnection.metadata.MetaDataHelper;
import ordermate.dbconnection.metadata.sanityCheck.AbstractSanityCheckCommand;
import ordermate.signals.Signal;

public class CheckFKColumnsRefValidTable
extends AbstractSanityCheckCommand {
    private MetaDataHelper databaseToCheck;

    public CheckFKColumnsRefValidTable(MetaDataHelper newDatabaseToCheck, Signal updateSignal) {
        super(updateSignal);
        this.databaseToCheck = newDatabaseToCheck;
    }

    @Override
    public boolean execute() throws SQLException {
        boolean foundAnFKColumn = false;
        int countMissingColumns = 0;
        this.sendStatusUpdateMsg("checking FK Columns reference valid tables...");
        Iterator<String> tablesIt = this.databaseToCheck.getAllTables().iterator();
        while (tablesIt.hasNext()) {
            String currentTable = tablesIt.next().toString();
            Iterator<String> columnsIt = this.databaseToCheck.getColumns(currentTable).iterator();
            while (columnsIt.hasNext()) {
                String currentColumn = columnsIt.next().toString();
                if (!this.databaseToCheck.isFKColumn(currentColumn)) continue;
                if (!this.databaseToCheck.hasTable(this.databaseToCheck.getFKColumnTableRefence(currentColumn))) {
                    this.getErrorList().add("Cannot find table referenced by column.  Column: " + currentTable + "." + currentColumn + " expected table :" + this.databaseToCheck.getFKColumnTableRefence(currentColumn) + " not found.");
                    this.sendStatusUpdateMsg(++countMissingColumns + " FK Column reference table/s not found.");
                    continue;
                }
                foundAnFKColumn = true;
            }
        }
        if (!foundAnFKColumn) {
            this.getErrorList().add("doCheckFKColumnReferencesValidTables did not find any FKReference columns to check.");
            return false;
        }
        return true;
    }
}

